/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.sql.SQLException;

public class PrepInfoItemLob
extends PrepInfoItem {
    private GenericTeradataConnection m_con;

    public PrepInfoItemLob(GenericTeradataConnection genericTeradataConnection, Log log, short s) {
        super(log, s);
        this.m_con = genericTeradataConnection;
    }

    public Object produce(TDPacketStream tDPacketStream, boolean bl) throws SQLException {
        Object object = new byte[]{};
        int n = UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort());
        int n2 = tDPacketStream.position();
        this.log.debug("Locator length:" + n);
        if (n >= 2) {
            long l = tDPacketStream.getLong();
            this.log.debug("lobLength:" + l);
            tDPacketStream.position(n2);
            byte[] byArray = new byte[n];
            tDPacketStream.get(byArray);
            short s = JDBC4Constants.getTDBasicType(this.getDataType());
            switch (s) {
                case 408: {
                    object = this.m_con.constructLocatorBlob(l, byArray);
                    break;
                }
                case 424: {
                    object = this.m_con.constructLocatorClob(l, byArray);
                    break;
                }
                case 860: 
                case 872: {
                    object = this.m_con.constructLocatorSQLXML(s, l, byArray);
                }
            }
        }
        return bl ? null : object;
    }
}

