/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoField;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.LimitedContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.MetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoXParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class StatementInfoParcel
extends PrepInfoXParcel {
    private DataInfoField[] dataInfoField;
    private int m_nDataInfoSize;
    private int m_nTotalFieldCountWithAttrib;
    private boolean m_bContainsFullContentMetadata = false;
    private ArrayList listParameterMarkerMetadataItems = new ArrayList();
    private ArrayList listRSColumnMetadataItems = new ArrayList();
    private ArrayList listRSSummaryMetadataItems = new ArrayList();
    private ArrayList listAGKColumnMetadataItems = new ArrayList();
    private ArrayList listSPParameterMetadataItems = new ArrayList();
    private ArrayList listSPColumnMetadataItems = new ArrayList();

    public StatementInfoParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection, String string, Log log) throws SQLException {
        super(tDPacketStream, genericTeradataConnection, string, log);
        Stack<MetadataItem> stack = new Stack<MetadataItem>();
        int n = this.bodyLength();
        while (n > 0) {
            MetadataItem metadataItem = this.createMetadataItem(tDPacketStream);
            n -= metadataItem.getHeaderLength() + metadataItem.getItemLength();
            if (metadataItem.getItemLayoutType() != 4) {
                while (!stack.empty() && metadataItem instanceof FullContentMetadataItem && ((FullContentMetadataItem)stack.peek()).getStructDepth() >= ((FullContentMetadataItem)metadataItem).getStructDepth()) {
                    stack.pop();
                }
                if (!stack.empty() && metadataItem instanceof FullContentMetadataItem) {
                    ((FullContentMetadataItem)stack.peek()).addAttributeItem((FullContentMetadataItem)metadataItem);
                } else {
                    switch (metadataItem.getItemContentType()) {
                        case 1: {
                            this.listParameterMarkerMetadataItems.add(metadataItem);
                            break;
                        }
                        case 2: {
                            this.listRSColumnMetadataItems.add(metadataItem);
                            break;
                        }
                        case 3: {
                            this.listRSSummaryMetadataItems.add(metadataItem);
                            break;
                        }
                        case 4: {
                            this.listAGKColumnMetadataItems.add(metadataItem);
                            break;
                        }
                        case 5: {
                            this.listSPParameterMetadataItems.add(metadataItem);
                            break;
                        }
                        case 6: {
                            this.listSPColumnMetadataItems.add(metadataItem);
                            break;
                        }
                        case 7: {
                            break;
                        }
                    }
                }
                if (!(metadataItem instanceof FullContentMetadataItem) || !((FullContentMetadataItem)metadataItem).isStruct() && !((FullContentMetadataItem)metadataItem).isArray()) continue;
                stack.push(metadataItem);
                continue;
            }
            stack.clear();
        }
        this.translateSIPintoPrepInfoItem(string, log);
    }

    public StatementInfoParcel(String string, Log log, ArrayList arrayList) throws SQLException {
        super(string, log);
        this.listRSColumnMetadataItems.addAll(arrayList);
        this.translateSIPintoPrepInfoItem(string, log);
    }

    private void translateSIPintoPrepInfoItem(String string, Log log) throws SQLException {
        ArrayList arrayList = this.listRSColumnMetadataItems != null && this.listRSColumnMetadataItems.size() > 0 ? this.listRSColumnMetadataItems : (this.listSPParameterMetadataItems != null && this.listSPParameterMetadataItems.size() > 0 ? this.listSPParameterMetadataItems : (this.listSPColumnMetadataItems != null && this.listSPColumnMetadataItems.size() > 0 ? this.listSPColumnMetadataItems : (this.listAGKColumnMetadataItems != null && this.listAGKColumnMetadataItems.size() > 0 ? this.listAGKColumnMetadataItems : null)));
        ArrayList arrayList2 = new ArrayList();
        this.translateMetadataItems(arrayList, arrayList2);
        this.items = arrayList2.toArray(new PrepInfoItem[0]);
    }

    private void translateMetadataItems(ArrayList arrayList, ArrayList arrayList2) throws JDBCException {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                LimitedContentMetadataItem limitedContentMetadataItem = (LimitedContentMetadataItem)iterator.next();
                if (JDBC4Constants.getTDTypeParameterMode(limitedContentMetadataItem.getDataType()) == 1) continue;
                PrepInfoItem prepInfoItem = StatementInfoParcel.createPrepInfoItem(this.m_con, this.log, limitedContentMetadataItem.getDataType(), this.decimalShift());
                arrayList2.add(prepInfoItem);
                prepInfoItem.setDataLen(limitedContentMetadataItem.getPrepInfoDataLength(this.decimalShift()));
                prepInfoItem.setCharSetName(this.charSetName);
                if (!(limitedContentMetadataItem instanceof FullContentMetadataItem)) continue;
                FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)limitedContentMetadataItem;
                prepInfoItem.setColumnExtInfo(fullContentMetadataItem.getColumnExtInfo());
                prepInfoItem.setColumnName(fullContentMetadataItem.getCustomerVisibleColumnName());
                prepInfoItem.setColumnFormat(fullContentMetadataItem.getFormat());
                prepInfoItem.setColumnTitle(fullContentMetadataItem.getTitle());
                if (!fullContentMetadataItem.isStruct() && !fullContentMetadataItem.isArray()) continue;
                this.translateMetadataItems(fullContentMetadataItem.getAttributeItemList(), fullContentMetadataItem.isArray() ? prepInfoItem.getArrayBasePrepInfoItems() : arrayList2);
            }
        }
    }

    private MetadataItem createMetadataItem(TDPacketStream tDPacketStream) throws SQLException {
        MetadataItem metadataItem;
        short s = tDPacketStream.getShort();
        short s2 = tDPacketStream.getShort();
        short s3 = tDPacketStream.getShort();
        switch (s) {
            case 1: {
                this.m_bContainsFullContentMetadata = true;
                metadataItem = new FullContentMetadataItem(s, s2, s3);
                break;
            }
            case 2: {
                metadataItem = new LimitedContentMetadataItem(s, s2, s3);
                break;
            }
            default: {
                metadataItem = new MetadataItem(s, s2, s3);
            }
        }
        metadataItem.readItemBody(tDPacketStream, this.charSetName);
        return metadataItem;
    }

    public ArrayList getParameterMarkerMetadataItems() {
        return this.listParameterMarkerMetadataItems;
    }

    public ArrayList getRSColumnMetadataItems() {
        return this.listRSColumnMetadataItems;
    }

    public ArrayList getRSSummaryMetadataItems() {
        return this.listRSSummaryMetadataItems;
    }

    public ArrayList getAGKColumnMetadataItems() {
        return this.listAGKColumnMetadataItems;
    }

    public ArrayList getSPParameterMetadataItems() {
        return this.listSPParameterMetadataItems;
    }

    public ArrayList getSPColumnMetadataItems() {
        return this.listSPColumnMetadataItems;
    }

    public StatementInfoParcel(String string, Log log, boolean bl, DataInfoField[] dataInfoFieldArray, int n, int n2) throws JDBCException {
        super(string, log);
        this.setAltHeader(bl);
        this.setFlavor(bl ? (short)-32599 : 169);
        this.m_nTotalFieldCountWithAttrib = n2;
        this.m_nDataInfoSize = 0;
        this.dataInfoField = new DataInfoField[n];
        if (dataInfoFieldArray != null) {
            int n3 = 0;
            for (int i = 0; i < dataInfoFieldArray.length; ++i) {
                if (dataInfoFieldArray[i] == null || dataInfoFieldArray[i].getType() <= 0) continue;
                this.dataInfoField[n3] = dataInfoFieldArray[i];
                if (dataInfoFieldArray[i].isStruct() || dataInfoFieldArray[i].isArray()) {
                    this.m_nDataInfoSize += dataInfoFieldArray[i].getStructSize(string);
                    this.m_nDataInfoSize += this.dataInfoField[n3].copyAttributeInfo(dataInfoFieldArray[i].getAttributeFieldArray(), (short)1, string);
                } else {
                    this.m_nDataInfoSize += 16;
                }
                ++n3;
            }
        }
    }

    public static int getParcelLength(boolean bl, int n, int n2) {
        return Parcel.calculateHeaderLength(bl) + n * 6 + n2 + 6 + 0;
    }

    public boolean containsFullContentMetadata() {
        return this.m_bContainsFullContentMetadata;
    }

    public TDPacketStream toStream() throws JDBCException {
        int n = StatementInfoParcel.getParcelLength(this.altHeader, this.m_nTotalFieldCountWithAttrib, this.m_nDataInfoSize);
        this.setLength(n);
        this.createBuffer(this.getLength());
        super.toStream();
        StatementInfoParcel.putDataInfoFields(this.buffer, this.charSetName, this.dataInfoField, false);
        this.buffer.putShort((short)4);
        this.buffer.putShort((short)8);
        this.buffer.putShort((short)0);
        this.buffer.flip();
        return this.buffer;
    }

    private static void putDataInfoFields(TDPacketStream tDPacketStream, String string, DataInfoField[] dataInfoFieldArray, boolean bl) throws JDBCException {
        if (dataInfoFieldArray != null) {
            for (int i = 0; i < dataInfoFieldArray.length; ++i) {
                bl = dataInfoFieldArray[i].isStruct() || dataInfoFieldArray[i].isArray() || bl;
                tDPacketStream.putShort(bl ? (short)5 : 2);
                tDPacketStream.putShort((short)8);
                tDPacketStream.putShort(bl ? dataInfoFieldArray[i].getStructSize(string) : (short)16);
                tDPacketStream.putShort((short)dataInfoFieldArray[i].getType());
                tDPacketStream.putLong(484 == JDBC4Constants.getTDBasicType(dataInfoFieldArray[i].getType()) ? (long)(dataInfoFieldArray[i].getPrecision() <= 2 ? 1 : (dataInfoFieldArray[i].getPrecision() <= 4 ? 2 : (dataInfoFieldArray[i].getPrecision() <= 9 ? 4 : (dataInfoFieldArray[i].getPrecision() <= 18 ? 8 : 16)))) : dataInfoFieldArray[i].getLength());
                tDPacketStream.putShort((short)dataInfoFieldArray[i].getPrecision());
                tDPacketStream.putShort((short)0);
                tDPacketStream.putShort((short)dataInfoFieldArray[i].getScale());
                if (bl) {
                    byte[] byArray;
                    try {
                        byArray = dataInfoFieldArray[i].getFullyQualifiedTypeName().getBytes(string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw ErrorFactory.makeDriverJDBCException("TJ212", string);
                    }
                    tDPacketStream.putShort(dataInfoFieldArray[i].getStructDepth());
                    tDPacketStream.putShort((short)byArray.length);
                    tDPacketStream.put(byArray);
                    tDPacketStream.putShort((short)0);
                    tDPacketStream.putShort(dataInfoFieldArray[i].getServerDataType());
                    if (dataInfoFieldArray[i].isArray()) {
                        tDPacketStream.putShort(dataInfoFieldArray[i].getArrayDimensions());
                        for (int j = 1; j <= dataInfoFieldArray[i].getArrayDimensions(); ++j) {
                            tDPacketStream.putInt(dataInfoFieldArray[i].getArrayCardinality(j));
                        }
                    }
                }
                if (!dataInfoFieldArray[i].isStruct() && !dataInfoFieldArray[i].isArray()) continue;
                StatementInfoParcel.putDataInfoFields(tDPacketStream, string, dataInfoFieldArray[i].getAttributeFieldArray(), true);
                if (dataInfoFieldArray[i].getStructDepth() != 0) continue;
                bl = false;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Log.LINE_SEP).append("*** StatementInfoParcel ***").append(Log.LINE_SEP).append(Log.LINE_SEP);
        ArrayList[] arrayListArray = new ArrayList[]{this.listParameterMarkerMetadataItems, this.listRSColumnMetadataItems, this.listRSSummaryMetadataItems, this.listAGKColumnMetadataItems, this.listSPParameterMetadataItems, this.listSPColumnMetadataItems};
        for (int i = 0; i < arrayListArray.length; ++i) {
            stringBuffer.append("*** Begin List with ").append(arrayListArray[i].size()).append(" items ***").append(Log.LINE_SEP).append(Log.LINE_SEP);
            Iterator iterator = arrayListArray[i].iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString()).append(Log.LINE_SEP);
            }
            stringBuffer.append("*** End of List ***").append(Log.LINE_SEP).append(Log.LINE_SEP);
        }
        return stringBuffer.toString();
    }
}

