/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.ifsupport.ClientObject;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveElicitDataReceivedSubState;
import com.teradata.jdbc.jdbc_4.statemachine.SendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementAbortState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.IOException;

public class ElicitFileState
extends SendState {
    private String fileName = null;
    private TDPacketStream buffer;
    private boolean eof = false;
    private ClientObject clientObject = null;

    public ElicitFileState(StatementController statementController, String string) {
        super(statementController);
        this.fileName = string;
    }

    public TDParcelState action() throws JDBCException {
        int n = 0;
        try {
            if (this.clientObject == null) {
                try {
                    this.clientObject = new ClientObject(this.fileName);
                }
                catch (JDBCException jDBCException) {
                    this.log.info("The Teradata JDBC Driver could not find resource " + this.fileName + " requested by the database." + " The Teradata JDBC Driver will send zero-length data to the database," + " which should cause the database to return a 5602 error and abort the request.", jDBCException);
                }
                catch (IOException iOException) {
                    this.log.error("The Teradata JDBC Driver could not begin loading resource " + this.fileName + " requested by the database." + " The Teradata JDBC Driver will send zero-length data to the database," + " which should cause the database to return a 5602 error and abort the request.", iOException);
                }
            }
            this.initPacket();
            this.buffer = this.packet.getBuffer();
            n = this.putMultiPartData();
            n += this.putFileData();
            n += this.putLength(n);
            if (this.clientObject == null || this.clientObject.getEOF()) {
                n += this.putEndMultiPart();
                if (this.clientObject != null) {
                    this.clientObject.close();
                }
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            return this.sendAbort(ErrorFactory.makeDriverJDBCException("TJ363", iOException.getMessage()));
        }
        this.packet.addToMsgLength(n);
        this.sendPacket();
        return this.returnToController();
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    protected void initPacket() throws JDBCException {
        this.initializePacket(1);
        this.packet.setLANKind((byte)13);
        this.packet.setClassType((byte)2);
        this.packet.setRequestNumber(this.controller.getSession().getCurrentRequestNum());
    }

    private int putMultiPartData() {
        this.buffer.putShort((short)-32628);
        return 2;
    }

    private int putEndMultiPart() {
        this.buffer.putShort((short)-32627);
        this.buffer.putShort((short)0);
        this.buffer.putInt(8);
        return 8;
    }

    private int putFileData() throws IOException {
        int n = 0;
        this.buffer.position(60);
        int n2 = this.clientObject == null ? 0 : this.clientObject.read(this.buffer, this.maxSize());
        return n += n2;
    }

    private int putLength(int n) {
        this.buffer.putShort(54, (short)0);
        this.buffer.putInt(56, n + 6);
        return 6;
    }

    protected TDParcelState returnToController() {
        StatementReceiveState statementReceiveState = new StatementReceiveState(this.controller);
        if (!this.eof) {
            ReceiveElicitDataReceivedSubState receiveElicitDataReceivedSubState = new ReceiveElicitDataReceivedSubState(statementReceiveState, this);
            statementReceiveState.setHistoricalState(receiveElicitDataReceivedSubState);
        }
        return statementReceiveState;
    }

    private TDParcelState sendAbort(JDBCException jDBCException) throws JDBCException {
        this.log.debug("ElicitFileState: Sending an Abort Message");
        StatementAbortState statementAbortState = new StatementAbortState(this.controller);
        statementAbortState.setUCAbort(true);
        this.controller.setStoredException(jDBCException);
        return statementAbortState;
    }

    private int maxSize() {
        return 64000;
    }
}

