/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedBatchStatementSendState;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.util.ArrayList;

public class PreparedBatchStatementController
extends PreparedStatementController {
    private PreparedBatchStatementSendState batchSendState;

    public PreparedBatchStatementController(TDStatement tDStatement, TDSession tDSession, String string) throws JDBCException {
        super(tDStatement, tDSession, string);
    }

    public void addResults(ArrayList arrayList) {
        this.getStatement().getResults().addBatchResults(arrayList);
    }

    public void run() throws SQLException {
        TDParcelState tDParcelState = null;
        if (this.getHistoricalState() == null) {
            tDParcelState = new PreparedBatchStatementSendState(this);
            this.batchSendState = (PreparedBatchStatementSendState)tDParcelState;
            this.clearStatementStateLock = true;
        } else {
            tDParcelState = this.getHistoricalState();
            this.setHistoricalState(null);
        }
        this.runBody(tDParcelState);
    }

    protected TDParcelState handleRunException(JDBCException jDBCException) throws JDBCException {
        int n;
        int n2 = jDBCException.getErrorCode();
        JDBCException jDBCException2 = this.getAndRemoveBatchExceptions();
        int n3 = this.getFailedStatementNumber();
        if (!this.getSession().uncheckedGetAutoCommit() && !this.getSession().isAnsiMode()) {
            n = this.setTeraCommitOffResults(n2);
            if (n3 > 0) {
                n3 += this.batchSendState.paramProperties.getParameterSetIndex() - this.batchSendState.getNumberOfStatementsInSubBatch();
                jDBCException2 = null;
            }
        } else {
            n = this.setStandardResults(n2);
        }
        if (n != ((TDPreparedStatement)this.getStatement()).getNumberOfBatchStatements() || n3 > 0) {
            JDBCException jDBCException3 = n3 > 0 ? ErrorFactory.cloneJDBCException(jDBCException, -1) : null;
            JDBCException jDBCException4 = n3 > 0 ? ErrorFactory.makeDriverJDBCException("TJ646") : jDBCException;
            jDBCException = ErrorFactory.makeChainedBatchJDBCException(jDBCException4, jDBCException3, n3, n);
            if (jDBCException2 != null) {
                jDBCException2.setNextException(jDBCException);
            }
            this.setFailedStatementNumber(0);
            this.addBatchException(jDBCException2 == null ? jDBCException : jDBCException2);
        }
        return this.getNextState(n2);
    }

    private int setStandardResults(int n) throws JDBCException {
        int n2 = this.getNumberOfFailedStatements(n);
        this.addResults(this.initFailedResults(n2));
        return n2;
    }

    private int setTeraCommitOffResults(int n) throws JDBCException {
        int n2 = ((TDPreparedStatement)this.getStatement()).getNumberOfBatchStatements();
        if (n < 2000 && n != 751) {
            this.addResults(this.initFailedResults(n2 -= this.getStatement().getResults().getResultsSize()));
        } else {
            this.getStatement().getResults().reinit();
            this.addResults(this.initFailedResults(n2));
        }
        return n2;
    }

    private TDParcelState getNextState(int n) throws JDBCException {
        if (this.batchSendState.paramProperties.numberOfParamSetsLeft() > 0 && n >= 2000 && (this.getSession().uncheckedGetAutoCommit() || this.getSession().isAnsiMode()) && n != 751) {
            return this.batchSendState;
        }
        return null;
    }

    private int getNumberOfFailedStatements(int n) {
        int n2 = this.batchSendState.getNumberOfStatementsInSubBatch();
        if (n < 2000 || n == 751 && !this.getSession().isAnsiMode() && this.getSession().uncheckedGetAutoCommit()) {
            n2 = ((TDPreparedStatement)this.getStatement()).getNumberOfBatchStatements() - this.getStatement().getResults().getResultsSize();
        }
        return n2;
    }

    private ArrayList initFailedResults(int n) {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Result(-3));
        }
        return arrayList;
    }
}

