/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.ResultArray;
import com.teradata.jdbc.ResultStruct;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.GeneratedKeysRequest;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveContinueSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveEndSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceivePauseSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.util.Iterator;

public class ReceiveRecordSubState
implements TDParcelState {
    private RecordParcel currentEvent;
    private StatementReceiveState compositeState;
    private boolean continuing = false;
    private static long time = 0L;
    private TDParcelState returnSubState;
    boolean processEvents;
    protected Log log;

    public ReceiveRecordSubState(StatementReceiveState statementReceiveState, RecordParcel recordParcel) {
        this.currentEvent = recordParcel;
        this.compositeState = statementReceiveState;
        this.log = this.compositeState.getController().getSession().getLog();
    }

    public TDParcelState action() throws SQLException {
        boolean bl;
        this.processEvents = true;
        Parcel parcel = null;
        this.returnSubState = null;
        long l = System.currentTimeMillis();
        if (!this.continuing && this.currentEvent != null && !this.processRecordParcelAsMessage(this.currentEvent)) {
            this.processRecordParcel(this.currentEvent);
        }
        this.continuing = false;
        int n = this.compositeState.getPacket().nextParcelPeek();
        boolean bl2 = bl = n == 8 || n == 205;
        if (bl) {
            this.processEvents = false;
            this.returnSubState = new ReceiveEndSubState(this.compositeState, null);
        }
        block6: while (this.processEvents) {
            parcel = this.compositeState.getNextParcel();
            if (parcel != null) {
                switch (parcel.getFlavor()) {
                    case 10: 
                    case 144: {
                        if (this.processRecordParcelAsMessage((RecordParcel)parcel)) continue block6;
                        this.processRecordParcel((RecordParcel)parcel);
                        continue block6;
                    }
                    case 11: {
                        boolean bl3;
                        boolean bl4 = this.compositeState.getController().usePositioning();
                        n = this.compositeState.getPacket().nextParcelPeek();
                        boolean bl5 = n == 8 || n == 205;
                        boolean bl6 = bl3 = n == 12;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveRecordSubState.action got PCLENDSTATEMENT, usePositioning=" + bl4 + ", bAnotherBundleComing=" + bl5 + ", bGotEndRequest=" + bl3 + ", this=" + this);
                        }
                        if (bl3) {
                            this.compositeState.getController().getStatement().getResults().markRequestAsComplete();
                        }
                        if (this.compositeState.getCurrentResultSet() != null) {
                            this.compositeState.getCurrentResultSet().lastRowFetched();
                        }
                        if (bl4 && !bl5 && this.compositeState.getCurrentResultSet() != null && !ActivityAnalyzer.outParamResultSet(this.compositeState.getActivityType())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("ReceiveRecordSubState.action calling setAdditionalProcessing, this=" + this);
                            }
                            this.setAdditionalProcessing();
                            continue block6;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveRecordSubState.action NOT calling setAdditionalProcessing, this=" + this);
                        }
                        this.processEvents = false;
                        this.returnSubState = new ReceiveEndSubState(this.compositeState, (EndStatementParcel)parcel);
                        continue block6;
                    }
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode(), errorParcel.getInfo());
                    }
                    case 145: {
                        continue block6;
                    }
                }
                this.log.debug("unexpected parcel: " + parcel.getFlavor());
                throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveRecordSubState.action reached end-of-packet, calling setAdditionalProcessing, this=" + this);
            }
            this.setAdditionalProcessing();
        }
        return this.returnSubState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    private void processRecordParcel(RecordParcel recordParcel) throws JDBCException {
        TDResultSet tDResultSet = this.compositeState.getCurrentResultSet();
        if (tDResultSet == null) {
            return;
        }
        if (tDResultSet.isClosed()) {
            return;
        }
        ResultSetRow resultSetRow = new ResultSetRow();
        RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = recordParcel.getRecordParcelColumnValuesIterator();
        GeneratedKeysRequest generatedKeysRequest = this.compositeState.getController().getStatement().getGeneratedKeysRequest();
        TeraResultSetMetaData teraResultSetMetaData = (TeraResultSetMetaData)((Object)tDResultSet.getMetaData());
        int n = 1;
        TDSession tDSession = this.compositeState.getController().getSession();
        int n2 = 1;
        while (recordParcelColumnValuesIterator.hasNext()) {
            if (generatedKeysRequest == null || !ActivityAnalyzer.update(this.compositeState.getActivityType()) || generatedKeysRequest.addColumn(n2++)) {
                if (n <= teraResultSetMetaData.getColumnCount() && teraResultSetMetaData.getColumnProperties(n).isStruct()) {
                    resultSetRow.addValue(ReceiveRecordSubState.deserializeStructValue(recordParcelColumnValuesIterator, teraResultSetMetaData.getColumnProperties(n), tDSession));
                } else if (n <= teraResultSetMetaData.getColumnCount() && teraResultSetMetaData.getColumnProperties(n).isArray()) {
                    resultSetRow.addValue(ReceiveRecordSubState.deserializeArrayValue(recordParcelColumnValuesIterator, teraResultSetMetaData.getColumnProperties(n), tDSession));
                } else {
                    resultSetRow.addValue(recordParcelColumnValuesIterator.next());
                }
                ++n;
                continue;
            }
            recordParcelColumnValuesIterator.next();
        }
        if (resultSetRow.size() > 0) {
            tDResultSet.addResultSetRow(resultSetRow);
        }
    }

    private boolean processRecordParcelAsMessage(RecordParcel recordParcel) {
        short s = this.compositeState.getLastWarningCode();
        boolean bl = this.compositeState.hasStoredExceptions();
        if (!bl && !ActivityAnalyzer.messagesResultSet(this.compositeState.getActivityType())) {
            return false;
        }
        RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = recordParcel.getRecordParcelColumnValuesIterator();
        while (recordParcelColumnValuesIterator.hasNext()) {
            String string = String.valueOf(recordParcelColumnValuesIterator.next());
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveRecordSubState.processRecordParcelAsMessage: " + (bl ? "Error" : "Warning") + " " + s + " [" + string + "] this=" + this);
            }
            if (bl) {
                this.compositeState.addException(ErrorFactory.makeDatabaseSQLException(string, s));
                continue;
            }
            this.compositeState.addWarning(ErrorFactory.makeDatabaseSQLWarning(string, s));
        }
        return true;
    }

    public void setCurrentEvent(RecordParcel recordParcel) {
        this.currentEvent = recordParcel;
    }

    private void setAdditionalProcessing() {
        boolean bl;
        this.processEvents = false;
        this.continuing = true;
        boolean bl2 = bl = this.compositeState.getController().getStatement().hasGeneratedKeysRequest() && this.compositeState.getController().getResultTypeExpected() == 5;
        if (this.compositeState.getCurrentResultSet() != null && !bl) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveRecordSubState.setAdditionalProcessing setting up pause, this=" + this);
            }
            this.returnSubState = new ReceivePauseSubState(this.compositeState, this, new StatementContinueState(this.compositeState.getController(), this.compositeState));
            this.compositeState.savePrepInfo();
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveRecordSubState.setAdditionalProcessing reading continuously, this=" + this);
            }
            this.returnSubState = new ReceiveContinueSubState(this.compositeState, this);
            this.compositeState.savePrepInfo();
        }
    }

    private static ResultStruct deserializeStructValue(Iterator iterator, ColumnProperties columnProperties, TDSession tDSession) {
        ColumnProperties[] columnPropertiesArray = columnProperties.getAttributePropertiesArray();
        ResultStruct resultStruct = (ResultStruct)iterator.next();
        if (resultStruct != null) {
            resultStruct.initStruct(columnPropertiesArray.length, columnProperties.getColumnTypeName(), tDSession);
        }
        for (int i = 0; iterator.hasNext() && i < columnPropertiesArray.length; ++i) {
            String[] stringArray;
            int[] nArray;
            int[] nArray2;
            Object[] objectArray;
            if (columnPropertiesArray[i].isStruct()) {
                if (resultStruct != null) {
                    resultStruct.setSQLTypeName(columnProperties.getColumnTypeName());
                    objectArray = resultStruct.getMutableAttributeValueArray();
                    nArray2 = resultStruct.getMutableAttributeSQLTypeArray();
                    nArray = resultStruct.getMutableAttributeBaseJDBCTypeArray();
                    stringArray = resultStruct.getMutableAttributeTypeNameArray();
                    nArray2[i] = columnPropertiesArray[i].getColumnType();
                    nArray[i] = columnPropertiesArray[i].getColumnBaseJDBCType();
                    stringArray[i] = columnPropertiesArray[i].getColumnTypeName();
                    objectArray[i] = ReceiveRecordSubState.deserializeStructValue(iterator, columnPropertiesArray[i], tDSession);
                    continue;
                }
                ReceiveRecordSubState.deserializeStructValue(iterator, columnPropertiesArray[i], tDSession);
                continue;
            }
            if (resultStruct != null) {
                objectArray = resultStruct.getMutableAttributeValueArray();
                nArray2 = resultStruct.getMutableAttributeSQLTypeArray();
                nArray = resultStruct.getMutableAttributeBaseJDBCTypeArray();
                stringArray = resultStruct.getMutableAttributeTypeNameArray();
                nArray2[i] = columnPropertiesArray[i].getColumnType();
                nArray[i] = columnPropertiesArray[i].getColumnBaseJDBCType();
                stringArray[i] = columnPropertiesArray[i].getColumnTypeName();
                objectArray[i] = iterator.next();
                continue;
            }
            iterator.next();
        }
        return resultStruct;
    }

    private static ResultArray deserializeArrayValue(RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator, ColumnProperties columnProperties, TDSession tDSession) {
        ColumnProperties columnProperties2 = columnProperties.getAttributePropertiesArray()[0];
        ResultArray resultArray = (ResultArray)recordParcelColumnValuesIterator.next();
        if (resultArray != null) {
            resultArray.initArray(tDSession, columnProperties2, columnProperties.getArrayDimensions(), columnProperties.getArrayMaxCardinalities());
            ResultArray.ArrayElementValuesIterator arrayElementValuesIterator = resultArray.getArrayElementValuesIterator();
            Object[] objectArray = new Object[resultArray.getArrayCardinality()];
            for (int i = 0; arrayElementValuesIterator.hasNext() && i < objectArray.length; ++i) {
                objectArray[i] = columnProperties2.isStruct() ? ReceiveRecordSubState.deserializeStructValue(arrayElementValuesIterator, columnProperties2, tDSession) : arrayElementValuesIterator.next();
            }
            resultArray.setArrayElements(objectArray);
        }
        return resultArray;
    }

    public String toString() {
        return super.toString() + "(compstate=" + this.compositeState + ")";
    }
}

