/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveDataInfoSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveEndSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceivePrepInfoSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveStatementInfoSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class ReceiveSuccessSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private StatementStatusParcel event;
    protected Log log;

    public ReceiveSuccessSubState(StatementReceiveState statementReceiveState, StatementStatusParcel statementStatusParcel) {
        this.compositeState = statementReceiveState;
        this.event = statementStatusParcel;
        this.log = statementReceiveState.getController().getSession().getLog();
        this.compositeState.getController().setCurrentStatementNumber(statementStatusParcel.getStatementNumber());
    }

    public TDParcelState action() throws SQLException {
        Parcel parcel;
        TDParcelState tDParcelState = null;
        this.compositeState.setStatementNumber(this.event.getStatementNumber());
        this.compositeState.setActivityType(this.event.getActivityType());
        this.compositeState.setActivityCount(this.event.getActivityCount());
        this.compositeState.setLastWarningCode(this.event.getLastWarningCode());
        this.compositeState.initPrepInfo();
        if (this.event.getExceptions() != null) {
            this.compositeState.addException(this.event.getExceptions());
        }
        if (this.event.getSQLWarnings() != null) {
            this.compositeState.addWarning(this.event.getSQLWarnings());
        }
        if ((parcel = this.compositeState.getNextParcel()) != null && parcel.getFlavor() == 172) {
            this.compositeState.setStartingRowPosition(((ResultSetParcel)parcel).getStartingRowPosition());
            parcel = this.compositeState.getNextParcel();
        }
        if (parcel != null) {
            switch (parcel.getFlavor()) {
                case 86: {
                    tDParcelState = new ReceivePrepInfoSubState(this.compositeState, (PrepInfoParcel)parcel);
                    break;
                }
                case 125: {
                    tDParcelState = new ReceivePrepInfoSubState(this.compositeState, (PrepInfoParcel)parcel);
                    break;
                }
                case 146: {
                    tDParcelState = new ReceiveDataInfoSubState(this.compositeState, (DataInfoParcel)parcel);
                    break;
                }
                case 71: {
                    tDParcelState = new ReceiveDataInfoSubState(this.compositeState, (DataInfoParcel)parcel);
                    break;
                }
                case 11: {
                    tDParcelState = new ReceiveEndSubState(this.compositeState, (EndStatementParcel)parcel);
                    break;
                }
                case 169: {
                    tDParcelState = new ReceiveStatementInfoSubState(this.compositeState, (StatementInfoParcel)parcel);
                    break;
                }
                default: {
                    throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                }
            }
        }
        return tDParcelState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }
}

