/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.FetchRowCountParcel;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public abstract class SendState
implements TDParcelState {
    protected TDPacket packet;
    private int m_nCurrentFetchRowNumber = -1;
    protected StatementController controller;
    protected Log log;

    public SendState(StatementController statementController) {
        this.controller = statementController;
        this.log = statementController.getSession().getLog();
    }

    protected void initializePacket(int n) throws JDBCException {
        this.packet = this.controller.getSession().createPacket(n);
        this.packet.setInitParcelPosition();
        this.packet.setHostCharSet(this.controller.getSession().getTdSessionCharSetCode());
        this.packet.setSessionNumber(this.controller.getSession().getSessionNum());
        this.packet.setAuthentication(this.controller.getSession().getAuthenticationNonce());
    }

    protected StatementController getController() {
        return this.controller;
    }

    protected TDPacket getPacket() {
        return this.packet;
    }

    public void setCurrentFetchRowNumber(int n) {
        this.m_nCurrentFetchRowNumber = n;
    }

    protected void initFetchRowCountParcel(StatementReceiveState statementReceiveState) throws JDBCException {
        if (this.controller.getSession().getConfigResponse().isFetchRowCountSupported()) {
            int n = statementReceiveState != null && statementReceiveState.getCurrentResultSet() != null && !statementReceiveState.getCurrentResultSet().isClosed() ? statementReceiveState.getCurrentResultSet().getFetchSize() : this.controller.getStatement().getFetchSize();
            int n2 = this.controller.getStatement().getMaxRows();
            if (n2 > 0) {
                boolean bl;
                boolean bl2 = statementReceiveState == null;
                boolean bl3 = bl = this.m_nCurrentFetchRowNumber >= 0;
                if (bl2 || bl) {
                    int n3;
                    int n4 = n3 = this.m_nCurrentFetchRowNumber >= 1 ? n2 - this.m_nCurrentFetchRowNumber + 1 : n2;
                    if (n3 > 0 && (n == 0 || n3 < n)) {
                        n = n3;
                    }
                }
            }
            if (n > 0) {
                this.packet.addParcel(new FetchRowCountParcel(n, this.log));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket() throws JDBCException {
        TDNetworkIOIF tDNetworkIOIF = null;
        if (this.controller.getSession().getEncryptData() && this.controller.getSession().getAuthMethod() != null) {
            this.packet.setEncrypted();
        }
        this.packet.toStream();
        this.log.debug(this.packet.getBuffer());
        this.log.debug("lanheader request no: " + this.packet.getRequestNumber());
        tDNetworkIOIF = this.controller.getNetworkIO();
        tDNetworkIOIF.acquireWriteLock();
        try {
            this.packet.getBuffer().writeStream(tDNetworkIOIF, this.controller.getSession().getTeraEncrypt(), this.controller.getStatement().isFinalized());
        }
        finally {
            tDNetworkIOIF.releaseWriteLock();
        }
    }
}

