/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.parcel.AbortParcel;
import com.teradata.jdbc.jdbc_4.parcel.AbortUCParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.SendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class StatementAbortState
extends SendState {
    private boolean abortTimeoutFlag = false;
    private boolean ucAbort = false;

    public StatementAbortState(StatementController statementController) {
        super(statementController);
    }

    public TDParcelState action() throws JDBCException {
        this.initPacket();
        this.initAbortParcel();
        if (this.controller.getStatement().getState() == 8) {
            this.abortTimeoutFlag = true;
            this.controller.getStatement().setState(9);
        } else {
            this.controller.getStatement().setState(10);
        }
        this.sendPacket();
        return this.returnToController();
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    protected void initPacket() throws JDBCException {
        this.initializePacket(1);
        this.packet.setLANKind((byte)7);
        this.packet.setRequestNumber(this.controller.getCurrentRequestNumber());
    }

    protected void initAbortParcel() throws JDBCException {
        AbortParcel abortParcel = this.ucAbort ? new AbortUCParcel(this.log) : new AbortParcel(this.log);
        this.packet.addParcel(abortParcel);
    }

    protected TDParcelState returnToController() {
        if (this.abortTimeoutFlag || this.ucAbort) {
            return new StatementReceiveState(this.controller);
        }
        return null;
    }

    public void setUCAbort(boolean bl) {
        this.ucAbort = bl;
    }
}

