/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveInitSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementAbortState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementReceiveState
implements TDParcelState {
    private StatementController controller;
    private TDParcelState historicalSubState;
    private TDParcelState subState;
    private TDParcelState returnState;
    private TDPacket packet;
    private TDResultSet currentResultSet;
    private int requestNum;
    private int statementNumber;
    private short activityType;
    private int activityCount;
    private long m_startingRowPosition = 0L;
    private short m_nLastWarningCode;
    private JDBCException exception;
    private PrepInfoParcel savedPrepInfo;
    private boolean cancelFlag = false;
    private int statementReceiveType;
    protected Log log;
    public static final int RCV_PREPARE = 1;
    public static final int RCV_EXEC_AFTER_PREP = 2;
    public static final int RCV_EXECUTE_ONLY = 3;
    public static final int RCV_BOTH_PREP_EXEC = 4;

    public StatementReceiveState(StatementController statementController) {
        this.controller = statementController;
        this.log = statementController.getSession().getLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDParcelState action() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementReceiveState.action this=" + this);
        }
        this.exception = null;
        this.setStatementReceiveType();
        this.packet = this.controller.getSession().createPacket(1);
        TDNetworkIOIF tDNetworkIOIF = this.controller.getNetworkIO();
        Object var2_2 = null;
        tDNetworkIOIF.acquireReadLock();
        try {
            if (this.controller.getStatement().getState() != 8) {
                int n;
                boolean bl = this.controller.getStatement().getState() == 3 || this.controller.getStatement().getState() == 9;
                int n2 = this.controller.getStatement().getRemainingTime();
                int n3 = n = bl ? n2 : 0;
                if (this.log.canLog(1)) {
                    this.log.info("StatementReceiveState.action getState=" + this.controller.getStatement().getState() + " nRemainingTime=" + n2 + " nTimeoutInMs=" + n + " this=" + this);
                }
                this.packet.getBuffer().readStream(tDNetworkIOIF, this.controller.getSession().getTeraEncrypt(), this.controller.getStatement().isFinalized(), n, true);
                if (this.controller.getStatement().getState() == 3) {
                    this.controller.getStatement().setState(4);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("StatementReceiveState.action returned from reading IO, this=" + this);
                }
            } else {
                this.controller.setStoredException(ErrorFactory.makeDriverJDBCException("TJ159", "StatementState.TIMEOUT before receive"));
                this.setUpAbortRequest();
            }
        }
        catch (JDBCException jDBCException) {
            if (jDBCException.getErrorCode() != 802) {
                throw jDBCException;
            }
            if (this.controller.getStatement().getState() == 9 || this.controller.getStatement().getState() == 10) {
                tDNetworkIOIF.close();
                throw ErrorFactory.makeIoJDBCException(this.controller.getStatement().getState() == 9 ? "TJ782" : "TJ783", this.controller.getStatement().getState() == 9 ? "Double query timeout" : "Query timeout after Statement.cancel", tDNetworkIOIF, jDBCException, this.controller.getStatement().isFinalized() ? null : this.log);
            }
            this.controller.setStoredException(jDBCException);
            this.setUpAbortRequest();
        }
        finally {
            tDNetworkIOIF.releaseReadLock();
        }
        if (!this.cancelFlag) {
            this.packet.initParcelFactory(this.controller.getSession());
            this.controller.getSession().setTransactionInProgress(this.packet.inTransaction());
            if (this.savedPrepInfo != null) {
                this.packet.setParcelFactoryPrepInfo(this.savedPrepInfo);
            }
            this.controller.getSession().responseTracker().notifyReceiveResponse(this.controller, this.packet, this.log);
            this.requestNum = this.packet.getRequestNumber();
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementReceiveState.action obtained request number, this=" + this);
            }
            if (this.historicalSubState == null) {
                this.historicalSubState = new ReceiveInitSubState(this);
            }
        }
        if (!this.cancelFlag) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementReceiveState.action packet=" + this.packet + " this=" + this);
                this.log.debug(this.packet.getBuffer());
            }
            try {
                this.subStateMachine();
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            catch (SQLException sQLException) {
                this.returnState = null;
                this.controller.setHistoricalReturnState(null);
                throw sQLException;
            }
        }
        if (this.returnState == null && this.controller.getHistoricalReturnState() != null) {
            this.returnState = this.controller.getHistoricalReturnState();
            this.controller.setHistoricalReturnState(null);
        }
        return this.returnState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    public TDParcelState getReturnState() {
        return this.returnState;
    }

    public void setReturnState(TDParcelState tDParcelState) {
        this.returnState = tDParcelState;
    }

    public TDParcelState getSubState() {
        return this.subState;
    }

    public void setSubState(TDParcelState tDParcelState) {
        this.subState = tDParcelState;
    }

    public TDParcelState getHistoricalState() {
        return this.historicalSubState;
    }

    public void setHistoricalState(TDParcelState tDParcelState) {
        this.historicalSubState = tDParcelState;
    }

    public StatementController getController() {
        return this.controller;
    }

    public void setController(StatementController statementController) {
        this.controller = statementController;
    }

    public TDPacket getPacket() {
        return this.packet;
    }

    public void setPacket(TDPacket tDPacket) {
        this.packet = tDPacket;
    }

    public Parcel getNextParcel() throws SQLException {
        return this.packet.nextParcel();
    }

    public Parcel scanForEndParcel(boolean bl) throws SQLException {
        return this.packet.scanForEndParcel(bl);
    }

    public void subStateMachine() throws SQLException {
        this.subState = this.historicalSubState;
        while (this.subState != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementReceiveState.subStateMachine executing substate=" + this.subState + " this=" + this);
            }
            this.subState = this.subState.action();
        }
    }

    public void addResult(Result result) throws SQLException {
        if (ActivityAnalyzer.outParamResultSet(this.activityType) && result.getType() == 2) {
            result.getResultSet().next();
            this.controller.getStatement().setOutParamResultSet(result.getResultSet());
            if (this.controller.getResultTypeExpected() == 1 || this.controller.getResultTypeExpected() == 5) {
                result = new Result(0);
            } else {
                result = null;
                this.controller.getStatement().getResults().enableDynamicResultSets(this.controller);
            }
        }
        if (result != null) {
            this.controller.getStatement().getResults().addResult(this.controller, result);
        }
    }

    public TDResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    public void setCurrentResultSet(TDResultSet tDResultSet) {
        this.currentResultSet = tDResultSet;
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementReceiveState.setCurrentResultSet this=" + this);
        }
    }

    public int getRequestNum() {
        return this.requestNum;
    }

    public void setRequestNum(int n) {
        this.requestNum = n;
    }

    public int getStatementNumber() {
        return this.statementNumber;
    }

    public void setStatementNumber(int n) {
        this.statementNumber = n;
    }

    public short getActivityType() {
        return this.activityType;
    }

    public void setActivityType(short s) {
        this.activityType = s;
    }

    public int getActivityCount() {
        return this.activityCount;
    }

    public void setActivityCount(int n) {
        this.activityCount = n;
    }

    public short getLastWarningCode() {
        return this.m_nLastWarningCode;
    }

    public void setLastWarningCode(short s) {
        this.m_nLastWarningCode = s;
    }

    public void addWarning(SQLWarning sQLWarning) {
        this.controller.getStatement().addWarning(sQLWarning);
    }

    public void addException(JDBCException jDBCException) {
        if (this.exception == null) {
            this.exception = jDBCException;
        } else {
            this.exception.setNextException(jDBCException);
        }
    }

    protected boolean hasStoredExceptions() {
        return this.exception != null;
    }

    public void setPrepInfo(PrepInfoParcel prepInfoParcel) {
        this.savedPrepInfo = prepInfoParcel;
    }

    public void savePrepInfo() {
        this.savedPrepInfo = this.packet.getParcelFactoryPrepInfo();
    }

    private void setUpAbortRequest() {
        this.controller.getStatement().setState(8);
        this.getController().setResultTypeExpected(4);
        StatementAbortState statementAbortState = new StatementAbortState(this.getController());
        this.returnState = statementAbortState;
        this.controller.setHistoricalReturnState(null);
        this.cancelFlag = true;
        this.controller.getStatement().resetStatementStartTime();
    }

    public boolean preparingRequest() {
        return this.statementReceiveType == 1;
    }

    public void initPrepInfo() throws SQLException {
        if (this.statementReceiveType != 2) {
            return;
        }
        if (this.currentResultSet == null) {
            TeraResultSetMetaData teraResultSetMetaData = this.controller.getStatement().getMetaDataList().getMetaDataForStatement(this.statementNumber);
            this.createCurrentResultSet(teraResultSetMetaData);
            this.savedPrepInfo = teraResultSetMetaData.getPrepInfoParcel();
        } else if (this.controller.getStatement().hasGeneratedKeysRequest() && this.controller.getResultTypeExpected() == 5) {
            ResultSetMetaData resultSetMetaData = this.currentResultSet.getMetaData();
            this.currentResultSet.setNumberOfRows(this.currentResultSet.getNumberOfRows() + (resultSetMetaData.getColumnCount() == 0 ? 0 : this.getActivityCount()));
        }
        this.packet.setParcelFactoryPrepInfo(this.savedPrepInfo);
    }

    public void setStartingRowPosition(long l) {
        this.m_startingRowPosition = l;
    }

    public void createCurrentResultSet(TeraResultSetMetaData teraResultSetMetaData) throws SQLException {
        TDResultSet tDResultSet = this.controller.getSession().constructResultSet(teraResultSetMetaData, this.activityType, (Statement)((Object)this.controller.getStatement()), this.controller, this.log);
        this.setCurrentResultSet(tDResultSet);
        tDResultSet.setNumberOfRows(teraResultSetMetaData.getColumnCount() == 0 ? 0 : this.getActivityCount());
        tDResultSet.setStartingRowPosition(this.m_startingRowPosition);
    }

    private void setStatementReceiveType() throws JDBCException {
        switch (this.controller.getMode()) {
            case 66: {
                this.statementReceiveType = 4;
                break;
            }
            case 69: {
                if (this.controller instanceof PreparedStatementController || this.controller.getStatement().hasGeneratedKeysRequest()) {
                    this.statementReceiveType = 2;
                    break;
                }
                this.statementReceiveType = 3;
                break;
            }
            case 80: 
            case 83: {
                this.statementReceiveType = 1;
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ392");
            }
        }
    }

    public String toString() {
        return super.toString() + "(req#=" + this.requestNum + " stmt#=" + this.statementNumber + " atype=" + this.activityType + " acnt=" + this.activityCount + " currs=" + this.currentResultSet + " ctlr=" + this.controller + ")";
    }
}

