/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.parcel.BigKeepResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.BigResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicRequestParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.KeepResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.KeepResponseParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.SetPositionParcel;
import com.teradata.jdbc.jdbc_4.parcel.SetPositionParcelAltHeader;
import com.teradata.jdbc.jdbc_4.statemachine.LobReceiveController;
import com.teradata.jdbc.jdbc_4.statemachine.SendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.UnsupportedEncodingException;

public class StatementSendState
extends SendState {
    protected int bufferSize = 0;
    protected boolean altHeader = false;
    protected byte[] text;

    public StatementSendState(StatementController statementController) {
        super(statementController);
    }

    public TDParcelState action() throws JDBCException {
        String string = this.controller.getSession().getSerializeDeserializeCharset();
        this.text = this.convertQueryToBytes(this.controller.getQuery(), string);
        this.altHeaderRequired(string);
        this.initPacket();
        this.initOptions(string, this.controller.getMode(), this.controller.getLobSelect());
        this.initIndic(string);
        this.initSubclassParcels();
        this.initSetPosition();
        this.initFetchRowCountParcel(null);
        this.initRsp(string);
        this.sendPacket();
        return this.returnToController();
    }

    protected void initPacket() throws JDBCException {
        this.initializePacket(this.altHeader ? 2 : 1);
        this.packet.setLANKind((byte)5);
        this.packet.setRequestNumber(this.controller.getSession().getRequestNum());
        this.controller.setCurrentRequestNumber(this.packet.getRequestNumber());
        this.controller.getStatement().setCurrentRequestNumber(this.packet.getRequestNumber());
    }

    protected void initOptions(String string, byte by, byte by2) throws JDBCException {
        OptionsParcel optionsParcel = null;
        optionsParcel = this.altHeader ? new OptionsParcelAltHeader(string, this.controller.getSession()) : new OptionsParcel(string, this.controller.getSession());
        optionsParcel.setDBCFunction(by);
        if (this.controller.getSession().isLobSupported()) {
            optionsParcel.setLobSelect(by2);
            optionsParcel.setClobTranslate((byte)85);
        }
        optionsParcel.setRequestMode(this.controller.getStatement().getRequestMode());
        optionsParcel.setReturnStatementInfo(this.controller.getSession().isStatementInfoSupported());
        if (this.controller.getSession().isLargeDecimalAndBigIntSupported()) {
            optionsParcel.setMaxDecimalPrecision(this.controller.getSession().getMaxDecimalPrecision());
        }
        if (this.controller.getSession().areAPHResponsesSupported()) {
            optionsParcel.setAPHResponses((byte)89);
        }
        if (this.controller.getStatement().hasGeneratedKeysRequest() && this.controller.getStatement().getGeneratedKeysRequest().returnsColumn()) {
            optionsParcel.setGenKeyType((byte)67);
        } else if (this.controller.getStatement().hasGeneratedKeysRequest()) {
            optionsParcel.setGenKeyType((byte)82);
        }
        if (this.controller.getSession().dynamicResultSetsSupported()) {
            optionsParcel.setDynamicResultSetAllowed(true);
            if (this.controller instanceof LobReceiveController) {
                optionsParcel.setSPReturnResult((byte)0);
            } else {
                optionsParcel.setSPReturnResult(this.controller.getSession().getSPReturnResult());
            }
        }
        if (this.controller.getSession().isUDTTransformOffSupported()) {
            optionsParcel.setUDTTransformsOff((byte)89);
        }
        if (this.controller.getSession().isPeriodAsStructSupported()) {
            optionsParcel.setReturnPeriodsAsStructs((byte)89);
        }
        if (this.controller.getSession().getConfigResponse().isTrustedSQLSupported() && this.controller.getSession().getURLParameters().getTrustedSQLAwareness()) {
            boolean bl = this.controller.getStatement().getSQLRequestEscapeFunction("TERADATA_UNTRUSTED") != null;
            optionsParcel.setTrustMode(bl ? (byte)78 : 89);
        }
        optionsParcel.setStatementIndependence(this.getStatementIndependenceSetting());
        if (this.controller.getSession().isArrayDataTypeSupported()) {
            optionsParcel.setArrayTransformOff((byte)89);
        }
        if (this.controller.getSession().isXMLDataTypeSupported()) {
            optionsParcel.setXMLDataFormat((byte)67);
        }
        if (this.controller.getSession().getConfigResponse().isFailFastSupported() && this.controller.getStatement().getSQLRequestEscapeFunction("TERADATA_FAILFAST") != null) {
            optionsParcel.setFailFast((byte)89);
        }
        this.packet.addParcel(optionsParcel);
    }

    protected void initIndic(String string) throws JDBCException {
        IndicRequestParcel indicRequestParcel = null;
        indicRequestParcel = this.altHeader ? new IndicRequestParcelAltHeader(string, this.log) : new IndicRequestParcel(string, this.log);
        indicRequestParcel.setRequestText(this.text);
        this.packet.addParcel(indicRequestParcel);
    }

    protected void initSubclassParcels() throws JDBCException {
    }

    protected void initSetPosition() throws JDBCException {
        if (this.controller.usePositioning() && this.controller.getStatement().useKeepResponse()) {
            this.packet.addParcel(this.altHeader ? new SetPositionParcelAltHeader(this.log) : new SetPositionParcel(this.log));
        }
    }

    protected void initRsp(String string) throws JDBCException {
        ResponseParcel responseParcel = null;
        if (this.controller.getStatement().useKeepResponse() && this.controller.getSession().areAPHResponsesSupported()) {
            responseParcel = new BigKeepResponseParcel(string, this.log);
            responseParcel.setMaxMsgSize(this.controller.getSession().getMaxMessageSize(false, false));
        } else if (this.controller.getSession().areAPHResponsesSupported()) {
            responseParcel = new BigResponseParcel(string, this.log);
            responseParcel.setMaxMsgSize(this.controller.getSession().getMaxMessageSize(false, false));
        } else {
            responseParcel = this.getResponseParcel(string);
            responseParcel.setMaxMsgSize(65104);
        }
        this.packet.addParcel(responseParcel);
    }

    private ResponseParcel getResponseParcel(String string) {
        ResponseParcel responseParcel = null;
        responseParcel = this.controller.getStatement().useKeepResponse() ? (this.isAltHeader() ? new KeepResponseParcelAltHeader(string, this.log) : new KeepResponseParcel(string, this.log)) : (this.isAltHeader() ? new ResponseParcelAltHeader(string, this.log) : new ResponseParcel(string, this.log));
        return responseParcel;
    }

    protected TDParcelState returnToController() {
        return new StatementReceiveState(this.controller);
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    protected void altHeaderRequired(String string) throws JDBCException {
        int n;
        this.bufferSize = 52 + OptionsParcel.standardOptionsParcelLength(this.controller.getSession()) + 6 + 4 + this.text.length;
        if (this.bufferSize > 65104 && this.controller.getSession().isAphSupported()) {
            this.altHeader = true;
            this.bufferSize += 12;
        }
        this.log.debug("USING ALTHEADER : " + this.altHeader);
        this.log.debug("Buffer size needed is: " + this.bufferSize);
        int n2 = n = this.altHeader ? this.controller.getSession().getMaxMessageSize(true, false) : 65104;
        if (this.bufferSize > n) {
            throw ErrorFactory.makeDriverJDBCException("TJ313", this.bufferSize, n);
        }
    }

    protected boolean isAltHeader() {
        return this.altHeader;
    }

    protected void setAltHeader(boolean bl) {
        this.altHeader = bl;
    }

    protected void setBufferSize(int n) {
        this.bufferSize = n;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected byte[] convertQueryToBytes(String string, String string2) throws JDBCException {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ309", unsupportedEncodingException.getMessage());
        }
        return byArray;
    }

    protected byte getStatementIndependenceSetting() {
        return 78;
    }
}

