/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import com.teradata.jdbc.jdbc_4.util.InitializedMap;
import java.util.HashMap;
import java.util.Map;

public class JDBC4Constants {
    public static final int DEFAULT_BUFFER_SIZE = 65104;
    public static final int MAX_TOTAL_MSG_SIZE_64KB = 65156;
    public static final int MAX_TOTAL_MSG_SIZE_AFTER_ENCRYPTION = 0x500000;
    public static final int MAX_LOB_DATA_SIZE = 64000;
    public static final int MAX_APH_LOB_DATA_SIZE = 1024000;
    public static final byte TD_DEFAULT_CHARSET_CODE = -1;
    public static final String TD_DEFAULT_CHARSET = "ASCII";
    public static final int MAX_INDIC_DATA_SIZE = 65100;
    public static final int PRECISION_BYTEINT = 3;
    public static final int PRECISION_SMALLINT = 5;
    public static final int PRECISION_INTEGER = 10;
    public static final Integer CTG_CHAR = new Integer(1);
    public static final Integer CTG_TIME_TS = new Integer(2);
    public static final Integer CTG_INTERVAL = new Integer(3);
    private static final HashMap tdToJavaSQLTypes = new HashMap();
    private static final HashMap nullable = new HashMap();
    private static final HashMap tdTypesToTypeNames = new HashMap();
    private static final HashMap tdTypesToDispSize = new HashMap();
    private static final HashMap JavaSQLTypesToSQLTypeName = new HashMap();
    private static final HashMap JavaSQLTypesToJavaClassName = new HashMap();
    private static final HashMap tdTypesToParameterMode = new HashMap();
    private static final HashMap tdTypeToBasicTDType = new HashMap();
    private static final HashMap tdTypesToCategory = new HashMap();
    private static final Map tdTypesToServerDataTypes = new InitializedMap(new HashMap()).add(749, 833).add(761, 837).add(769, 841).add(765, 845).add(773, 849);
    private static final Integer RSMD_NO_NULLS = new Integer(0);
    private static final Integer RSMD_NULLABLE = new Integer(1);
    private static final Integer PARAMETER_UNKNOWN = new Integer(0);
    private static final Integer PARAMETER_IN = new Integer(1);
    private static final Integer PARAMETER_INOUT = new Integer(2);
    private static final Integer PARAMETER_OUT = new Integer(4);
    private static final Integer[] RSMD_NULLABILITES = new Integer[]{RSMD_NO_NULLS, RSMD_NULLABLE, RSMD_NULLABLE, RSMD_NULLABLE, RSMD_NULLABLE};
    private static final Integer[] PARAMETER_MODES = new Integer[]{PARAMETER_UNKNOWN, PARAMETER_UNKNOWN, PARAMETER_IN, PARAMETER_INOUT, PARAMETER_OUT};

    private static void putMaps(int n, int n2, Integer n3, String string, int n4, String string2, String string3) {
        Integer[] integerArray = new Integer[]{new Integer(n), new Integer(n + 1), new Integer(n + 500), new Integer(n + 501), new Integer(n + 502)};
        Integer n5 = new Integer(n2);
        Integer n6 = new Integer(n4);
        for (int i = 0; i < integerArray.length; ++i) {
            if (n != 0) {
                tdTypeToBasicTDType.put(integerArray[i], integerArray[0]);
                tdToJavaSQLTypes.put(integerArray[i], n6);
                nullable.put(integerArray[i], RSMD_NULLABILITES[i]);
                tdTypesToParameterMode.put(integerArray[i], PARAMETER_MODES[i]);
                tdTypesToDispSize.put(integerArray[i], n5);
                tdTypesToCategory.put(integerArray[i], n3);
            }
            if (string == null) continue;
            tdTypesToTypeNames.put(integerArray[i], string);
        }
        JavaSQLTypesToSQLTypeName.put(n6, string2);
        if (string3 != null) {
            JavaSQLTypesToJavaClassName.put(n6, string3);
        }
    }

    public static int getJavaSQLType(int n) {
        Integer n2 = (Integer)tdToJavaSQLTypes.get(new Integer(n));
        return n2 != null ? n2 : 0;
    }

    public static String getJavaSQLTypeName(int n) {
        return (String)JavaSQLTypesToSQLTypeName.get(new Integer(n));
    }

    public static String getJavaClassName(int n) {
        return (String)JavaSQLTypesToJavaClassName.get(new Integer(n));
    }

    public static int getNullable(int n) {
        Integer n2 = (Integer)nullable.get(new Integer(n));
        return n2 != null ? n2 : 2;
    }

    public static String getTDTypeName(int n) {
        return (String)tdTypesToTypeNames.get(new Integer(n));
    }

    public static int getDisplaySize(int n) {
        Integer n2 = (Integer)tdTypesToDispSize.get(new Integer(n));
        return n2 != null ? n2 : 0;
    }

    public static int getTDTypeParameterMode(int n) {
        Object v = tdTypesToParameterMode.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    public static short getTDBasicType(int n) {
        Integer n2 = (Integer)tdTypeToBasicTDType.get(new Integer(n));
        return n2 != null ? n2.shortValue() : (short)0;
    }

    public static boolean isCharType(int n) {
        return JDBC4Constants.getCategory(n) == CTG_CHAR;
    }

    public static Integer getCategory(int n) {
        return (Integer)tdTypesToCategory.get(new Integer(n));
    }

    public static short getServerDataType(int n) {
        Integer n2 = (Integer)tdTypesToServerDataTypes.get(new Integer(n));
        return n2 != null ? n2.shortValue() : (short)0;
    }

    static {
        JDBC4Constants.putMaps(400, 0, null, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(404, 0, null, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(408, 0, null, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(416, 0, CTG_CHAR, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(420, 0, CTG_CHAR, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(424, 0, CTG_CHAR, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(440, 0, null, "", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(448, 0, CTG_CHAR, "VARCHAR", 12, "VARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(452, 0, CTG_CHAR, "CHAR", 1, "CHAR", "java.lang.String");
        JDBC4Constants.putMaps(456, 0, CTG_CHAR, "LONGVARCHAR", -1, "LONGVARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(464, 0, CTG_CHAR, "VARGRAPHIC", 12, "VARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(468, 0, CTG_CHAR, "GRAPHIC", 1, "CHAR", "java.lang.String");
        JDBC4Constants.putMaps(472, 0, CTG_CHAR, "LONGVARGRAPHIC", -1, "LONGVARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(480, 22, null, "FLOAT", 6, "FLOAT", "java.lang.Double");
        JDBC4Constants.putMaps(484, 20, null, "DECIMAL", 3, "DECIMAL", "java.math.BigDecimal");
        JDBC4Constants.putMaps(496, 11, null, "INTEGER", 4, "INTEGER", "java.lang.Integer");
        JDBC4Constants.putMaps(500, 6, null, "SMALLINT", 5, "SMALLINT", "java.lang.Integer");
        JDBC4Constants.putMaps(504, 0, null, "", 2003, "ARRAY", "java.sql.Array");
        JDBC4Constants.putMaps(508, 0, null, "", 2003, "ARRAY", "java.sql.Array");
        JDBC4Constants.putMaps(600, 20, null, "BIGINT", -5, "BIGINT", "java.lang.Long");
        JDBC4Constants.putMaps(604, 47, null, "NUMBER", 2, "NUMERIC", "java.math.BigDecimal");
        JDBC4Constants.putMaps(688, 0, null, "VARBYTE", -3, "VARBINARY", "[B");
        JDBC4Constants.putMaps(692, 0, null, "BYTE", -2, "BINARY", "[B");
        JDBC4Constants.putMaps(696, 0, null, "LONGVARBYTE", -4, "LONGVARBINARY", "[B");
        JDBC4Constants.putMaps(748, 10, null, "DATE", 91, "DATE", "java.sql.Date");
        JDBC4Constants.putMaps(752, 10, null, "DATE", 91, "DATE", "java.sql.Date");
        JDBC4Constants.putMaps(756, 4, null, "BYTEINT", -6, "TINYINT", "java.lang.Integer");
        JDBC4Constants.putMaps(760, 8, CTG_TIME_TS, "TIME", 92, "TIME", "java.sql.Time");
        JDBC4Constants.putMaps(764, 19, CTG_TIME_TS, "TIMESTAMP", 93, "TIMESTAMP", "java.sql.Timestamp");
        JDBC4Constants.putMaps(768, 14, CTG_TIME_TS, "TIME WITH TIME ZONE", 92, "TIME", "java.sql.Time");
        JDBC4Constants.putMaps(772, 25, CTG_TIME_TS, "TIMESTAMP WITH TIME ZONE", 93, "TIMESTAMP", "java.sql.Timestamp");
        JDBC4Constants.putMaps(776, 1, CTG_INTERVAL, "INTERVAL YEAR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(780, 4, CTG_INTERVAL, "INTERVAL YEAR TO MONTH", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(784, 1, CTG_INTERVAL, "INTERVAL MONTH", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(788, 1, CTG_INTERVAL, "INTERVAL DAY", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(792, 4, CTG_INTERVAL, "INTERVAL DAY TO HOUR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(796, 7, CTG_INTERVAL, "INTERVAL DAY TO MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(800, 10, CTG_INTERVAL, "INTERVAL DAY TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(804, 1, CTG_INTERVAL, "INTERVAL HOUR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(808, 4, CTG_INTERVAL, "INTERVAL HOUR TO MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(812, 7, CTG_INTERVAL, "INTERVAL HOUR TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(816, 1, CTG_INTERVAL, "INTERVAL MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(820, 4, CTG_INTERVAL, "INTERVAL MINUTE TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(824, 1, CTG_INTERVAL, "INTERVAL SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(832, 0, null, "PERIOD(DATE)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(836, 0, null, "PERIOD(TIME)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(840, 0, null, "PERIOD(TIME WITH TIME ZONE)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(844, 0, null, "PERIOD(TIMESTAMP)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(848, 0, null, "PERIOD(TIMESTAMP WITH TIME ZONE)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(852, 0, CTG_CHAR, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(856, 0, CTG_CHAR, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(860, 0, CTG_CHAR, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(864, 0, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(868, 0, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(872, 0, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(0, 0, null, null, -7, "BIT", "java.lang.Boolean");
        JDBC4Constants.putMaps(0, 0, null, null, 16, "BOOLEAN", "java.lang.Boolean");
        JDBC4Constants.putMaps(0, 0, null, null, 8, "DOUBLE", "java.lang.Double");
        JDBC4Constants.putMaps(0, 0, null, null, 0, "NULL", null);
        JDBC4Constants.putMaps(0, 0, null, null, 7, "REAL", "java.lang.Double");
    }
}

