/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jalgapi;

import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jalgapi.Encoding;
import com.teradata.tdgss.jalgapi.IllegalEncodingException;
import java.math.BigInteger;
import org.ietf.jgss.GSSException;

public class AlgQopDer {
    private static final String ALG_NAME_NONE = "NONE";
    private static final String ALG_NAME_BLOWFISH = "Blowfish";
    private static final String ALG_NAME_AES = "AES";
    private static final String ALG_NAME_MD5 = "MD5";
    private static final String ALG_NAME_SHA1 = "SHA1";
    private static final String ALG_NAME_DH = "DH";
    private static final String ALG_NAME_SHA256 = "SHA256";
    private static final String ALG_NAME_SHA512 = "SHA512";
    private static final String MODE_TYPE_NONE = "NONE";
    private static final String MODE_TYPE_CBC = "CBC";
    private static final String MODE_TYPE_CFB = "CFB";
    private static final String MODE_TYPE_ECB = "ECB";
    private static final String MODE_TYPE_OFB = "OFB";
    private static final String PADDING_TYPE_NONE = "NoPadding";
    private static final String PADDING_TYPE_OAEPWITHDIGESTANDMGFPADDING = "OAEPWithDIGESTAndMGFPadding";
    private static final String PADDING_TYPE_PKCS1PADDING = "PKCS1Padding";
    private static final String PADDING_TYPE_PKCS5PADDING = "PKCS5Padding";
    private static final String PADDING_TYPE_SSL3PADDING = "SSL3Padding";
    private static final String[] algNames;
    private static final String[] modes;
    private static final String[] paddings;
    private static final String INVALID_QOP_TAG = "Invalid QOP Tag found while decoding!";
    public static final int DEFAULT_QOP = 0;
    public static final int LOW_QOP = 1;
    public static final int MEDIUM_QOP = 2;
    public static final int HIGH_QOP = 3;
    public static final int SUPPORTED_QOP = 4;
    private byte[] derQop;
    private AlgQop[] algQop;

    public AlgQopDer(byte[] byArray) throws GSSException {
        this.derQop = byArray;
        this.algQop = new AlgQop[4];
        for (int i = 0; i < 4; ++i) {
            this.algQop[i] = new AlgQop();
        }
        try {
            this.decodeQop(byArray);
        }
        catch (IllegalEncodingException illegalEncodingException) {
            throw new GSSException(11, -520093471, illegalEncodingException.getMessage());
        }
    }

    private void decodeQop(byte[] byArray) throws IllegalEncodingException {
        Encoding encoding = Encoding.parse(byArray, 0);
        Encoding[] encodingArray = encoding.parse();
        for (int i = 0; i < encodingArray.length; ++i) {
            Encoding encoding2 = encodingArray[i];
            Encoding[] encodingArray2 = encoding2.parse();
            block10: for (int j = 0; j < encodingArray2.length; ++j) {
                Encoding encoding3 = encodingArray2[j];
                byte[] byArray2 = encoding3.getContent();
                BigInteger bigInteger = new BigInteger(byArray2);
                int n = bigInteger.intValue();
                byte by = (byte)encoding3.getTag();
                switch (by) {
                    case 16: {
                        this.algQop[i].setConfidentialityAlgorithm(new String(algNames[n]));
                        continue block10;
                    }
                    case 17: {
                        this.algQop[i].setIntegrityAlgorithm(new String(algNames[n]));
                        continue block10;
                    }
                    case 18: {
                        this.algQop[i].setKeyExchangeAlgorithm(new String(algNames[n]));
                        continue block10;
                    }
                    case 19: {
                        this.algQop[i].setMode(new String(modes[n]));
                        continue block10;
                    }
                    case 20: {
                        this.algQop[i].setPadding(new String(paddings[n]));
                        continue block10;
                    }
                    case 21: {
                        this.algQop[i].setKeyLength(bigInteger.intValue());
                        continue block10;
                    }
                    case 22: {
                        this.algQop[i].setKeyLengthP(bigInteger.intValue());
                        continue block10;
                    }
                    default: {
                        throw new IllegalEncodingException(INVALID_QOP_TAG);
                    }
                }
            }
        }
    }

    public AlgQop getAlgQop(int n) {
        return this.algQop[n];
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = "NONE";
        stringArray[1] = ALG_NAME_BLOWFISH;
        stringArray[2] = ALG_NAME_AES;
        stringArray[3] = ALG_NAME_MD5;
        stringArray[4] = ALG_NAME_SHA1;
        stringArray[5] = ALG_NAME_DH;
        stringArray[6] = ALG_NAME_SHA256;
        stringArray[7] = ALG_NAME_SHA512;
        algNames = stringArray;
        String[] stringArray2 = new String[5];
        stringArray2[0] = "NONE";
        stringArray2[1] = MODE_TYPE_CBC;
        stringArray2[2] = MODE_TYPE_CFB;
        stringArray2[3] = MODE_TYPE_ECB;
        stringArray2[4] = MODE_TYPE_OFB;
        modes = stringArray2;
        String[] stringArray3 = new String[6];
        stringArray3[0] = PADDING_TYPE_NONE;
        stringArray3[1] = PADDING_TYPE_OAEPWITHDIGESTANDMGFPADDING;
        stringArray3[2] = null;
        stringArray3[3] = PADDING_TYPE_PKCS1PADDING;
        stringArray3[4] = PADDING_TYPE_PKCS5PADDING;
        stringArray3[5] = PADDING_TYPE_SSL3PADDING;
        paddings = stringArray3;
    }
}

