/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssUtil;
import com.teradata.tdgss.jgssp2gss.TdSecretKey;
import com.teradata.tdgss.jgssp2td2.TDGSSa;
import com.teradata.tdgss.jgssp2td2.TDGSSb;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GssContext
implements GSSContext {
    private static final String prog = "GssContext";
    private byte contextInit = 0;
    private byte delegRequest = 0;
    private static final int BYTESININT = 4;
    private static final int BITSPERBYTE = 8;
    private static final byte KEYMSG = 3;
    private static final byte CONFMSG = 4;
    private static final byte LOGDATAMSG = 5;
    private static final byte CTX_NEW = 0;
    private static final byte CTX_SETUP_PARTIAL = 1;
    private static final byte CTX_SETUP_COMPLETE_AND_CONTINUE_FOR_SERVER_RESPONSE = 2;
    private static final byte CTX_SETUP_COMPLETE = 3;
    private static final byte CLIENT = 0;
    private static final byte SERVER = 1;
    protected static final byte BIT0 = 1;
    private static final byte BIT1 = 2;
    private static final byte BIT2 = 4;
    private static final byte BIT3 = 8;
    private static final byte BIT4 = 16;
    private static final byte CAP_LOGDATA = 2;
    protected static final byte FLAG_BYTE = 8;
    private static final byte INFOLEN = 16;
    private GSSContext ctx = null;
    private Oid mechOid = null;
    private int msgsequence;
    private byte gss_or_sspi = 0;
    private byte cli_or_server = 0;
    private byte[] td2key;
    private byte ctx_state = 0;
    private static final int KEYLEN = 16;
    private byte krb5_on_mpras = 0;
    private byte krb5_gss = 0;
    private String extlogdata = null;
    private int peercapabilities = 0;
    private MessageDigest WrapDigest;
    private MessageDigest UnwrapDigest;
    private int DigestLength;

    public GssContext(GSSContext gSSContext, Oid oid, String string) throws GSSException {
        if (gSSContext == null) {
            throw new GSSException(11, 0, "Unable to get context");
        }
        this.ctx = gSSContext;
        this.mechOid = oid;
        if (string != null) {
            this.extlogdata = string;
        }
        if (this.mechOid.toString().equals("1.2.840.113554.1.2.2")) {
            this.gss_or_sspi = 0;
        } else if (this.mechOid.toString().equals("1.3.6.1.4.1.191.1.1012.1.6")) {
            this.gss_or_sspi = 1;
        } else {
            throw new GSSException(11, 0, "Neither Sspi or Gss Oid");
        }
        this.msgsequence = 0;
    }

    private byte[] GetMsgInfo(byte by, byte by2, int n) {
        byte[] byArray = new byte[16];
        int n2 = 2;
        byArray[0] = 2;
        byArray[1] = by;
        byArray[2] = by2;
        byArray[3] = this.cli_or_server;
        System.arraycopy(GssUtil.inttobytearray(n), 0, byArray, 4, 4);
        byArray[8] = 3;
        if (this.delegRequest == 1) {
            byArray[8] = (byte)(byArray[8] | 8);
        }
        System.arraycopy(GssUtil.inttobytearray(n2), 0, byArray, 9, 4);
        for (int i = 13; i < 16; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    private int ValidateMsgInfo(byte[] byArray, int n, int n2, byte by, byte by2) throws GSSException {
        GssUtil.hexDump(System.out, byArray);
        if (byArray[n + 1] != by) {
            throw new GSSException(10);
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n + 4, byArray2, 0, 4);
        BigInteger bigInteger = new BigInteger(byArray2);
        int n3 = bigInteger.intValue();
        if (n2 != n3 + 16) {
            throw new GSSException(10);
        }
        if ((byArray[n + 8] & 0x10) == 16) {
            this.krb5_on_mpras = 1;
            if (this.WrapDigest == null) {
                try {
                    this.WrapDigest = MessageDigest.getInstance("SHA1");
                    this.UnwrapDigest = MessageDigest.getInstance("SHA1");
                }
                catch (Exception exception) {
                    GSSException gSSException = new GSSException(11, 0, "MIC Generation Failure");
                    gSSException.initCause(exception);
                    throw gSSException;
                }
                byte[] byArray3 = this.WrapDigest.digest(new byte[0]);
                this.DigestLength = byArray3.length;
            }
        }
        if ((byArray[n + 8] & 1) == 1) {
            this.krb5_gss = 1;
        }
        return n3;
    }

    private byte[] GetTrailerBytes() throws GSSException {
        byte[] byArray = null;
        try {
            TdgssConfigApi tdgssConfigApi = TdgssConfigApi.getInstance();
            if (tdgssConfigApi == null) {
                int n = -520093543;
                throw new GSSException(11, n, "TdgssConfigApi failure");
            }
            byte[] byArray2 = this.getMech().getDER();
            String[] stringArray = tdgssConfigApi.GetInforForOID(this.getMech().toString());
            Integer[] integerArray = new Integer[5];
            for (int i = 0; i < 5; ++i) {
                integerArray[0] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", stringArray[0]);
                integerArray[1] = tdgssConfigApi.GetPropertyForLegal("KeyLength", stringArray[1]);
                integerArray[2] = tdgssConfigApi.GetPropertyForLegal("Mode", stringArray[2]);
                integerArray[3] = tdgssConfigApi.GetPropertyForLegal("Padding", stringArray[3]);
                integerArray[4] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", stringArray[4]);
            }
            GssUtil.prtdbg("QOP : " + stringArray[0] + stringArray[1] + stringArray[2] + stringArray[3] + stringArray[4]);
            String string = "0.0." + integerArray[0] + "." + integerArray[1] + "." + integerArray[2] + "." + integerArray[3] + "." + integerArray[4] + ".0";
            Oid oid = new Oid(string);
            byte[] byArray3 = oid.getDER();
            byArray = new byte[byArray2.length + 1 + byArray3.length - 1 + 1 + 4 + 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[byArray2.length] = 70;
            System.arraycopy(byArray3, 1, byArray, byArray2.length + 1, byArray3.length - 1);
            byArray[byArray2.length + 1 + byArray3.length - 1] = 1;
            byte[] byArray4 = GssUtil.inttobytearray(byArray.length);
            System.arraycopy(byArray4, 0, byArray, byArray2.length + byArray3.length + 1, 4);
            byArray[byArray2.length + byArray3.length + 1 + 4] = 1;
        }
        catch (GSSException gSSException) {
            System.out.println(gSSException);
        }
        return byArray;
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        byte[] byArray2;
        String string = "GssContext-initSecContext:\t";
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        GssUtil.prtdbg(string + "Establishing Context ... ");
        byArray4 = this.GetTrailerBytes();
        if (byArray4 == null) {
            throw new GSSException(11, 0, "Trailer Generation Failure");
        }
        if (this.krb5_on_mpras == 1 && (this.ctx_state & 2) == 2) {
            this.ctx_state = (byte)3;
            return null;
        }
        if (this.msgsequence == 0) {
            this.ctx_state = 0;
            this.cli_or_server = 0;
            if (this.ctx.getCredDelegState()) {
                this.delegRequest = 1;
            }
            this.ctx.requestMutualAuth(true);
            byArray3 = this.ctx.initSecContext(byArray, n, n2);
        } else {
            int n3 = this.ValidateMsgInfo(byArray, n, n2, (byte)2, this.msgsequence == 1 ? (byte)1 : 2);
            if (this.msgsequence == 1) {
                byArray2 = new byte[4];
                System.arraycopy(byArray, n + 8 + 1, byArray2, 0, 4);
                object = new BigInteger(byArray2);
                this.peercapabilities = ((BigInteger)object).intValue();
                if (this.extlogdata != null && (this.peercapabilities & 2) != 2) {
                    throw new GSSException(11, 0, "Server doesn't have logdata capabilties");
                }
            }
            byArray3 = this.ctx.initSecContext(byArray, n + 16, n3);
            GssUtil.hexDump(System.out, byArray3);
        }
        if (byArray3 == null) {
            ++this.msgsequence;
            if ((this.peercapabilities & 2) == 2) {
                MessageProp messageProp = new MessageProp(0, true);
                try {
                    byArray2 = this.extlogdata != null ? this.extlogdata.getBytes("UTF8") : "".getBytes("UTF8");
                    byArray3 = this.wrap(byArray2, 0, byArray2.length, messageProp);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    return null;
                }
                int n4 = byArray3.length;
                object = new byte[16 + n4];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = false;
                }
                byte[] byArray5 = this.GetMsgInfo((byte)2, (byte)5, n4);
                System.arraycopy(byArray5, 0, object, 0, byArray5.length);
                System.arraycopy(byArray3, 0, object, 16, byArray3.length);
                this.ctx_state = (byte)3;
                return object;
            }
            if (this.krb5_on_mpras == 1) {
                this.td2key = this.GenerateKey();
                MessageProp messageProp = new MessageProp(0, true);
                byArray3 = this.ctx.wrap(this.td2key, 0, this.td2key.length, messageProp);
                byArray2 = new byte[16 + byArray3.length];
                GssUtil.prtdbg(string + "krb5 on mpras before GetMsgInfo ... ");
                object = this.GetMsgInfo((byte)1, (byte)3, byArray3.length);
                System.arraycopy(object, 0, byArray2, 0, ((Object)object).length);
                System.arraycopy(byArray3, 0, byArray2, 16, byArray3.length);
                this.ctx_state = (byte)2;
                return byArray2;
            }
            this.ctx_state = (byte)3;
            return byArray3;
        }
        byte[] byArray6 = new byte[16 + byArray3.length];
        byArray2 = this.GetMsgInfo((byte)1, this.msgsequence == 0 ? (byte)1 : 2, byArray3.length);
        System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray6, 16, byArray3.length);
        if (this.msgsequence == 0 && this.gss_or_sspi == 0) {
            object = new byte[16 + byArray3.length + byArray4.length];
            System.arraycopy(byArray6, 0, object, 0, byArray6.length);
            System.arraycopy(byArray4, 0, object, byArray6.length, byArray4.length);
            ++this.msgsequence;
            GssUtil.hexDump(System.out, (byte[])object);
            return object;
        }
        ++this.msgsequence;
        return byArray6;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        return this.ctx.initSecContext(inputStream, outputStream);
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        if (this.msgsequence == 0) {
            this.cli_or_server = 1;
        }
        int n3 = this.ValidateMsgInfo(byArray, n, n2, (byte)1, this.msgsequence == 0 ? (byte)1 : 2);
        byte[] byArray2 = this.ctx.acceptSecContext(byArray, n + 16, n3);
        byte[] byArray3 = new byte[16 + byArray2.length];
        byte[] byArray4 = this.GetMsgInfo((byte)2, this.msgsequence == 0 ? (byte)1 : 2, byArray2.length);
        System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
        System.arraycopy(byArray2, 0, byArray3, 16, byArray2.length);
        ++this.msgsequence;
        return byArray3;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        this.ctx.acceptSecContext(inputStream, outputStream);
    }

    public boolean isEstablished() {
        if (this.krb5_on_mpras == 1 && (this.ctx_state & 3) != 3) {
            return false;
        }
        return this.ctx.isEstablished();
    }

    public void dispose() throws GSSException {
        this.ctx.dispose();
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        return this.ctx.getWrapSizeLimit(n, bl, n2 - 8 - 16);
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.krb5_on_mpras == 1) {
            byte[] byArray2 = this.td2wrap(byArray, n, n2, messageProp);
            return byArray2;
        }
        byte[] byArray3 = this.ctx.wrap(byArray, n, n2, messageProp);
        int n3 = this.krb5_gss == 1 ? byArray3.length : byArray3.length + 8;
        byte[] byArray4 = new byte[16 + n3];
        for (int i = 0; i < byArray4.length; ++i) {
            byArray4[i] = 0;
        }
        byte[] byArray5 = this.GetMsgInfo((byte)3, (byte)2, n3);
        System.arraycopy(byArray5, 0, byArray4, 0, byArray5.length);
        System.arraycopy(byArray3, 0, byArray4, 16, byArray3.length);
        return byArray4;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        this.ctx.wrap(inputStream, outputStream, messageProp);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        GssUtil.prtdbg("UNWRAP ");
        if (this.krb5_on_mpras == 1) {
            byte[] byArray2 = this.td2unwrap(byArray, n, n2, messageProp);
            return byArray2;
        }
        int n3 = this.ValidateMsgInfo(byArray, n, n2, (byte)3, (byte)2);
        if (this.krb5_gss == 1) {
            return this.ctx.unwrap(byArray, n + 16, n3, messageProp);
        }
        return this.ctx.unwrap(byArray, n + 16, n3 - 8, messageProp);
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        this.ctx.unwrap(inputStream, outputStream, messageProp);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2 = this.ctx.getMIC(byArray, n, n2, messageProp);
        byte[] byArray3 = this.GetMsgInfo((byte)4, (byte)2, byArray2.length);
        byte[] byArray4 = new byte[16 + byArray2.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, 16, byArray2.length);
        return byArray4;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        this.ctx.getMIC(inputStream, outputStream, messageProp);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        int n5 = this.ValidateMsgInfo(byArray, n, n2, (byte)4, (byte)2);
        if (n2 != n5 + 16) {
            throw new GSSException(6);
        }
        this.ctx.verifyMIC(byArray, n + 16, n5, byArray2, n3, n4, messageProp);
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        this.ctx.verifyMIC(inputStream, inputStream2, messageProp);
    }

    public byte[] export() throws GSSException {
        return this.ctx.export();
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.ctx.requestMutualAuth(bl);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.ctx.requestReplayDet(bl);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.ctx.requestSequenceDet(bl);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.ctx.requestCredDeleg(bl);
        this.ctx.requestMutualAuth(bl);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.ctx.requestAnonymity(bl);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.ctx.requestConf(bl);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.ctx.requestInteg(bl);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.ctx.requestLifetime(n);
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.ctx.setChannelBinding(channelBinding);
    }

    public boolean getCredDelegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.ctx.getCredDelegState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getMutualAuthState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.ctx.getMutualAuthState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getReplayDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.ctx.getReplayDetState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getSequenceDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.ctx.getSequenceDetState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getAnonymityState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getConfState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.ctx.getConfState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getIntegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.ctx.getIntegState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getLifetime() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.ctx.getLifetime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public boolean isTransferable() throws GSSException {
        if (this.contextInit == 0) {
            throw new GSSException(11, 0, "No Context");
        }
        return false;
    }

    public boolean isProtReady() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.isEstablished();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public GSSName getSrcName() throws GSSException {
        return this.ctx.getSrcName();
    }

    public GSSName getTargName() throws GSSException {
        return this.ctx.getTargName();
    }

    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.ctx.getDelegCred();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isInitiator() throws GSSException {
        return this.ctx.isInitiator();
    }

    public byte[] GenerateKey() throws GSSException {
        byte[] byArray = new byte[16];
        try {
            try {
                SecureRandom secureRandom = new SecureRandom();
                int n = 8;
                byte[] byArray2 = secureRandom.generateSeed(n);
                secureRandom.setSeed(byArray2);
                secureRandom.nextBytes(byArray);
            }
            catch (Exception exception) {
                GssUtil.prtdbg("Using Random");
                Random random = new Random();
                random.nextBytes(byArray);
            }
        }
        catch (Exception exception) {
            throw new GSSException(11, 0, "Key Generation Failure");
        }
        return byArray;
    }

    public byte[] td2wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        Object object;
        byte[] byArray2;
        int n3;
        Object object2;
        String string = "GssContext-td2wrap:\t";
        GssUtil.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            GssUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            GssUtil.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        String string2 = "AES";
        String string3 = "128";
        int n4 = Integer.parseInt(string3) / 8;
        String string4 = "OFB";
        String string5 = "PKCS5Padding";
        String string6 = "SHA1";
        GssUtil.prtdbg(string + "EncAlg =" + string2 + "MicAlg = " + string6 + "kLen = " + string3 + "Mode = " + string4 + "Padding = " + string5);
        SecretKey secretKey = this.BytetoKey(string2, this.td2key, 0, n4);
        this.WrapDigest.update(byArray, n, n2);
        byte[] byArray3 = this.WrapDigest.digest();
        byte[] byArray4 = new byte[n2 + byArray3.length];
        GssUtil.prtdbg(string + "OrigLen " + n2 + " MicBuf.length " + byArray3.length);
        System.arraycopy(byArray, n, byArray4, 0, n2);
        System.arraycopy(byArray3, 0, byArray4, n2, byArray3.length);
        if (this.getConfState() && messageProp.getPrivacy()) {
            object2 = string2 + "/" + string4 + "/" + string5;
            n3 = byArray4.length;
            if (string2.equalsIgnoreCase("AES")) {
                try {
                    TDGSSa tDGSSa = new TDGSSa();
                    tDGSSa.a(secretKey);
                    byArray2 = tDGSSa.a(byArray4, 0, n3);
                }
                catch (InvalidKeyException invalidKeyException) {
                    invalidKeyException.printStackTrace();
                    throw new GSSException(11, 0, "Encryption Failure");
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    illegalBlockSizeException.printStackTrace();
                    throw new GSSException(11, 0, "Encryption Failure");
                }
            } else {
                try {
                    object = Cipher.getInstance((String)object2);
                    if (string5.equalsIgnoreCase("NoPadding")) {
                        int n5 = ((Cipher)object).getBlockSize();
                        n3 = byArray4.length / n5 * n5;
                    }
                    if (string4.equalsIgnoreCase("ECB")) {
                        ((Cipher)object).init(1, secretKey);
                    } else {
                        byte[] byArray5 = new byte[((Cipher)object).getBlockSize()];
                        for (int i = 0; i < byArray5.length; ++i) {
                            byArray5[i] = 0;
                        }
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray5);
                        ((Cipher)object).init(1, (Key)secretKey, ivParameterSpec);
                    }
                    byArray2 = ((Cipher)object).doFinal(byArray4, 0, n3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new GSSException(11, 0, "Encryption Failure");
                }
            }
        } else {
            byArray2 = byArray4;
        }
        object2 = new byte[16 + byArray2.length];
        n3 = 0;
        if (this.getConfState()) {
            n3 = (byte)(n3 | 4);
        }
        TDGSSb tDGSSb = new TDGSSb(1, 3, 2, this.cli_or_server, 255, (byte)n3, 0, byArray2.length, null);
        object = tDGSSb.a();
        System.arraycopy(byArray2, 0, object2, 0, byArray2.length);
        GssUtil.prtdbg(string + "EncBuf " + byArray2.length);
        System.arraycopy(object, 0, object2, byArray2.length, ((Object)object).length);
        GssUtil.prtdbg(string + "Leaving!");
        return object2;
    }

    public byte[] td2unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        Object object;
        byte[] byArray2;
        byte[] byArray3 = new byte[4];
        String string = "GssContext-td2unwrap:\t";
        if (n < 0 || n2 < 0) {
            GssUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            GssUtil.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        TDGSSb tDGSSb = this.ValidateHeaderInfo(byArray, n, n2, (byte)3, (byte)2);
        boolean bl = (tDGSSb.h() & 4) == 4;
        int n3 = tDGSSb.f();
        String string2 = "AES";
        String string3 = "128";
        int n4 = Integer.parseInt(string3) / 8;
        String string4 = "OFB";
        String string5 = "PKCS5Padding";
        String string6 = "SHA1";
        SecretKey secretKey = this.BytetoKey(string2, this.td2key, 0, n4);
        if (bl) {
            String string7 = string2 + "/" + string4 + "/" + string5;
            if (string2.equalsIgnoreCase("AES")) {
                try {
                    TDGSSa tDGSSa = new TDGSSa();
                    tDGSSa.a(secretKey);
                    byArray2 = tDGSSa.b(byArray, n, n3);
                }
                catch (InvalidKeyException invalidKeyException) {
                    invalidKeyException.printStackTrace();
                    throw new GSSException(11, 0, "Encryption Failure");
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    illegalBlockSizeException.printStackTrace();
                    throw new GSSException(11, 0, "Encryption Failure");
                }
                catch (BadPaddingException badPaddingException) {
                    badPaddingException.printStackTrace();
                    throw new GSSException(11, 0, "Encryption Failure");
                }
            } else {
                try {
                    object = Cipher.getInstance(string7);
                    if (string4.equalsIgnoreCase("ECB")) {
                        ((Cipher)object).init(2, secretKey);
                    } else {
                        byte[] byArray4 = new byte[((Cipher)object).getBlockSize()];
                        for (int i = 0; i < byArray4.length; ++i) {
                            byArray4[i] = 0;
                        }
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
                        ((Cipher)object).init(2, (Key)secretKey, ivParameterSpec);
                    }
                    byArray2 = ((Cipher)object).doFinal(byArray, n, n3);
                }
                catch (Exception exception) {
                    throw new GSSException(11, 0, "Encryption Failure");
                }
            }
        } else {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, n3);
        }
        int n5 = byArray2.length - this.DigestLength;
        this.UnwrapDigest.update(byArray2, 0, n5);
        object = this.UnwrapDigest.digest();
        for (int i = 0; i < ((byte[])object).length; ++i) {
            if (object[i] == byArray2[n5 + i]) continue;
            throw new GSSException(6);
        }
        byte[] byArray5 = new byte[n5];
        System.arraycopy(byArray2, 0, byArray5, 0, n5);
        GssUtil.prtdbg(string + "Leaving!");
        return byArray5;
    }

    private TDGSSb ValidateHeaderInfo(byte[] byArray, int n, int n2, byte by, byte by2) throws GSSException {
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n + n2 - 16, byArray2, 0, 16);
        TDGSSb tDGSSb = new TDGSSb(byArray2, 0);
        if (tDGSSb.b() != 1 || tDGSSb.c() != by || tDGSSb.d() != by2) {
            throw new GSSException(10);
        }
        if (n2 != tDGSSb.f() + 16) {
            throw new GSSException(10);
        }
        return tDGSSb;
    }

    public SecretKey BytetoKey(String string, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        TdSecretKey tdSecretKey = new TdSecretKey(string, byArray2);
        return tdSecretKey;
    }
}

