/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jalgapi.AlgParcel;
import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jalgapi.AlgQopDer;
import com.teradata.tdgss.jgssp2ldap.LdapCredential;
import com.teradata.tdgss.jgssp2ldap.LdapDH;
import com.teradata.tdgss.jgssp2ldap.LdapException;
import com.teradata.tdgss.jgssp2ldap.LdapMechanism;
import com.teradata.tdgss.jgssp2ldap.LdapName;
import com.teradata.tdgss.jgssp2ldap.LdapUtil;
import com.teradata.tdgss.jgssp2ldap.LdapVersion;
import com.teradata.tdgss.jgssp2td2.TDGSSb;
import com.teradata.tdgss.jgssp2td2.Td2Crypto;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class LdapContext
implements GSSContext {
    private static final short maxshort = Short.MAX_VALUE;
    private byte contextInit = 0;
    private int msgsequence = 0;
    private byte server_client = 1;
    private TdgssVersion mylibraryversion;
    private LdapVersion mymethodversion;
    private byte myendien = 1;
    private boolean protReady = false;
    private byte mytargetendien = (byte)-1;
    private int mycbmaxtoken = -1;
    private byte[] masterKey = null;
    private String[] endien_txt;
    private boolean initiator;
    private LdapCredential credential;
    private LdapName targetName;
    private int lifetime;
    private short requestedServices;
    private LdapDH DH;
    private static String[] QOPComp;
    private int publicKeyLength;
    private byte[] publicKeybuf;
    private AlgQop legacyQop;
    private AlgQop[] globalQops;
    private static final String prog = "LdapContext";
    private static final int MAXMSGSEQUENCESERVER = 1;
    private static final int MAXMSGSEQUENCECLIENT = 4;
    private static final int HEADERLEN = 16;
    protected static final int LIB_MAJOR_REL_VER_INDEX = 16;
    private static final int LIB_MINOR_REL_VER_INDEX = 17;
    private static final int LIB_MAINT_REL_VER_INDEX = 18;
    private static final int LIB_EMG_REL_VER_INDEX = 19;
    protected static final int PKEY_LENGTH = 20;
    private static final int GKEY_LENGTH = 24;
    private static final int PUBLICKEY_LENGTH = 28;
    private static final int PARCEL_LENGTH = 36;
    private static final int KEY_DATA = 80;
    private static final byte TDGSS_BIGENDIEN = 1;
    private static final byte TDGSS_SMALLENDIEN = 0;
    private static final byte TDGSS_SERVER = 1;
    private static final byte TDGSS_CLIENT = 0;
    protected static final byte FLAG_BYTE = 12;
    private static final int INITMSGLEN = 64;
    static final int keysize = 64;
    static final String[] msgexttxt;
    private byte[] UserPropBytes;
    private BigInteger mySeqNum;
    private BigInteger peerSeqNum;
    private int peerCapabilities;
    private Td2Crypto[] td2Crypto;

    public LdapContext(LdapCredential ldapCredential, Object[] objectArray) throws GSSException {
        String[] stringArray = new String[2];
        stringArray[0] = "small endien";
        stringArray[1] = "big endien";
        this.endien_txt = stringArray;
        this.UserPropBytes = null;
        this.mySeqNum = new BigInteger("1");
        this.peerSeqNum = new BigInteger("0");
        this.peerCapabilities = 0;
        this.td2Crypto = new Td2Crypto[4];
        this.initiator = false;
        this.credential = ldapCredential;
        this.InitialiseData();
        this.requestedServices = (short)99;
    }

    public LdapContext(LdapCredential ldapCredential, LdapName ldapName, int n, Object[] objectArray, short s) throws GSSException {
        String[] stringArray = new String[2];
        stringArray[0] = "small endien";
        stringArray[1] = "big endien";
        this.endien_txt = stringArray;
        this.UserPropBytes = null;
        this.mySeqNum = new BigInteger("1");
        this.peerSeqNum = new BigInteger("0");
        this.peerCapabilities = 0;
        this.td2Crypto = new Td2Crypto[4];
        this.initiator = true;
        this.credential = ldapCredential;
        this.targetName = ldapName;
        this.lifetime = n;
        this.requestedServices = s;
        this.InitialiseData();
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static LdapVersion InquireMethodVersion() {
        LdapVersion ldapVersion = new LdapVersion();
        return ldapVersion;
    }

    private void InitialiseData() throws GSSException {
        this.msgsequence = 0;
        this.mylibraryversion = LdapContext.InquireLibraryVersion();
        this.mymethodversion = LdapContext.InquireMethodVersion();
        this.myendien = 1;
        this.mycbmaxtoken = 80;
        this.DH = new LdapDH();
        if (QOPComp == null) {
            QOPComp = this.ParseQOP(1);
        }
    }

    private TDGSSb ValidateMsgInfo(byte[] byArray, int n, int n2) throws GSSException {
        boolean bl;
        if (n2 <= 16) {
            throw new GSSException(10);
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n + n2 - 16, byArray2, 0, 16);
        TDGSSb tDGSSb = new TDGSSb(byArray2, 0);
        byte by = tDGSSb.b();
        byte by2 = tDGSSb.c();
        byte by3 = tDGSSb.d();
        if (by == 1 && (by2 != 3 && by2 != 4 || by3 != 2)) {
            throw new GSSException(10);
        }
        if (by == 3 && by2 != 7 && by2 != 8) {
            throw new GSSException(10);
        }
        boolean bl2 = bl = (tDGSSb.h() & 4) == 4;
        if (by == 3 && by2 == 7 && !bl ? n2 != tDGSSb.f() : n2 != tDGSSb.f() + 16) {
            throw new GSSException(10);
        }
        return tDGSSb;
    }

    public String[] ParseQOP(int n) throws GSSException {
        String[] stringArray = new String[5];
        switch (n) {
            case 0: {
                stringArray[0] = "AES";
                stringArray[1] = "K128";
                stringArray[2] = "CFB";
                stringArray[3] = "PKCS5Padding";
                stringArray[4] = "MD5";
                break;
            }
            case 1: {
                stringArray[0] = "AES";
                stringArray[1] = "K128";
                stringArray[2] = "OFB";
                stringArray[3] = "PKCS5Padding";
                stringArray[4] = "SHA1";
                break;
            }
            default: {
                throw new GSSException(16);
            }
        }
        return stringArray;
    }

    private byte[] BuildInitMsg(byte by) throws GSSException {
        String string = "LdapContext-BuildInitMsg:\t";
        byte[] byArray = null;
        byte[] byArray2 = new byte[]{6, 12, 43, 6, 1, 4, 1, -127, 63, 1, -121, 116, 1, 20, 70, 8, 0, 1, -127, 0, 3, 0, 0, 0, 1, 0, 0, 0, 30, 1};
        LdapUtil.prtdbg(string + "We will initiate the handshake now...");
        byte[] byArray3 = AlgParcel.getCipherSuitesParcel();
        int n = byArray3.length;
        byArray = new byte[this.mycbmaxtoken + n + byArray2.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        byte by2 = 0;
        if ((this.requestedServices & 1) == 1) {
            by2 = (byte)(by2 | 0x10);
        }
        TDGSSb tDGSSb = new TDGSSb(1, by, 1, this.isserver() ? (byte)1 : 0, 5, by2, 0, 64 + n, null);
        byte[] byArray4 = tDGSSb.a();
        System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
        byArray[16] = this.mylibraryversion.MajorRelease;
        byArray[17] = this.mylibraryversion.MinorRelease;
        byArray[18] = this.mylibraryversion.MaintenanceRelease;
        byArray[19] = this.mylibraryversion.EmergencyRelease;
        byte[] byArray5 = LdapUtil.inttobytearray(n);
        System.arraycopy(byArray5, 0, byArray, 36, byArray5.length);
        System.arraycopy(byArray3, 0, byArray, this.mycbmaxtoken, n);
        System.arraycopy(byArray2, 0, byArray, this.mycbmaxtoken + n, byArray2.length);
        LdapUtil.prtdbg(string + "Successfully generated first message as");
        LdapUtil.hexDump(System.out, byArray);
        return byArray;
    }

    private int ProcessInitMsg(byte[] byArray, int n, int n2) throws GSSException {
        String string = "LdapContext-ProcessInitMsg:\t";
        LdapUtil.prtdbg(string + "Receiving and processing first message");
        if (n != 0) {
            LdapUtil.prtdbg(string + "Only offset = 0 is allowed!");
            return -486538752;
        }
        TDGSSb tDGSSb = new TDGSSb(byArray, n);
        this.mytargetendien = 0;
        if ((tDGSSb.h() & 0x10) != 16) {
            this.requestedServices = (short)(this.requestedServices & 0x7FFE);
        }
        LdapUtil.prtdbg(string + "Checking target endien as " + this.mytargetendien);
        if (this.byteflipneeded()) {
            LdapUtil.prtdbg(string + "We have to byte-flip!");
        }
        if (!this.chklibrary(byArray, this.mylibraryversion)) {
            LdapUtil.prtdbg(string + "*** Illegal library version *** ");
            return -486538760;
        }
        if (tDGSSb.c() != 1 && tDGSSb.c() != 2 || tDGSSb.d() != 1) {
            LdapUtil.prtdbg(string + " Message header is not proper");
            return -486538751;
        }
        this.peerCapabilities = (byte)tDGSSb.i();
        LdapUtil.prtdbg(string + "The received message is OK!");
        return 587203060;
    }

    private void ExtractKeys(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = null;
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = new byte[4];
        byte[] byArray9 = null;
        String string = "LdapContext-ExtractKeys:\t";
        System.arraycopy(byArray, 20, byArray3, 0, 4);
        int n3 = LdapUtil.ByteAtoInt(byArray3);
        byArray2 = new byte[n3];
        System.arraycopy(byArray, 80, byArray2, 0, n3);
        System.arraycopy(byArray, 24, byArray5, 0, 4);
        int n4 = LdapUtil.ByteAtoInt(byArray5);
        byArray4 = new byte[n4];
        System.arraycopy(byArray, 80 + n3, byArray4, 0, n4);
        System.arraycopy(byArray, 28, byArray7, 0, 4);
        int n5 = LdapUtil.ByteAtoInt(byArray7);
        byArray6 = new byte[n5];
        System.arraycopy(byArray, 80 + n3 + n4, byArray6, 0, n5);
        if ((this.peerCapabilities & 4) == 4) {
            System.arraycopy(byArray, 36, byArray8, 0, 4);
            int n6 = LdapUtil.ByteAtoInt(byArray8);
            byArray9 = new byte[n6];
            System.arraycopy(byArray, 80 + n3 + n4 + n5, byArray9, 0, n6);
            object3 = new AlgQopDer(byArray9);
            this.globalQops = new AlgQop[4];
            this.globalQops[0] = ((AlgQopDer)object3).getAlgQop(0);
            this.globalQops[1] = ((AlgQopDer)object3).getAlgQop(1);
            this.globalQops[2] = ((AlgQopDer)object3).getAlgQop(2);
            this.globalQops[3] = ((AlgQopDer)object3).getAlgQop(3);
        } else {
            AlgQop algQop;
            object3 = QOPComp[0];
            String string2 = QOPComp[1].substring(1);
            int n7 = Integer.parseInt(string2);
            String string3 = QOPComp[2];
            object2 = QOPComp[3];
            object = QOPComp[4];
            String string4 = "DH";
            int n8 = 640;
            this.legacyQop = algQop = new AlgQop((String)object3, n7, string3, (String)object2, (String)object, string4, n8);
        }
        LdapUtil.prtdbg(string + "Generate DH Parameters ...");
        this.DH.GenerateParameters(1, byArray4, byArray2);
        LdapUtil.prtdbg(string + "Generate DH Public Key ...");
        this.publicKeybuf = this.DH.GenerateKey();
        LdapUtil.prtdbg(string + "Compute  DH Private Key ...");
        this.masterKey = this.DH.ComputeKey(byArray6);
        LdapUtil.prtdbg(string + "The Matser Key is ***********************************");
        LdapUtil.hexDump(System.out, this.masterKey);
        this.publicKeyLength = n5;
        if ((this.peerCapabilities & 4) == 4) {
            int n9 = 0;
            for (int i = 0; i < 4; ++i) {
                AlgQop algQop = this.globalQops[i];
                int n10 = algQop.getKeyLength() / 8;
                object2 = new byte[n10];
                System.arraycopy(this.masterKey, n9, object2, 0, n10);
                object = this.DH.BytetoKey(algQop.getConfidentialityAlgorithm(), (byte[])object2, 0, n10);
                this.td2Crypto[i] = new Td2Crypto((SecretKey)object, (byte[])object2, algQop, this.peerCapabilities);
                this.td2Crypto[i].computeKeyHash();
                n9 += n10;
            }
        } else {
            object3 = this.DH.BytetoKey(this.legacyQop.getConfidentialityAlgorithm(), this.masterKey, 0, this.legacyQop.getKeyLength() / 8);
            this.td2Crypto[0] = new Td2Crypto((SecretKey)object3, this.masterKey, this.legacyQop, this.peerCapabilities);
            this.td2Crypto[0].computeKeyHash();
        }
        this.protReady = true;
    }

    private byte[] BuildServerMsg() throws GSSException {
        byte[] byArray = null;
        String string = "LdapContext-BuildServerMsg:\t";
        byte by = 1;
        if ((this.peerCapabilities & 1) == 1) {
            by = 3;
        }
        byte by2 = 0;
        if ((this.requestedServices & 1) == 1) {
            by2 = (byte)(by2 | 0x10);
        }
        TDGSSb tDGSSb = new TDGSSb(by, 1, 2, this.isserver() ? (byte)1 : 0, 255, by2, 0, this.publicKeyLength, null);
        byte[] byArray2 = tDGSSb.a();
        byArray = new byte[16 + this.publicKeyLength];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        System.arraycopy(this.publicKeybuf, 0, byArray, byArray2.length, this.publicKeybuf.length);
        this.publicKeybuf = null;
        LdapUtil.prtdbg(string + "The received message is OK!");
        return byArray;
    }

    public void setkey(byte[] byArray) {
        this.masterKey = (byte[])byArray.clone();
    }

    public boolean byteflipneeded() {
        boolean bl = false;
        String string = "LdapContext-byteflipneeded:\t";
        if (this.mytargetendien != this.myendien) {
            LdapUtil.prtdbg(string + "target endien is [" + this.endien_txt[this.mytargetendien] + "] different against our endien [" + this.endien_txt[this.myendien] + "]");
            try {
                if (this.isserver()) {
                    LdapUtil.prtdbg(string + "We are server! No need to byte-flip!");
                } else {
                    LdapUtil.prtdbg(string + "We are client, we have to byte-flip!");
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public byte[] msgcvt(byte[] byArray) {
        String string = "LdapContext-msgcvt:\t";
        if (!this.byteflipneeded()) {
            LdapUtil.prtdbg(string + "No flipping needed!");
            return byArray;
        }
        int n = 0;
        while (n + 3 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 3];
            byArray[n + 3] = by;
            by = byArray[n + 1];
            byArray[n + 1] = byArray[n + 2];
            byArray[n + 2] = by;
            n += 4;
        }
        return byArray;
    }

    private boolean chklibrary(byte[] byArray, TdgssVersion tdgssVersion) {
        return byArray[16] >= 6;
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        String string = "LdapContext-initSecContext:\t";
        LdapUtil.prtdbg(string + "msgsequence is now " + this.msgsequence);
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 0;
                LdapUtil.prtdbg(string + "Confirming that we are now " + msgexttxt[this.server_client]);
                byArray2 = this.BuildInitMsg((byte)1);
                break;
            }
            case 1: {
                LdapUtil.prtdbg(string + "Just receive info-data from server as:");
                LdapUtil.hexDump(System.out, byArray);
                int n3 = this.ProcessInitMsg(byArray, n, n2);
                if (n3 != 587203060) {
                    throw new GSSException(11, n3, LdapException.ErrStr(n3));
                }
                this.ExtractKeys(byArray, n, n2);
                byArray2 = this.BuildServerMsg();
                break;
            }
            case 2: {
                GSSName gSSName = null;
                byte[] byArray3 = null;
                String string2 = "";
                gSSName = this.getSrcName();
                if (gSSName != null) {
                    string2 = ((Object)gSSName).toString();
                }
                try {
                    byArray3 = string2.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    int n4 = -486538731;
                    throw new GSSException(11, n4, unsupportedEncodingException.getMessage());
                }
                TDGSSb tDGSSb = null;
                byte by = 0;
                if ((this.requestedServices & 1) == 1) {
                    by = (byte)(by | 0x10);
                }
                tDGSSb = (this.peerCapabilities & 1) == 1 ? new TDGSSb(3, 5, 2, this.isserver() ? (byte)1 : 0, 1, by, 0, byArray3.length, null) : new TDGSSb(1, 5, 2, this.isserver() ? (byte)1 : 0, 0, by, 0, byArray3.length, null);
                byte[] byArray4 = new byte[16 + byArray3.length];
                byte[] byArray5 = tDGSSb.a();
                System.arraycopy(byArray5, 0, byArray4, 0, byArray5.length);
                System.arraycopy(byArray3, 0, byArray4, 16, byArray3.length);
                MessageProp messageProp = new MessageProp(0, true);
                byArray2 = this.wrap(byArray4, 0, byArray4.length, messageProp);
                break;
            }
            case 3: {
                LdapUtil.prtdbg(string + "Receive info-data from server as:");
                LdapUtil.hexDump(System.out, byArray);
                byte[] byArray6 = new byte[4];
                System.arraycopy(byArray, 4, byArray6, 0, 4);
                BigInteger bigInteger = new BigInteger(byArray6);
                int n5 = bigInteger.intValue();
                this.UserPropBytes = new byte[n5];
                System.arraycopy(byArray, 16, this.UserPropBytes, 0, n5);
                break;
            }
            default: {
                int n6 = -486538758;
                throw new GSSException(11, n6, LdapException.ErrStr(n6));
            }
        }
        ++this.msgsequence;
        LdapUtil.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        String string = "LdapContext-acceptSecContext:\t";
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 1;
                LdapUtil.prtdbg(string + "Just receive info-data from client as:");
                LdapUtil.hexDump(System.out, byArray);
                byArray2 = this.BuildInitMsg((byte)2);
                int n3 = this.ProcessInitMsg(byArray, n, n2);
                if (n3 == 587203060) break;
                throw new GSSException(11, n3, LdapException.ErrStr(n3));
            }
            default: {
                int n4 = -486538758;
                throw new GSSException(11, n4, LdapException.ErrStr(n4));
            }
        }
        ++this.msgsequence;
        LdapUtil.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public boolean isEstablished() {
        boolean bl = false;
        int n = 0;
        String string = "LdapContext-isEstablished:\t";
        try {
            n = this.isserver() ? 1 : 4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.msgsequence >= n) {
            bl = true;
        }
        LdapUtil.prtdbg(string + "Leaving with retcode = " + bl);
        return bl;
    }

    public boolean isserver() throws GSSException {
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new GSSException(11);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (!this.isProtReady()) {
            int n3 = -486538715;
            throw new GSSException(11, n3, LdapException.ErrStr(n3));
        }
        n = this.validateQop(n);
        int n4 = this.td2Crypto[n].getWrapSizeLimit(n, bl, n2);
        return n4;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        String string = "LdapContext-wrap:\t";
        LdapUtil.prtdbg(string + "Entering!");
        int n3 = 0;
        boolean bl = false;
        byte by = 0;
        TDGSSb tDGSSb = null;
        if (!this.isProtReady()) {
            int n4 = -486538715;
            throw new GSSException(11, n4, LdapException.ErrStr(n4));
        }
        if (n < 0 || n2 < 0) {
            LdapUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            LdapUtil.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        if (messageProp != null) {
            n3 = messageProp.getQOP();
        }
        n3 = this.validateQop(n3);
        if (this.getConfState() && messageProp != null && messageProp.getPrivacy()) {
            by = (byte)(by | 4);
            bl = true;
        }
        if (this.peerCapabilities == 0) {
            tDGSSb = new TDGSSb(1, 3, 2, this.isserver() ? (byte)1 : 0, 255, by, n3, 0, null);
        } else if ((this.peerCapabilities & 1) == 1) {
            tDGSSb = new TDGSSb(3, 7, 2, this.isserver() ? (byte)1 : 0, 1, by, n3, 0, this.mySeqNum);
        } else {
            int n5 = -486538751;
            throw new GSSException(11, n5, "Unknown peer capabilities");
        }
        byte[] byArray2 = this.td2Crypto[n3].wrap(byArray, n, n2, messageProp, tDGSSb);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        if (bl) {
            messageProp.setPrivacy(true);
        }
        LdapUtil.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        String string = "LdapContext-unwrap:\t";
        LdapUtil.prtdbg(string + "Entering!");
        if (!this.isProtReady()) {
            int n3 = -486538715;
            throw new GSSException(11, n3, LdapException.ErrStr(n3));
        }
        if (n < 0 || n2 < 0) {
            LdapUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray == null) {
            LdapUtil.prtdbg(string + "Input argument is null");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            LdapUtil.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        TDGSSb tDGSSb = this.ValidateMsgInfo(byArray, n, n2);
        boolean bl = (tDGSSb.h() & 4) == 4;
        if ((this.peerCapabilities & 1) == 1) {
            BigInteger bigInteger;
            this.peerSeqNum = bigInteger = tDGSSb.j();
        }
        int n4 = tDGSSb.g();
        n4 = this.validateQop(n4);
        byte[] byArray2 = this.td2Crypto[n4].unwrap(byArray, n, n2, messageProp, tDGSSb);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        if (messageProp != null) {
            messageProp.setPrivacy(bl);
            messageProp.setQOP(n4);
        }
        LdapUtil.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        int n3 = 0;
        TDGSSb tDGSSb = null;
        String string = "LdapContext-getMIC:\t";
        LdapUtil.prtdbg(string + "Entering!");
        if (!this.isProtReady()) {
            int n4 = -486538715;
            throw new GSSException(11, n4, LdapException.ErrStr(n4));
        }
        if (n < 0 || n2 < 0) {
            LdapUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            LdapUtil.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        if (messageProp != null) {
            n3 = messageProp.getQOP();
        }
        n3 = this.validateQop(n3);
        byte by = 0;
        if (this.peerCapabilities == 0) {
            tDGSSb = new TDGSSb(1, 4, 2, this.isserver() ? (byte)1 : 0, 255, by, n3, 0, null);
        } else if ((this.peerCapabilities & 1) == 1) {
            tDGSSb = new TDGSSb(3, 8, 2, this.isserver() ? (byte)1 : 0, 1, by, n3, 0, this.mySeqNum);
        } else {
            int n5 = -486538751;
            throw new GSSException(11, n5, "Unknown peer capabilities");
        }
        byte[] byArray2 = this.td2Crypto[n3].getMIC(byArray, n, n2, messageProp, tDGSSb);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        LdapUtil.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        String string = "LdapContext-verifyMIC:\t";
        LdapUtil.prtdbg(string + "Entering!");
        if (!this.isProtReady()) {
            int n5 = -486538715;
            throw new GSSException(11, n5, LdapException.ErrStr(n5));
        }
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            LdapUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            LdapUtil.prtdbg(string + "Input length " + " is larger than buffer size ");
            throw new GSSException(11);
        }
        TDGSSb tDGSSb = this.ValidateMsgInfo(byArray, n, n2);
        if ((this.peerCapabilities & 1) == 1) {
            BigInteger bigInteger;
            this.peerSeqNum = bigInteger = tDGSSb.j();
        }
        int n6 = tDGSSb.g();
        n6 = this.validateQop(n6);
        this.td2Crypto[n6].verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp, tDGSSb);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        LdapUtil.prtdbg(string + "Leaving!");
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    private int validateQop(int n) throws GSSException {
        block4: {
            block2: {
                block3: {
                    if ((this.peerCapabilities & 4) != 4) break block2;
                    if (n < 0) break block3;
                    if (n < 4) break block4;
                }
                int n2 = -486538713;
                throw new GSSException(14, n2, LdapException.ErrStr(n2));
            }
            n = 0;
        }
        return n;
    }

    public byte[] export() throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.lifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
    }

    public boolean getCredDelegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            if (this.isEstablished()) {
                return (this.requestedServices & 1) != 0;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getMutualAuthState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return (this.requestedServices & 2) != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getReplayDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return (this.requestedServices & 4) != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getSequenceDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return (this.requestedServices & 8) != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getAnonymityState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getConfState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getIntegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getLifetime() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.lifetime;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public boolean isTransferable() throws GSSException {
        if (this.contextInit == 0) {
            throw new GSSException(11, 0, "No Context");
        }
        return false;
    }

    public boolean isProtReady() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.protReady;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return LdapMechanism.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    static {
        String[] stringArray = new String[2];
        stringArray[0] = "client";
        stringArray[1] = "server";
        msgexttxt = stringArray;
    }
}

