/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jgssp2ldap.LdapContext;
import com.teradata.tdgss.jgssp2ldap.LdapCredential;
import com.teradata.tdgss.jgssp2ldap.LdapName;
import com.teradata.tdgss.jgssp2ldap.LdapUtil;
import com.teradata.tdgss.jgssspi.TDGSSa;
import java.io.UnsupportedEncodingException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class LdapMechanism
implements TDGSSa {
    private static Oid _mechOid;
    private static Oid GSS_C_NT_TDAT_MECHDATA;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF16;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF32;
    public static Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    protected static final int TDATMETHODMAXTOKEN = 80;
    private static final int AUTHTERADATA = 8;
    private static final String AUTHTERADATASTR;
    private static final String prog = "LdapMechanism";
    protected static final Oid mechOid;
    protected static final short servicesAvailable = 99;
    protected static short servicesNeeded;

    public LdapMechanism() {
        servicesNeeded = (short)99;
    }

    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        String string = "LdapMechanism-acceptable:\t";
        if (object == null) {
            LdapUtil.prtdbg(string + "Token is null");
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (byArray.length <= 0 || byArray.length > 80) {
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof LdapCredential)) {
            LdapUtil.prtdbg("GSSException.DEFECTIVE_CREDENTIALmust be a credential created by this mech");
            return false;
        }
        return true;
    }

    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        LdapUtil.prtdbg("getContextForAccept ");
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new GSSException(10);
        }
        return new LdapContext((LdapCredential)gSSCredential, objectArray);
    }

    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        LdapUtil.prtdbg("getContextForInit ");
        s = (short)(s & 0x63);
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s)) {
            throw new GSSException(10);
        }
        return new LdapContext((LdapCredential)gSSCredential, (LdapName)gSSName, n, objectArray, s);
    }

    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        String string = "LdapMechanism-initable:\t";
        if (gSSCredential != null && !(gSSCredential instanceof LdapCredential)) {
            LdapUtil.prtdbg(string + "GSSException.DEFECTIVE_CREDENTIAL: " + "must be a credential created by this mech");
            return false;
        }
        if (gSSName != null && !(gSSName instanceof LdapName)) {
            LdapUtil.prtdbg(string + "must be a name created by this mech");
            return false;
        }
        return true;
    }

    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        LdapName ldapName;
        if (gSSName == null) {
            ldapName = null;
        } else if (gSSName instanceof LdapName) {
            ldapName = (LdapName)gSSName;
        } else {
            throw new GSSException(3);
        }
        return new LdapCredential(ldapName, n, n2);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        if (oid != null && oid.equals(GSS_C_NT_TDAT_MECHDATA_UTF16)) {
            byte[] byArray2;
            try {
                String string = new String(byArray, "UTF-16");
                byArray2 = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return null;
            }
            return new LdapName(byArray2, GSS_C_NT_TDAT_MECHDATA_UTF8);
        }
        return new LdapName(byArray, oid);
    }

    public Oid[] getNames() {
        Oid[] oidArray = new Oid[]{GSS_C_NT_TDAT_MECHDATA, GSS_C_NT_TDAT_MECHDATA_UTF8};
        return oidArray;
    }

    public Oid getMech() {
        return mechOid;
    }

    public short getServices() {
        return 99;
    }

    static {
        AUTHTERADATASTR = new String("TERADATA");
        try {
            _mechOid = new Oid("1.3.6.1.4.1.191.1.1012.1.20");
            GSS_C_NT_TDAT_MECHDATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.2");
            GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.1");
            GSS_C_NT_TDAT_MECHDATA_UTF8 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.3");
            GSS_C_NT_TDAT_MECHDATA_UTF16 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.4");
            GSS_C_NT_TDAT_MECHDATA_UTF32 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.5");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError("Oid string is incorrectly formatted");
        }
        mechOid = _mechOid;
        servicesNeeded = 0;
    }
}

