/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jgssp2ldap.LdapDH;
import com.teradata.tdgss.jgssp2ldap.LdapException;
import com.teradata.tdgss.jgssp2ldap.TDGSSa;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.ietf.jgss.GSSException;

public class LdapUtil {
    private static int debug_on = 0;
    private static final String DEBUG_OPTION = "-d";
    private static final String prog = "LdapUtil";
    private static final int BYTESININT = 4;

    public static void prtbuf(int[] nArray, String string) {
        int n = 4;
        int n2 = 0;
        LdapUtil.prtdbg(string + " : ");
        for (int i = 0; i < nArray.length; ++i) {
            if (i % n == 0) {
                LdapUtil.prtdbgnl("\n\t" + i + ") ");
            }
            LdapUtil.prtdbgnl(" " + Integer.toHexString(nArray[i]));
            n2 += nArray[i] + i;
        }
        LdapUtil.prtdbg("\n\tTotal " + nArray.length + " integers " + " chksum = " + Integer.toHexString(n2));
        LdapUtil.prtdbg("");
    }

    public static void prtbuf(byte[] byArray) {
        int n;
        int n2 = 16;
        int n3 = 0;
        for (n = 0; n < byArray.length; ++n) {
            if (n % n2 == 0) {
                LdapUtil.prtdbgnl("\n\t\t" + n + ") ");
            }
            LdapUtil.prtdbgnl(" " + byArray[n]);
            n3 += byArray[n] + n;
        }
        for (n = 0; n < byArray.length; ++n) {
            if (n % n2 == 0) {
                LdapUtil.prtdbgnl("\n\t\t" + n + ") ");
            }
            LdapUtil.prtdbgnl((char)byArray[n]);
        }
        LdapUtil.prtdbg("\n\t\tTotal bytes = " + byArray.length + " chksum = " + n3);
    }

    public static void bufcpy(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byArray2[i];
        }
    }

    public static void prtdbg(String string) {
        if (debug_on == 0) {
            return;
        }
        System.out.println(string);
    }

    public static void prtdbgnl(String string) {
        if (debug_on == 0) {
            return;
        }
        System.out.print(string);
    }

    public static void prtdbgnl(char c) {
        if (debug_on == 0) {
            return;
        }
        System.out.print(c);
    }

    public static void turndebugon(int n) {
    }

    public static boolean chkdebugflag(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(DEBUG_OPTION)) continue;
            debug_on = 1;
            LdapUtil.prtdbg("DEBUG IS TURNED ON VIA COMMAND LINE ARG " + stringArray[i]);
            return true;
        }
        return false;
    }

    public static void hexDump(PrintStream printStream, byte[] byArray) {
        if (debug_on == 0) {
            return;
        }
        if (printStream == null) {
            return;
        }
        if (byArray == null) {
            printStream.println("Null");
            return;
        }
        LdapUtil.hexDumpAt(new PrintWriter(printStream, false), byArray, 0, byArray.length, 0);
    }

    public static void hexDumpAt(PrintWriter printWriter, byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (debug_on == 0) {
            return;
        }
        printWriter.println("");
        if (n >= byArray.length) {
            n = byArray.length;
        }
        if ((n5 = n + n2) >= byArray.length) {
            n5 = byArray.length;
        }
        if ((n2 = n5 - n) <= 0) {
            return;
        }
        int n6 = n4 = n / 16 * 16;
        while (n6 < n5) {
            int n7;
            int n8;
            int n9 = n3 + n4;
            for (n8 = 28; n8 >= 0; n8 -= 4) {
                n7 = n9 >>> n8 & 0xF;
                n7 = n7 < 10 ? n7 + 48 : n7 - 10 + 65;
                printWriter.print((char)n7);
            }
            printWriter.print("  ");
            n8 = 0;
            while (n6 + n8 < n) {
                printWriter.print(".. ");
                ++n8;
            }
            while (n8 < 16 && n6 + n8 < n5) {
                if (n8 == 8) {
                    printWriter.print(' ');
                }
                n7 = (n7 = (n9 = byArray[n6 + n8] & 0xFF) >>> 4) < 10 ? n7 + 48 : n7 - 10 + 65;
                printWriter.print((char)n7);
                n7 = n9 & 0xF;
                n7 = n7 < 10 ? n7 + 48 : n7 - 10 + 65;
                printWriter.print((char)n7);
                printWriter.print(' ');
                ++n8;
            }
            while (n8 < 16) {
                if (n8 == 8) {
                    printWriter.print(' ');
                }
                printWriter.print(".. ");
                ++n8;
            }
            printWriter.print(" |");
            n8 = 0;
            while (n6 + n8 < n) {
                printWriter.print(' ');
                ++n8;
            }
            while (n8 < 16 && n6 + n8 < n5) {
                n9 = byArray[n6 + n8] & 0xFF;
                if (n9 < 32 || n9 >= 127 && n9 < 160 || n9 > 255) {
                    n9 = 46;
                }
                printWriter.print((char)n9);
                ++n8;
            }
            while (n8 < 16) {
                printWriter.print(' ');
                ++n8;
            }
            printWriter.println("|");
            n6 += 16;
            n4 += 16;
        }
        printWriter.println("");
        printWriter.flush();
    }

    public static byte[] inttobytearray(int n) {
        Integer n2 = new Integer(n);
        BigInteger bigInteger = new BigInteger(n2.toString());
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            int n3 = byArray.length;
            for (int i = 4; i > 0; --i) {
                if (--n3 >= 0) {
                    byArray2[i] = byArray[n3];
                    continue;
                }
                byArray2[i] = 0;
            }
            return byArray2;
        }
        return byArray;
    }

    public static int ByteAtoInt(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger.intValue();
    }

    public static byte[] encryptBuffer(byte[] byArray, byte[] byArray2) throws GSSException {
        byte[] byArray3;
        int n = 16;
        if (byArray == null || byArray2 == null) {
            return null;
        }
        LdapDH ldapDH = new LdapDH();
        try {
            SecretKey secretKey = ldapDH.BytetoKey("AES", byArray, 0, n);
            TDGSSa tDGSSa = new TDGSSa();
            tDGSSa.a(secretKey);
            byArray3 = tDGSSa.a(byArray2, 0, byArray2.length);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            int n2 = -486538755;
            throw new GSSException(11, n2, LdapException.ErrStr(n2));
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
            int n3 = -486538755;
            throw new GSSException(11, n3, LdapException.ErrStr(n3));
        }
        return byArray3;
    }

    public static byte[] decryptBuffer(byte[] byArray, byte[] byArray2) throws GSSException {
        int n = 16;
        if (byArray == null || byArray2 == null) {
            return null;
        }
        LdapDH ldapDH = new LdapDH();
        byte[] byArray3 = null;
        try {
            SecretKey secretKey = ldapDH.BytetoKey("AES", byArray, 0, n);
            TDGSSa tDGSSa = new TDGSSa();
            tDGSSa.a(secretKey);
            byArray3 = tDGSSa.b(byArray2, 0, byArray2.length);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            int n2 = -486538755;
            throw new GSSException(11, n2, LdapException.ErrStr(n2));
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
            int n3 = -486538755;
            throw new GSSException(11, n3, LdapException.ErrStr(n3));
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
            int n4 = -486538755;
            throw new GSSException(11, n4, LdapException.ErrStr(n4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    public static byte[] getEDKey() {
        try {
            String[] stringArray = null;
            int n = 16;
            stringArray = LdapUtil.getImpls("SecureRandom");
            SecureRandom secureRandom = SecureRandom.getInstance(stringArray[0]);
            byte[] byArray = new byte[n];
            secureRandom.nextBytes(byArray);
            LdapUtil.hexDump(System.out, byArray);
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String[] getImpls(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            Set<Object> set = providerArray[i].keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith(string + ".")) {
                    hashSet.add(string2.substring(string.length() + 1));
                    continue;
                }
                if (!string2.startsWith("Alg.Alias." + string + ".")) continue;
                hashSet.add(string2.substring(string.length() + 11));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }
}

