/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td1;

import com.teradata.tdgss.jgssp2td1.Td1Exception;
import com.teradata.tdgss.jgssp2td1.Td1Util;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.ietf.jgss.GSSException;

public final class Td1DH {
    private static int TDGSS_SHARED_G;
    private static int TDGSS_SHARED_N;
    private byte[] TDGSS_SHARED_G_NEW = null;
    private byte[] TDGSS_SHARED_N_NEW = null;
    private int keysize;
    private int Version = 1;
    private BigInteger[] PrivateKey;
    private BigInteger SharedKey;
    private static final int BITSPERBYTE = 8;
    private int CURRENTKEYBYTES = 52;
    private final int MAXKEYBYTES = 128;
    private final int BYTESININT = 4;
    private final int MAX_EXPONENTIAL = Short.MAX_VALUE;
    private final int sizeofoneset = 4;
    private final String prog = "Td1DH";
    private int num_diffie_hellman_sets;

    public Td1DH(int n, int n2, int n3) {
        this.keysize = n;
        TDGSS_SHARED_G = n2;
        TDGSS_SHARED_N = n3;
        this.num_diffie_hellman_sets = this.keysize / 4;
        this.PrivateKey = new BigInteger[this.num_diffie_hellman_sets];
    }

    public Td1DH(int n, byte[] byArray, byte[] byArray2, int n2) {
        this.Version = n2;
        this.CURRENTKEYBYTES = this.keysize = n;
        this.TDGSS_SHARED_G_NEW = new byte[n];
        System.arraycopy(byArray, 0, this.TDGSS_SHARED_G_NEW, 0, this.keysize);
        this.TDGSS_SHARED_N_NEW = new byte[n];
        System.arraycopy(byArray2, 0, this.TDGSS_SHARED_N_NEW, 0, this.keysize);
    }

    public byte[] makeseed(int n) {
        String string = "Td1DH-makeseed:\t";
        byte[] byArray = null;
        Random random = new Random();
        String[] stringArray = null;
        Integer n2 = new Integer(TDGSS_SHARED_G);
        Integer n3 = new Integer(TDGSS_SHARED_N);
        Integer n4 = new Integer(Short.MAX_VALUE);
        stringArray = this.getImpls("SecureRandom");
        try {
            BigInteger bigInteger;
            Serializable serializable;
            if (stringArray.length > 0) {
                Td1Util.prtdbg(string + "PRNG = " + stringArray[0]);
                serializable = SecureRandom.getInstance(stringArray[0]);
                int n5 = 4;
                byte[] byArray2 = ((SecureRandom)serializable).generateSeed(n5);
                ((SecureRandom)serializable).setSeed(byArray2);
                Td1Util.prtdbg(string + "seed = " + byArray2);
                bigInteger = new BigInteger(32, (Random)serializable);
            } else {
                bigInteger = new BigInteger(32, random);
            }
            this.PrivateKey[n] = bigInteger = bigInteger.mod(new BigInteger(n4.toString()));
            serializable = new BigInteger(n2.toString());
            serializable = ((BigInteger)serializable).modPow(bigInteger, new BigInteger(n3.toString()));
            Td1Util.prtdbg(string + "X = g^x mod n = (" + TDGSS_SHARED_G + ")^ " + bigInteger + " mod (" + TDGSS_SHARED_N + ") = " + serializable + " = 0x" + ((BigInteger)serializable).toString(16));
            byArray = this.normalize_key((BigInteger)serializable);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return byArray;
    }

    public byte[] genseed() throws GSSException {
        byte[] byArray = null;
        Random random = new Random();
        String[] stringArray = null;
        int n = 0;
        String string = "Td1DH-genseed:\t";
        if (this.keysize >= 128) {
            Td1Util.prtdbg(string + " *** ERROR! Requesting " + this.keysize + "exceeds max key bytes " + 128);
            throw new GSSException(11, -486538959, Td1Exception.ErrStr(-486538959));
        }
        if (this.Version == 1) {
            int n2;
            Td1Util.prtdbg(string + " A total of " + this.num_diffie_hellman_sets + " sets of " + 4 + " bytes key = " + this.keysize + " bytes will be generated\n");
            byArray = new byte[this.keysize];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray[n2] = 0;
            }
            for (n2 = 0; n2 < this.num_diffie_hellman_sets; ++n2) {
                Td1Util.prtdbg(string + "Computing seed number " + n2);
                byte[] byArray2 = this.makeseed(n2);
                System.arraycopy(byArray2, 0, byArray, n, 4);
                n += 4;
            }
        } else {
            BigInteger bigInteger = new BigInteger(1, this.TDGSS_SHARED_N_NEW);
            BigInteger bigInteger2 = new BigInteger(1, this.TDGSS_SHARED_G_NEW);
            stringArray = this.getImpls("SecureRandom");
            try {
                BigInteger bigInteger3;
                if (stringArray.length > 0) {
                    Td1Util.prtdbg(string + "PRNG Found = " + stringArray[0]);
                    SecureRandom secureRandom = SecureRandom.getInstance(stringArray[0]);
                    int n3 = 8;
                    byte[] byArray3 = secureRandom.generateSeed(n3);
                    secureRandom.setSeed(byArray3);
                    Td1Util.prtdbg(string + "seed = " + byArray3);
                    while ((bigInteger3 = new BigInteger(this.CURRENTKEYBYTES * 8, secureRandom)).compareTo(BigInteger.ZERO) != 1 || bigInteger3.compareTo(bigInteger.subtract(BigInteger.ONE)) != -1) {
                    }
                } else {
                    while ((bigInteger3 = new BigInteger(this.CURRENTKEYBYTES * 8, random)).compareTo(BigInteger.ZERO) != 1 || bigInteger3.compareTo(bigInteger.subtract(BigInteger.ONE)) != -1) {
                    }
                }
                BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
                Td1Util.prtdbg(string + " pG =" + bigInteger2 + "pN = " + bigInteger);
                Td1Util.prtdbg(string + " x =" + bigInteger3 + "y = " + bigInteger4);
                this.SharedKey = bigInteger3;
                byArray = this.normalize_key(bigInteger4);
                Td1Util.prtdbg(string + "Generated seed with length =" + byArray.length);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return byArray;
    }

    private byte[] compute_one_key(byte[] byArray, int n) {
        String string = "Td1DH-compute_one_key:\t";
        BigInteger bigInteger = new BigInteger(byArray);
        Integer n2 = new Integer(TDGSS_SHARED_N);
        BigInteger bigInteger2 = bigInteger;
        bigInteger2 = bigInteger2.modPow(this.PrivateKey[n], new BigInteger(n2.toString()));
        Td1Util.prtdbg(string + "K  = (Y^x mod n) = " + bigInteger + "^" + this.PrivateKey[n] + " mod " + TDGSS_SHARED_N + " = " + bigInteger2 + " = 0x" + bigInteger2.toString(16));
        byte[] byArray2 = bigInteger2.toByteArray();
        byte[] byArray3 = this.normalize_key(byArray2);
        return byArray3;
    }

    public byte[] normalize_key(BigInteger bigInteger) {
        if (this.Version == 1) {
            byte[] byArray = bigInteger.toByteArray();
            byte[] byArray2 = this.normalize_key(byArray);
            return byArray2;
        }
        byte[] byArray = bigInteger.toByteArray();
        Td1Util.prtdbg("normalize_key :outbuf = " + byArray.length);
        Td1Util.hexDump(System.out, byArray);
        if (byArray.length != this.keysize) {
            if (byArray.length > this.keysize) {
                byte[] byArray3 = new byte[this.keysize];
                System.arraycopy(byArray, byArray.length - this.keysize, byArray3, 0, this.keysize);
                Td1Util.hexDump(System.out, byArray3);
                return byArray3;
            }
            byte[] byArray4 = new byte[this.keysize];
            int n = this.keysize - byArray.length;
            for (int i = 0; i < n; ++i) {
                byArray4[i] = 0;
            }
            System.arraycopy(byArray, 0, byArray4, n, byArray.length);
            Td1Util.hexDump(System.out, byArray4);
            return byArray4;
        }
        return byArray;
    }

    public byte[] normalize_key(int n) {
        Integer n2 = new Integer(n);
        BigInteger bigInteger = new BigInteger(n2.toString());
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = this.normalize_key(byArray);
        return byArray2;
    }

    public byte[] normalize_key(byte[] byArray) {
        String string = "Td1DH-normalize_key:\t";
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            int n = byArray.length;
            for (int i = 4; i > 0; --i) {
                if (--n >= 0) {
                    byArray2[i] = byArray[n];
                    continue;
                }
                byArray2[i] = 0;
            }
            return byArray2;
        }
        return byArray;
    }

    private byte[] normalize_key_temp(BigInteger bigInteger) {
        int n = 0;
        if (this.Version == 1) {
            byte[] byArray = bigInteger.toByteArray();
            byte[] byArray2 = this.normalize_key(byArray);
            return byArray2;
        }
        byte[] byArray = bigInteger.toByteArray();
        Td1Util.prtdbg("normalize_key_temp: outbuf = " + byArray.length);
        Td1Util.hexDump(System.out, byArray);
        if (byArray.length > this.keysize) {
            byte[] byArray3 = new byte[this.keysize];
            System.arraycopy(byArray, byArray.length - this.keysize, byArray3, 0, this.keysize);
            Td1Util.hexDump(System.out, byArray3);
            return byArray3;
        }
        if (byArray[0] == 0) {
            for (int i = 0; i < byArray.length && byArray[i] == 0; ++i) {
                ++n;
            }
            byte[] byArray4 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray4, 0, byArray.length - n);
            Td1Util.hexDump(System.out, byArray4);
            return byArray4;
        }
        return byArray;
    }

    public byte[] compute_key(byte[] byArray) throws GSSException {
        byte[] byArray2;
        byte[] byArray3 = new byte[4];
        int n = 0;
        String string = "Td1DH-compute_key:\t";
        if (this.keysize >= 128) {
            Td1Util.prtdbg(string + " *** ERROR! Requesting " + this.keysize + "exceeds max key bytes " + 128);
            throw new GSSException(11, -486538958, Td1Exception.ErrStr(-486538958));
        }
        if (this.Version == 1) {
            int n2;
            Td1Util.prtdbg(string + " A total of " + this.num_diffie_hellman_sets + " sets of " + 4 + " bytes key = " + this.keysize + " bytes will be generated\n");
            byArray2 = new byte[this.keysize];
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray2[n2] = 0;
            }
            for (n2 = 0; n2 < this.num_diffie_hellman_sets; ++n2) {
                Td1Util.prtdbg(string + "Computing Key number " + n2);
                System.arraycopy(byArray, n, byArray3, 0, 4);
                byte[] byArray4 = this.compute_one_key(byArray3, n2);
                System.arraycopy(byArray4, 0, byArray2, n, 4);
                n += 4;
            }
            Td1Util.prtdbg(string + "Key is computed as ");
            Td1Util.hexDump(System.out, byArray2);
        } else {
            BigInteger bigInteger;
            BigInteger bigInteger2 = bigInteger = new BigInteger(1, byArray);
            BigInteger bigInteger3 = new BigInteger(1, this.TDGSS_SHARED_N_NEW);
            bigInteger2 = bigInteger2.modPow(this.SharedKey, bigInteger3);
            byArray2 = this.normalize_key_temp(bigInteger2);
            Td1Util.prtdbg(string + "Key is computed as ");
            Td1Util.prtbuf(byArray2);
        }
        return byArray2;
    }

    private String[] getImpls(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            Set<Object> set = providerArray[i].keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith(string + ".")) {
                    hashSet.add(string2.substring(string.length() + 1));
                    continue;
                }
                if (!string2.startsWith("Alg.Alias." + string + ".")) continue;
                hashSet.add(string2.substring(string.length() + 11));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }
}

