/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jalgapi.AlgParcel;
import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jalgapi.AlgQopDer;
import com.teradata.tdgss.jgssp2td2.TDGSSb;
import com.teradata.tdgss.jgssp2td2.Td2Credential;
import com.teradata.tdgss.jgssp2td2.Td2Crypto;
import com.teradata.tdgss.jgssp2td2.Td2DH;
import com.teradata.tdgss.jgssp2td2.Td2Exception;
import com.teradata.tdgss.jgssp2td2.Td2Mechanism;
import com.teradata.tdgss.jgssp2td2.Td2Name;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import com.teradata.tdgss.jgssp2td2.Td2Version;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class Td2Context
implements GSSContext {
    private static final short maxshort = Short.MAX_VALUE;
    private int msgsequence = 0;
    private byte server_client = 1;
    private byte contextInit = 0;
    private TdgssVersion mylibraryversion;
    private Td2Version mymethodversion;
    private byte myendien = 1;
    private boolean protReady = false;
    private byte mytargetendien = (byte)-1;
    private int mycbmaxtoken = -1;
    private byte[] masterKey = null;
    private String[] endien_txt;
    private boolean initiator;
    private Td2Credential credential;
    private Td2Name targetName;
    private int lifetime;
    private short requestedServices;
    private Td2DH DH;
    private byte[] TrailerBytes;
    private static String[] QOPComp;
    private static Integer[] QOPValues;
    private int publicKeyLength;
    private byte[] publicKeybuf;
    private AlgQop legacyQop;
    private AlgQop[] globalQops;
    private static final String prog = "Td2Context";
    private static final int MAXMSGSEQUENCESERVER = 1;
    private int MAXMSGSEQUENCECLIENT;
    private static final int HEADERLEN = 16;
    protected static final int LIB_MAJOR_REL_VER_INDEX = 16;
    private static final int LIB_MINOR_REL_VER_INDEX = 17;
    private static final int LIB_MAINT_REL_VER_INDEX = 18;
    private static final int LIB_EMG_REL_VER_INDEX = 19;
    protected static final int PKEY_LENGTH = 20;
    private static final int GKEY_LENGTH = 24;
    private static final int PUBLICKEY_LENGTH = 28;
    private static final int VERIFYDHKEY = 32;
    private static final int PARCEL_LENGTH = 36;
    private static final int KEY_DATA = 80;
    private static final byte TDGSS_BIGENDIEN = 1;
    private static final byte TDGSS_SMALLENDIEN = 0;
    private static final int INITMSGLEN = 64;
    private int verifyDHKey;
    static final String[] msgexttxt;
    private BigInteger mySeqNum;
    private BigInteger peerSeqNum;
    private int peerCapabilities;
    private Td2Crypto[] td2Crypto;

    public Td2Context(Td2Credential td2Credential, Object[] objectArray) throws GSSException {
        String[] stringArray = new String[2];
        stringArray[0] = "small endien";
        stringArray[1] = "big endien";
        this.endien_txt = stringArray;
        this.MAXMSGSEQUENCECLIENT = 2;
        this.mySeqNum = new BigInteger("1");
        this.peerSeqNum = new BigInteger("0");
        this.peerCapabilities = 0;
        this.td2Crypto = new Td2Crypto[4];
        this.initiator = false;
        this.credential = td2Credential;
        this.requestedServices = (short)98;
        this.InitialiseData();
    }

    public Td2Context(Td2Credential td2Credential, Td2Name td2Name, int n, Object[] objectArray, short s) throws GSSException {
        String[] stringArray = new String[2];
        stringArray[0] = "small endien";
        stringArray[1] = "big endien";
        this.endien_txt = stringArray;
        this.MAXMSGSEQUENCECLIENT = 2;
        this.mySeqNum = new BigInteger("1");
        this.peerSeqNum = new BigInteger("0");
        this.peerCapabilities = 0;
        this.td2Crypto = new Td2Crypto[4];
        this.initiator = true;
        this.credential = td2Credential;
        this.targetName = td2Name;
        this.lifetime = n;
        this.requestedServices = s;
        this.InitialiseData();
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static Td2Version InquireMethodVersion() {
        Td2Version td2Version = new Td2Version();
        return td2Version;
    }

    private void InitialiseData() throws GSSException {
        this.msgsequence = 0;
        this.mylibraryversion = Td2Context.InquireLibraryVersion();
        this.mymethodversion = Td2Context.InquireMethodVersion();
        this.myendien = 1;
        this.mycbmaxtoken = 80;
        this.DH = new Td2DH();
        if (QOPComp == null) {
            int n = -520093543;
            throw new GSSException(11, n, "TdgssConfigApi.GetInfoForOid Failure");
        }
        this.TrailerBytes = this.GetTrailerBytes();
    }

    private TDGSSb ValidateMsgInfo(byte[] byArray, int n, int n2) throws GSSException {
        boolean bl;
        if (n2 <= 16) {
            throw new GSSException(10);
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n + n2 - 16, byArray2, 0, 16);
        TDGSSb tDGSSb = new TDGSSb(byArray2, 0);
        byte by = tDGSSb.b();
        byte by2 = tDGSSb.c();
        byte by3 = tDGSSb.d();
        if (by == 1 && (by2 != 3 && by2 != 4 || by3 != 2)) {
            throw new GSSException(10);
        }
        if (by == 3 && by2 != 7 && by2 != 8) {
            throw new GSSException(10);
        }
        boolean bl2 = bl = (tDGSSb.h() & 4) == 4;
        if (by == 3 && by2 == 7 && !bl ? n2 != tDGSSb.f() : n2 != tDGSSb.f() + 16) {
            throw new GSSException(10);
        }
        return tDGSSb;
    }

    public String[] ParseQOP(int n) throws GSSException {
        return QOPComp;
    }

    private byte[] GetTrailerBytes() throws GSSException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = this.getMech().getDER();
            String string = "0.0." + QOPValues[0] + "." + QOPValues[1] + "." + QOPValues[2] + "." + QOPValues[3] + "." + QOPValues[4] + ".0";
            Oid oid = new Oid(string);
            byte[] byArray3 = oid.getDER();
            byArray = new byte[byArray2.length + 1 + byArray3.length - 1 + 1 + 4 + 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[byArray2.length] = 70;
            System.arraycopy(byArray3, 1, byArray, byArray2.length + 1, byArray3.length - 1);
            byArray[byArray2.length + 1 + byArray3.length - 1] = 1;
            byte[] byArray4 = Td2Util.inttobytearray(byArray.length);
            System.arraycopy(byArray4, 0, byArray, byArray2.length + byArray3.length + 1, 4);
            byArray[byArray2.length + byArray3.length + 1 + 4] = 1;
        }
        catch (GSSException gSSException) {
            System.out.println(gSSException);
        }
        return byArray;
    }

    private byte[] BuildInitMsg(byte by) throws GSSException {
        String string = "Td2Context-BuildInitMsg:\t";
        byte[] byArray = null;
        byte[] byArray2 = null;
        Td2Util.prtdbg(string + "We will initiate the handshake now...");
        Td2Util.prtdbg(string + "Trailer Bytes :");
        byArray2 = this.TrailerBytes;
        if (byArray2 == null) {
            int n = -486538841;
            throw new GSSException(11, n, Td2Exception.ErrStr(n));
        }
        byte[] byArray3 = AlgParcel.getCipherSuitesParcel();
        int n = byArray3.length;
        Td2Util.hexDump(System.out, byArray2);
        int n2 = this.mycbmaxtoken + n + byArray2.length;
        byArray = new byte[n2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        TDGSSb tDGSSb = new TDGSSb(1, by, 1, this.isserver() ? (byte)1 : 0, 5, 0, 0, 64 + n, null);
        byte[] byArray4 = tDGSSb.a();
        System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
        byArray[16] = this.mylibraryversion.MajorRelease;
        byArray[17] = this.mylibraryversion.MinorRelease;
        byArray[18] = this.mylibraryversion.MaintenanceRelease;
        byArray[19] = this.mylibraryversion.EmergencyRelease;
        byte[] byArray5 = Td2Util.inttobytearray(n);
        System.arraycopy(byArray5, 0, byArray, 36, byArray5.length);
        System.arraycopy(byArray3, 0, byArray, this.mycbmaxtoken, n);
        System.arraycopy(byArray2, 0, byArray, this.mycbmaxtoken + n, byArray2.length);
        Td2Util.prtdbg(string + "Successfully generated first message as");
        Td2Util.hexDump(System.out, byArray);
        return byArray;
    }

    private int ProcessInitMsg(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = new byte[4];
        String string = "Td2Context-ProcessInitMsg:\t";
        Td2Util.prtdbg(string + "Receiving and processing first message");
        if (n != 0) {
            Td2Util.prtdbg(string + "Only offset = 0 is allowed!");
            return 587202984;
        }
        TDGSSb tDGSSb = new TDGSSb(byArray, n);
        this.mytargetendien = (tDGSSb.h() & 2) == 2 ? (byte)1 : 0;
        Td2Util.prtdbg(string + "Checking target endien as " + this.mytargetendien);
        if (this.byteflipneeded()) {
            Td2Util.prtdbg(string + "We have to byte-flip!");
        }
        if (!this.chklibrary(byArray, this.mylibraryversion)) {
            Td2Util.prtdbg(string + "*** Illegal library version *** ");
            return -486538862;
        }
        if (tDGSSb.c() != 1 && tDGSSb.c() != 2 || tDGSSb.d() != 1) {
            Td2Util.prtdbg(string + " Message header is not proper");
            return -486538855;
        }
        System.arraycopy(byArray, 32, byArray2, 0, 4);
        this.verifyDHKey = Td2Util.ByteAtoInt(byArray2);
        this.peerCapabilities = tDGSSb.i();
        Td2Util.prtdbg(string + "verifyDHKey= " + this.verifyDHKey);
        Td2Util.prtdbg(string + "The received message is OK!");
        return 587202960;
    }

    private void ExtractKeys(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = null;
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = new byte[4];
        byte[] byArray9 = null;
        String string = "Td2Context-ExtractKeys:\t";
        System.arraycopy(byArray, 20, byArray3, 0, 4);
        int n3 = Td2Util.ByteAtoInt(byArray3);
        byArray2 = new byte[n3];
        System.arraycopy(byArray, 80, byArray2, 0, n3);
        System.arraycopy(byArray, 24, byArray5, 0, 4);
        int n4 = Td2Util.ByteAtoInt(byArray5);
        byArray4 = new byte[n4];
        System.arraycopy(byArray, 80 + n3, byArray4, 0, n4);
        System.arraycopy(byArray, 28, byArray7, 0, 4);
        int n5 = Td2Util.ByteAtoInt(byArray7);
        byArray6 = new byte[n5];
        System.arraycopy(byArray, 80 + n3 + n4, byArray6, 0, n5);
        if ((this.peerCapabilities & 4) == 4) {
            System.arraycopy(byArray, 36, byArray8, 0, 4);
            int n6 = Td2Util.ByteAtoInt(byArray8);
            byArray9 = new byte[n6];
            System.arraycopy(byArray, 80 + n3 + n4 + n5, byArray9, 0, n6);
            object3 = new AlgQopDer(byArray9);
            this.globalQops = new AlgQop[4];
            this.globalQops[0] = ((AlgQopDer)object3).getAlgQop(0);
            this.globalQops[1] = ((AlgQopDer)object3).getAlgQop(1);
            this.globalQops[2] = ((AlgQopDer)object3).getAlgQop(2);
            this.globalQops[3] = ((AlgQopDer)object3).getAlgQop(3);
        } else {
            AlgQop algQop;
            object3 = QOPComp[0];
            String string2 = QOPComp[1].substring(1);
            int n7 = Integer.parseInt(string2);
            String string3 = QOPComp[2];
            object2 = QOPComp[3];
            object = QOPComp[4];
            String string4 = "DH";
            int n8 = 640;
            this.legacyQop = algQop = new AlgQop((String)object3, n7, string3, (String)object2, (String)object, string4, n8);
        }
        Td2Util.prtdbg(string + "Generate DH Parameters ...");
        this.DH.GenerateParameters(1, byArray4, byArray2);
        Td2Util.prtdbg(string + "Generate DH Public Key ...");
        this.publicKeybuf = this.DH.GenerateKey();
        Td2Util.prtdbg(string + "Compute  DH Private Key ...");
        this.masterKey = this.DH.ComputeKey(byArray6);
        Td2Util.prtdbg(string + "The Master Key is ***********************************");
        Td2Util.hexDump(System.out, this.masterKey);
        this.publicKeyLength = n5;
        if ((this.peerCapabilities & 4) == 4) {
            int n9 = 0;
            for (int i = 0; i < 4; ++i) {
                AlgQop algQop = this.globalQops[i];
                int n10 = algQop.getKeyLength() / 8;
                object2 = new byte[n10];
                System.arraycopy(this.masterKey, n9, object2, 0, n10);
                object = this.DH.BytetoKey(algQop.getConfidentialityAlgorithm(), (byte[])object2, 0, n10);
                this.td2Crypto[i] = new Td2Crypto((SecretKey)object, (byte[])object2, algQop, this.peerCapabilities);
                this.td2Crypto[i].computeKeyHash();
                n9 += n10;
            }
        } else {
            object3 = this.DH.BytetoKey(this.legacyQop.getConfidentialityAlgorithm(), this.masterKey, 0, this.legacyQop.getKeyLength() / 8);
            this.td2Crypto[0] = new Td2Crypto((SecretKey)object3, this.masterKey, this.legacyQop, this.peerCapabilities);
            this.td2Crypto[0].computeKeyHash();
        }
        this.protReady = true;
    }

    private byte[] BuildServerMsg() throws GSSException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string = "Td2Context-BuildServerMsg:\t";
        byte by = 1;
        if ((this.peerCapabilities & 1) == 1) {
            by = 3;
        }
        TDGSSb tDGSSb = new TDGSSb(by, 1, 2, this.isserver() ? (byte)1 : 0, 0, 0, 0, this.publicKeyLength, null);
        byte[] byArray3 = tDGSSb.a();
        if (this.verifyDHKey > 0) {
            this.MAXMSGSEQUENCECLIENT = 3;
            MessageProp messageProp = new MessageProp(0, true);
            byArray2 = this.wrap(this.masterKey, 0, this.masterKey.length, messageProp);
            byArray = new byte[16 + this.publicKeyLength + byArray2.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            System.arraycopy(this.publicKeybuf, 0, byArray, byArray3.length, this.publicKeybuf.length);
            System.arraycopy(byArray2, 0, byArray, byArray3.length + this.publicKeybuf.length, byArray2.length);
        } else {
            byArray = new byte[16 + this.publicKeyLength];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            System.arraycopy(this.publicKeybuf, 0, byArray, byArray3.length, this.publicKeybuf.length);
        }
        this.publicKeybuf = null;
        Td2Util.prtdbg(string + "The received message is OK!");
        return byArray;
    }

    public void setkey(byte[] byArray) {
        this.masterKey = (byte[])byArray.clone();
    }

    public boolean byteflipneeded() {
        boolean bl = false;
        String string = "Td2Context-byteflipneeded:\t";
        if (this.mytargetendien != this.myendien) {
            Td2Util.prtdbg(string + "target endien is [" + this.endien_txt[this.mytargetendien] + "] different against our endien [" + this.endien_txt[this.myendien] + "]");
            try {
                if (this.isserver()) {
                    Td2Util.prtdbg(string + "We are server! No need to byte-flip!");
                } else {
                    Td2Util.prtdbg(string + "We are client, we have to byte-flip!");
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public byte[] msgcvt(byte[] byArray) {
        String string = "Td2Context-msgcvt:\t";
        if (!this.byteflipneeded()) {
            Td2Util.prtdbg(string + "No flipping needed!");
            return byArray;
        }
        int n = 0;
        while (n + 3 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 3];
            byArray[n + 3] = by;
            by = byArray[n + 1];
            byArray[n + 1] = byArray[n + 2];
            byArray[n + 2] = by;
            n += 4;
        }
        return byArray;
    }

    private boolean chklibrary(byte[] byArray, TdgssVersion tdgssVersion) {
        return byArray[16] >= 6;
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        String string = "Td2Context-initSecContext:\t";
        Td2Util.prtdbg(string + "msgsequence is now " + this.msgsequence);
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 0;
                Td2Util.prtdbg(string + "Confirming that we are now " + msgexttxt[this.server_client]);
                byArray2 = this.BuildInitMsg((byte)1);
                break;
            }
            case 1: {
                Td2Util.prtdbg(string + "Just receive info-data from server as:");
                Td2Util.hexDump(System.out, byArray);
                int n3 = this.ProcessInitMsg(byArray, n, n2);
                if (n3 != 587202960) {
                    throw new GSSException(11, n3, Td2Exception.ErrStr(n3));
                }
                this.ExtractKeys(byArray, n, n2);
                byArray2 = this.BuildServerMsg();
                break;
            }
            case 2: {
                Td2Util.prtdbg(string + "Key Match Result From Srvr " + byArray[0]);
                if (byArray[0] == 0) break;
                throw new GSSException(11, -486538842, Td2Exception.ErrStr(-486538842));
            }
            default: {
                int n4 = -486538860;
                throw new GSSException(11, n4, Td2Exception.ErrStr(n4));
            }
        }
        ++this.msgsequence;
        Td2Util.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        String string = "Td2Context-acceptSecContext:\t";
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 1;
                Td2Util.prtdbg(string + "Just receive info-data from client as:");
                Td2Util.hexDump(System.out, byArray);
                byArray2 = this.BuildInitMsg((byte)2);
                int n3 = this.ProcessInitMsg(byArray, n, n2);
                if (n3 == 587202960) break;
                throw new GSSException(11, n3, Td2Exception.ErrStr(n3));
            }
            default: {
                int n4 = -486538860;
                throw new GSSException(11, n4, Td2Exception.ErrStr(n4));
            }
        }
        ++this.msgsequence;
        Td2Util.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public boolean isEstablished() {
        boolean bl = false;
        int n = 0;
        String string = "Td2Context-isEstablished:\t";
        try {
            n = this.isserver() ? 1 : this.MAXMSGSEQUENCECLIENT;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.msgsequence >= n) {
            bl = true;
        }
        Td2Util.prtdbg(string + "Leaving with retcode = " + bl);
        return bl;
    }

    public boolean isserver() throws GSSException {
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new GSSException(11);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (!this.isProtReady()) {
            int n3 = -486538835;
            throw new GSSException(11, n3, Td2Exception.ErrStr(n3));
        }
        n = this.validateQop(n);
        int n4 = this.td2Crypto[n].getWrapSizeLimit(n, bl, n2);
        return n4;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        String string = "Td2Context-wrap:\t";
        Td2Util.prtdbg(string + "Entering!");
        int n3 = 0;
        boolean bl = false;
        byte by = 0;
        TDGSSb tDGSSb = null;
        if (!this.isProtReady()) {
            int n4 = -486538835;
            throw new GSSException(11, n4, Td2Exception.ErrStr(n4));
        }
        if (n < 0 || n2 < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        if (messageProp != null) {
            n3 = messageProp.getQOP();
        }
        n3 = this.validateQop(n3);
        if (this.getConfState() && messageProp != null && messageProp.getPrivacy()) {
            by = (byte)(by | 4);
            bl = true;
        }
        if (this.peerCapabilities == 0) {
            tDGSSb = new TDGSSb(1, 3, 2, this.isserver() ? (byte)1 : 0, 255, by, n3, 0, null);
        } else if ((this.peerCapabilities & 1) == 1) {
            tDGSSb = new TDGSSb(3, 7, 2, this.isserver() ? (byte)1 : 0, 1, by, n3, 0, this.mySeqNum);
        } else {
            int n5 = -486538855;
            throw new GSSException(11, n5, "Unknown peer capabilities");
        }
        byte[] byArray2 = this.td2Crypto[n3].wrap(byArray, n, n2, messageProp, tDGSSb);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        if (bl) {
            messageProp.setPrivacy(true);
        }
        Td2Util.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        String string = "Td2Context-unwrap:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (!this.isProtReady()) {
            int n3 = -486538835;
            throw new GSSException(11, n3, Td2Exception.ErrStr(n3));
        }
        if (n < 0 || n2 < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray == null) {
            Td2Util.prtdbg(string + "Input argument is null");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        TDGSSb tDGSSb = this.ValidateMsgInfo(byArray, n, n2);
        boolean bl = (tDGSSb.h() & 4) == 4;
        if ((this.peerCapabilities & 1) == 1) {
            BigInteger bigInteger;
            this.peerSeqNum = bigInteger = tDGSSb.j();
        }
        int n4 = tDGSSb.g();
        n4 = this.validateQop(n4);
        byte[] byArray2 = this.td2Crypto[n4].unwrap(byArray, n, n2, messageProp, tDGSSb);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        if (messageProp != null) {
            messageProp.setPrivacy(bl);
            messageProp.setQOP(n4);
        }
        Td2Util.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        int n3 = 0;
        TDGSSb tDGSSb = null;
        String string = "Td2Context-getMIC:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (!this.isProtReady()) {
            int n4 = -486538835;
            throw new GSSException(11, n4, Td2Exception.ErrStr(n4));
        }
        if (n < 0 || n2 < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        if (messageProp != null) {
            n3 = messageProp.getQOP();
        }
        n3 = this.validateQop(n3);
        byte by = 0;
        if (this.peerCapabilities == 0) {
            tDGSSb = new TDGSSb(1, 4, 2, this.isserver() ? (byte)1 : 0, 255, by, n3, 0, null);
        } else if ((this.peerCapabilities & 1) == 1) {
            tDGSSb = new TDGSSb(3, 8, 2, this.isserver() ? (byte)1 : 0, 1, by, n3, 0, this.mySeqNum);
        } else {
            int n5 = -486538855;
            throw new GSSException(11, n5, "Unknown peer capabilities");
        }
        byte[] byArray2 = this.td2Crypto[n3].getMIC(byArray, n, n2, messageProp, tDGSSb);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        Td2Util.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        String string = "Td2Context-verifyMIC:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (!this.isProtReady()) {
            int n5 = -486538835;
            throw new GSSException(11, n5, Td2Exception.ErrStr(n5));
        }
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            Td2Util.prtdbg(string + "Input length " + " is larger than buffer size ");
            throw new GSSException(11);
        }
        TDGSSb tDGSSb = this.ValidateMsgInfo(byArray, n, n2);
        if ((this.peerCapabilities & 1) == 1) {
            BigInteger bigInteger;
            this.peerSeqNum = bigInteger = tDGSSb.j();
        }
        int n6 = tDGSSb.g();
        n6 = this.validateQop(n6);
        this.td2Crypto[n6].verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp, tDGSSb);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        Td2Util.prtdbg(string + "Leaving!");
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    private int validateQop(int n) throws GSSException {
        block5: {
            block3: {
                block4: {
                    if ((this.peerCapabilities & 4) != 4) break block3;
                    if (n < 0) break block4;
                    if (n < 4) break block5;
                }
                int n2 = -486538834;
                throw new GSSException(14, n2, Td2Exception.ErrStr(n2));
            }
            if (n != 0) {
                int n3 = -486538834;
                throw new GSSException(14, n3, Td2Exception.ErrStr(n3));
            }
        }
        return n;
    }

    public byte[] export() throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.lifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
    }

    public boolean getCredDelegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getMutualAuthState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getReplayDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getSequenceDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getAnonymityState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getConfState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getIntegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public int getLifetime() {
        if (this.isEstablished()) {
            return this.lifetime;
        }
        return 0;
    }

    public boolean isTransferable() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean isProtReady() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.protReady;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return Td2Mechanism.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    static {
        String[] stringArray = new String[2];
        stringArray[0] = "client";
        stringArray[1] = "server";
        msgexttxt = stringArray;
        TdgssConfigApi tdgssConfigApi = TdgssConfigApi.getInstance();
        if (tdgssConfigApi == null) {
            QOPComp = null;
            QOPValues = null;
        } else {
            try {
                Oid oid = Td2Mechanism.mechOid;
                QOPComp = tdgssConfigApi.GetInforForOID(oid.toString());
            }
            catch (Exception exception) {
                QOPComp = null;
                QOPValues = null;
            }
            if (QOPComp != null) {
                QOPValues = new Integer[5];
                Td2Context.QOPValues[0] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", QOPComp[0]);
                Td2Context.QOPValues[1] = tdgssConfigApi.GetPropertyForLegal("KeyLength", QOPComp[1]);
                Td2Context.QOPValues[2] = tdgssConfigApi.GetPropertyForLegal("Mode", QOPComp[2]);
                Td2Context.QOPValues[3] = tdgssConfigApi.GetPropertyForLegal("Padding", QOPComp[3]);
                Td2Context.QOPValues[4] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", QOPComp[4]);
            }
        }
    }
}

