/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jgssp2ldap.LdapUtil;
import com.teradata.tdgss.jgssp2td2.TDGSSb;
import com.teradata.tdgss.jgssp2td2.Td2Exception;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public final class Td2Crypto {
    private static final String prog = "Td2Crypto";
    private SecretKey secretKey;
    private byte[] key;
    private byte[] hSecretKey;
    private AlgQop algQop;
    private String encAlg;
    private String mode;
    private String padding;
    private String micAlg;
    private int peerCapabilities;
    private MessageDigest wrapDigest;
    private MessageDigest unwrapDigest;
    private MessageDigest getMicDigest;
    private MessageDigest verifyMicDigest;

    public Td2Crypto(SecretKey secretKey, byte[] byArray, AlgQop algQop, int n) throws GSSException {
        this.secretKey = secretKey;
        this.key = byArray;
        this.algQop = algQop;
        this.hSecretKey = null;
        this.encAlg = algQop.getConfidentialityAlgorithm();
        this.mode = algQop.getMode();
        this.padding = algQop.getPadding();
        this.micAlg = algQop.getIntegrityAlgorithm();
        this.peerCapabilities = n;
        try {
            this.wrapDigest = MessageDigest.getInstance(this.micAlg);
            this.unwrapDigest = MessageDigest.getInstance(this.micAlg);
            this.getMicDigest = MessageDigest.getInstance(this.micAlg);
            this.verifyMicDigest = MessageDigest.getInstance(this.micAlg);
        }
        catch (Exception exception) {
            int n2 = -486538839;
            GSSException gSSException = new GSSException(11, n2, Td2Exception.ErrStr(n2));
            gSSException.initCause(exception);
            throw gSSException;
        }
    }

    public void computeKeyHash() throws GSSException {
        String string = "Td2Crypto-computeKeyHash:\t";
        if ((this.peerCapabilities & 1) == 1) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.micAlg);
                messageDigest.update(this.key, 0, this.key.length);
                this.hSecretKey = messageDigest.digest();
                LdapUtil.prtdbg(string + "The Secret Key hash is ************************");
                LdapUtil.hexDump(System.out, this.hSecretKey);
            }
            catch (Exception exception) {
                int n = -486538839;
                throw new GSSException(11, n, Td2Exception.ErrStr(n));
            }
        }
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp, TDGSSb tDGSSb) throws GSSException {
        boolean bl = false;
        byte[] byArray2 = new byte[]{};
        String string = "Td2Crypto-wrap:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        if (tDGSSb == null) {
            Td2Util.prtdbg(string + "Token Header is null");
            throw new GSSException(11);
        }
        if (this.wrapDigest == null) {
            Td2Util.prtdbg(string + "Wrap digest argument is null");
            throw new GSSException(11);
        }
        if ((tDGSSb.h() & 4) == 4) {
            bl = true;
        }
        if (this.peerCapabilities == 0) {
            this.wrapDigest.update(byArray, n, n2);
            byte[] byArray3 = this.wrapDigest.digest();
            int n3 = n2 + byArray3.length;
            if (!bl) {
                byte[] byArray4 = new byte[n3 + 16];
                tDGSSb.a(n3);
                byte[] byArray5 = tDGSSb.a();
                System.arraycopy(byArray, n, byArray4, 0, n2);
                System.arraycopy(byArray3, 0, byArray4, n2, byArray3.length);
                System.arraycopy(byArray5, 0, byArray4, n3, byArray5.length);
                byArray2 = byArray4;
            } else {
                int n4;
                byte[] byArray6;
                String string2 = this.encAlg + "/" + this.mode + "/" + this.padding;
                byte[] byArray7 = new byte[n3];
                System.arraycopy(byArray, n, byArray7, 0, n2);
                System.arraycopy(byArray3, 0, byArray7, n2, byArray3.length);
                int n5 = byArray7.length;
                try {
                    Cipher cipher = Cipher.getInstance(string2);
                    if (this.padding.equalsIgnoreCase("NoPadding")) {
                        int n6 = cipher.getBlockSize();
                        n5 = byArray7.length / n6 * n6;
                    }
                    if (this.mode.equalsIgnoreCase("ECB")) {
                        cipher.init(1, this.secretKey);
                    } else {
                        byte[] byArray8 = new byte[cipher.getBlockSize()];
                        for (int i = 0; i < byArray8.length; ++i) {
                            byArray8[i] = 0;
                        }
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray8);
                        cipher.init(1, (Key)this.secretKey, ivParameterSpec);
                    }
                    byArray6 = cipher.doFinal(byArray7, 0, n5);
                    n4 = byArray6.length;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    int n7 = -486538838;
                    throw new GSSException(11, n7, Td2Exception.ErrStr(n7));
                }
                tDGSSb.a(n4);
                byte[] byArray9 = tDGSSb.a();
                byArray2 = new byte[n4 + 16];
                System.arraycopy(byArray6, 0, byArray2, 0, byArray6.length);
                System.arraycopy(byArray9, 0, byArray2, byArray6.length, byArray9.length);
            }
        } else if ((this.peerCapabilities & 1) == 1) {
            if (this.hSecretKey == null) {
                int n8 = -486538852;
                throw new GSSException(11, n8, Td2Exception.ErrStr(n8));
            }
            int n9 = n2 + this.hSecretKey.length;
            tDGSSb.a(n9 + 16);
            byte[] byArray10 = new byte[n9 + 16];
            System.arraycopy(byArray, n, byArray10, 0, n2);
            System.arraycopy(this.hSecretKey, 0, byArray10, n2, this.hSecretKey.length);
            if (!bl) {
                byte[] byArray11 = tDGSSb.a();
                System.arraycopy(byArray11, 0, byArray10, n9, byArray11.length);
                this.wrapDigest.update(byArray10);
                byte[] byArray12 = this.wrapDigest.digest();
                System.arraycopy(byArray12, 0, byArray10, n2, byArray12.length);
                byArray2 = byArray10;
            } else {
                byte[] byArray13;
                int n10;
                String string3 = this.encAlg + "/" + this.mode + "/" + this.padding;
                int n11 = byArray10.length;
                byte[] byArray14 = tDGSSb.a();
                try {
                    Cipher cipher = Cipher.getInstance(string3);
                    if (this.padding.equalsIgnoreCase("NoPadding")) {
                        int n12 = cipher.getBlockSize();
                        n11 = byArray10.length / n12 * n12;
                    }
                    if (this.mode.equalsIgnoreCase("ECB")) {
                        cipher.init(1, this.secretKey);
                    } else {
                        byArray14 = tDGSSb.a();
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray14);
                        cipher.init(1, (Key)this.secretKey, ivParameterSpec);
                    }
                    n10 = cipher.getOutputSize(n11);
                    tDGSSb.a(n10);
                    byArray14 = tDGSSb.a();
                    System.arraycopy(byArray14, 0, byArray10, n9, byArray14.length);
                    this.wrapDigest.update(byArray10);
                    byte[] byArray15 = this.wrapDigest.digest();
                    System.arraycopy(byArray15, 0, byArray10, byArray.length, byArray15.length);
                    if (!this.mode.equalsIgnoreCase("ECB")) {
                        byArray14 = tDGSSb.a();
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray14);
                        cipher.init(1, (Key)this.secretKey, ivParameterSpec);
                    }
                    byArray13 = cipher.doFinal(byArray10, 0, n11);
                }
                catch (InvalidKeyException invalidKeyException) {
                    int n13 = -486538831;
                    throw new GSSException(11, n13, Td2Exception.ErrStr(n13));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    int n14 = -486538838;
                    throw new GSSException(11, n14, Td2Exception.ErrStr(n14));
                }
                byArray2 = new byte[n10 + 16];
                System.arraycopy(byArray13, 0, byArray2, 0, byArray13.length);
                System.arraycopy(byArray14, 0, byArray2, byArray13.length, byArray14.length);
            }
        } else {
            int n15 = -486538855;
            throw new GSSException(11, n15, "Unknown peer capabilities");
        }
        Td2Util.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp, TDGSSb tDGSSb) throws GSSException {
        String string;
        byte[] byArray2;
        block31: {
            block32: {
                int n3;
                boolean bl;
                block34: {
                    block33: {
                        block28: {
                            block30: {
                                block29: {
                                    bl = false;
                                    byArray2 = new byte[]{};
                                    n3 = 0;
                                    string = "Td2Crypto-unwrap:\t";
                                    Td2Util.prtdbg(string + "Entering!");
                                    if (n < 0 || n2 < 0) {
                                        Td2Util.prtdbg(string + "Argument out of Range");
                                        throw new GSSException(11);
                                    }
                                    if (byArray == null) {
                                        Td2Util.prtdbg(string + "Input argument is null");
                                        throw new GSSException(11);
                                    }
                                    if (byArray.length < n2 + n) {
                                        Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
                                        throw new GSSException(11);
                                    }
                                    if (tDGSSb == null) {
                                        Td2Util.prtdbg(string + "Token Header is null");
                                        throw new GSSException(11);
                                    }
                                    if (this.unwrapDigest == null) {
                                        Td2Util.prtdbg(string + "Unwrap digest is null");
                                        throw new GSSException(11);
                                    }
                                    if ((tDGSSb.h() & 4) == 4) {
                                        bl = true;
                                    }
                                    n3 = this.unwrapDigest.getDigestLength();
                                    if (this.peerCapabilities != 0) break block28;
                                    if (tDGSSb.b() != 1) break block29;
                                    if (tDGSSb.c() == 3) break block30;
                                }
                                int n4 = -486538855;
                                throw new GSSException(11, n4, Td2Exception.ErrStr(n4));
                            }
                            if (!bl) {
                                int n5 = n2 - n3 - 16;
                                byte[] byArray3 = new byte[n5];
                                byte[] byArray4 = new byte[n3];
                                System.arraycopy(byArray, n, byArray3, 0, n5);
                                System.arraycopy(byArray, n + n5, byArray4, 0, n3);
                                if (!this.verifyHash(byArray3, byArray4, this.unwrapDigest)) {
                                    throw new GSSException(6);
                                }
                                byArray2 = byArray3;
                            } else {
                                byte[] byArray5 = new byte[n2 - 16];
                                byte[] byArray6 = new byte[]{};
                                String string2 = this.encAlg + "/" + this.mode + "/" + this.padding;
                                System.arraycopy(byArray, n, byArray5, 0, n2 - 16);
                                try {
                                    Cipher cipher = Cipher.getInstance(string2);
                                    byte[] byArray7 = new byte[cipher.getBlockSize()];
                                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray7);
                                    cipher.init(2, (Key)this.secretKey, ivParameterSpec);
                                    byArray6 = cipher.doFinal(byArray5, 0, byArray5.length);
                                }
                                catch (Exception exception) {
                                    int n6 = -486538838;
                                    throw new GSSException(11, n6, Td2Exception.ErrStr(n6));
                                }
                                int n7 = byArray6.length - n3;
                                byte[] byArray8 = new byte[n7];
                                byte[] byArray9 = new byte[n3];
                                System.arraycopy(byArray6, 0, byArray8, 0, n7);
                                System.arraycopy(byArray6, n7, byArray9, 0, n3);
                                if (!this.verifyHash(byArray8, byArray9, this.unwrapDigest)) {
                                    throw new GSSException(6);
                                }
                                byArray2 = byArray8;
                            }
                            break block31;
                        }
                        if ((this.peerCapabilities & 1) != 1) break block32;
                        if (tDGSSb.b() != 3) break block33;
                        if (tDGSSb.c() == 7) break block34;
                    }
                    int n8 = -486538855;
                    throw new GSSException(11, n8, Td2Exception.ErrStr(n8));
                }
                if (!bl) {
                    byte[] byArray10 = (byte[])byArray.clone();
                    byte[] byArray11 = new byte[n3];
                    int n9 = n2 - n3 - 16;
                    System.arraycopy(this.hSecretKey, 0, byArray10, n9, this.hSecretKey.length);
                    System.arraycopy(byArray, n + n9, byArray11, 0, n3);
                    if (!this.verifyHash(byArray10, byArray11, this.unwrapDigest)) {
                        throw new GSSException(6);
                    }
                    byArray2 = new byte[n9];
                    System.arraycopy(byArray10, 0, byArray2, 0, n9);
                } else {
                    byte[] byArray12;
                    byte[] byArray13 = new byte[n2 - 16];
                    byte[] byArray14 = new byte[16];
                    String string3 = this.encAlg + "/" + this.mode + "/" + this.padding;
                    System.arraycopy(byArray, n, byArray13, 0, n2 - 16);
                    System.arraycopy(byArray, n + n2 - 16, byArray14, 0, 16);
                    try {
                        Cipher cipher = Cipher.getInstance(string3);
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray14);
                        cipher.init(2, (Key)this.secretKey, ivParameterSpec);
                        byArray12 = cipher.doFinal(byArray13, 0, byArray13.length);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        int n10 = -486538831;
                        throw new GSSException(11, n10, Td2Exception.ErrStr(n10));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        int n11 = -486538838;
                        throw new GSSException(11, n11, Td2Exception.ErrStr(n11));
                    }
                    for (int i = 0; i < 16; ++i) {
                        byte by = byArray12[byArray12.length - 16 + i];
                        if (by == byArray14[i]) continue;
                        int n12 = -486538839;
                        throw new GSSException(11, n12, Td2Exception.ErrStr(n12));
                    }
                    byte[] byArray15 = (byte[])byArray12.clone();
                    byte[] byArray16 = new byte[n3];
                    int n13 = byArray12.length - n3 - 16;
                    System.arraycopy(this.hSecretKey, 0, byArray15, n13, n3);
                    System.arraycopy(byArray12, n13, byArray16, 0, n3);
                    if (!this.verifyHash(byArray15, byArray16, this.unwrapDigest)) {
                        throw new GSSException(6);
                    }
                    byArray2 = new byte[n13];
                    System.arraycopy(byArray15, 0, byArray2, 0, n13);
                }
                break block31;
            }
            int n14 = -486538855;
            throw new GSSException(11, n14, "Unknown peer capabilities");
        }
        Td2Util.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp, TDGSSb tDGSSb) throws GSSException {
        byte[] byArray2 = new byte[]{};
        String string = "Td2Crypto-wrap:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        if (tDGSSb == null) {
            Td2Util.prtdbg(string + "Token Header is null");
            throw new GSSException(11);
        }
        if (this.getMicDigest == null) {
            Td2Util.prtdbg(string + "Get MIC digest is null");
            throw new GSSException(11);
        }
        if (this.peerCapabilities == 0) {
            this.getMicDigest.update(byArray, n, n2);
            byte[] byArray3 = this.getMicDigest.digest();
            int n3 = byArray3.length;
            byte[] byArray4 = new byte[n3 + 16];
            tDGSSb.a(n3);
            byte[] byArray5 = tDGSSb.a();
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
            System.arraycopy(byArray5, 0, byArray4, n3, byArray5.length);
            byArray2 = byArray4;
        } else if ((this.peerCapabilities & 1) == 1) {
            int n4 = this.getMicDigest.getDigestLength();
            int n5 = n2 + this.hSecretKey.length;
            tDGSSb.a(n4);
            byte[] byArray6 = new byte[n5 + 16];
            System.arraycopy(byArray, n, byArray6, 0, n2);
            System.arraycopy(this.hSecretKey, 0, byArray6, n2, this.hSecretKey.length);
            byte[] byArray7 = tDGSSb.a();
            System.arraycopy(byArray7, 0, byArray6, n5, byArray7.length);
            this.getMicDigest.update(byArray6);
            byte[] byArray8 = this.getMicDigest.digest();
            byArray2 = new byte[n4 + 16];
            System.arraycopy(byArray8, 0, byArray2, 0, byArray8.length);
            System.arraycopy(byArray7, 0, byArray2, byArray8.length, 16);
            byArray2 = byArray6;
        } else {
            int n6 = -486538855;
            throw new GSSException(11, n6, "Unknown peer capabilities");
        }
        Td2Util.prtdbg(string + "Leaving!");
        return byArray2;
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp, TDGSSb tDGSSb) throws GSSException {
        String string;
        block15: {
            block16: {
                int n5;
                block18: {
                    block17: {
                        block12: {
                            block14: {
                                block13: {
                                    string = "Td2Crypto-verifyMIC:\t";
                                    Td2Util.prtdbg(string + "Entering!");
                                    if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
                                        Td2Util.prtdbg(string + "Argument out of Range");
                                        throw new GSSException(11);
                                    }
                                    if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
                                        Td2Util.prtdbg(string + "Input length " + " is larger than buffer size ");
                                        throw new GSSException(11);
                                    }
                                    n5 = this.verifyMicDigest.getDigestLength();
                                    if (this.peerCapabilities != 0) break block12;
                                    if (tDGSSb.b() != 1) break block13;
                                    if (tDGSSb.c() == 4) break block14;
                                }
                                int n6 = -486538855;
                                throw new GSSException(11, n6, Td2Exception.ErrStr(n6));
                            }
                            byte[] byArray3 = new byte[n5];
                            byte[] byArray4 = new byte[n4];
                            System.arraycopy(byArray, n, byArray3, 0, n5);
                            System.arraycopy(byArray2, n3, byArray4, 0, n4);
                            if (!this.verifyHash(byArray4, byArray3, this.verifyMicDigest)) {
                                throw new GSSException(6);
                            }
                            break block15;
                        }
                        if ((this.peerCapabilities & 1) != 1) break block16;
                        if (tDGSSb.b() != 3) break block17;
                        if (tDGSSb.c() == 8) break block18;
                    }
                    int n7 = -486538855;
                    throw new GSSException(11, n7, Td2Exception.ErrStr(n7));
                }
                int n8 = n4 + n5 + 16;
                byte[] byArray5 = new byte[n5];
                byte[] byArray6 = new byte[n8];
                byte[] byArray7 = tDGSSb.a();
                System.arraycopy(byArray, n, byArray5, 0, n5);
                System.arraycopy(byArray2, n3, byArray6, 0, n4);
                System.arraycopy(this.hSecretKey, 0, byArray6, n4, this.hSecretKey.length);
                System.arraycopy(byArray7, 0, byArray6, n8 - 16, 16);
                if (!this.verifyHash(byArray6, byArray5, this.verifyMicDigest)) {
                    throw new GSSException(6);
                }
                break block15;
            }
            int n9 = -486538855;
            throw new GSSException(11, n9, "Unknown peer capabilities");
        }
        Td2Util.prtdbg(string + "Leaving!");
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        int n3;
        String string = "Td2Crypto-getWrapSizeLimit:\t";
        Td2Util.prtdbg(string + "Entering!");
        int n4 = 0;
        if (n2 < 16) {
            return 0;
        }
        if (bl) {
            n3 = this.getMaxInputLength(n2 - 16);
            n4 = n3 > 16 ? n3 : 0;
            if (n4 > 16) {
                n4 -= 16;
            }
        } else {
            n4 = n2 - 16;
        }
        if (n4 > (n3 = this.wrapDigest.getDigestLength())) {
            n4 -= n3;
        }
        Td2Util.prtdbg(string + "Leaving!");
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getMaxInputLength(int n) throws GSSException {
        String string = this.encAlg + "/" + this.mode + "/" + this.padding;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            Cipher cipher = Cipher.getInstance(string);
            if (this.mode.equalsIgnoreCase("ECB")) {
                cipher.init(1, this.secretKey);
            } else {
                byte[] byArray = new byte[cipher.getBlockSize()];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = 0;
                }
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
                cipher.init(1, (Key)this.secretKey, ivParameterSpec);
            }
            n3 = cipher.getBlockSize();
        }
        catch (InvalidKeyException invalidKeyException) {
            int n6 = -486538831;
            throw new GSSException(11, n6, Td2Exception.ErrStr(n6));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            int n7 = -486538838;
            throw new GSSException(11, n7, Td2Exception.ErrStr(n7));
        }
        n2 = 0;
        n4 = n;
        if (this.mode.equalsIgnoreCase("CBC")) {
            if (n4 < n3) {
                return 0;
            }
            n5 = n4 % n3;
            if (this.padding.equalsIgnoreCase("NoPadding")) {
                return n4 - n5;
            }
            if (!this.padding.equalsIgnoreCase("PKCS5Padding")) return 0;
            return n4 - (n3 + n5);
        }
        if (!this.mode.equalsIgnoreCase("CFB")) {
            if (!this.mode.equalsIgnoreCase("OFB")) return 0;
        }
        n5 = n4 >= n3 ? n4 % n3 : 0;
        if (this.padding.equalsIgnoreCase("NoPadding")) {
            return n4;
        }
        if (!this.padding.equalsIgnoreCase("PKCS5Padding")) return 0;
        if (n4 < n3) return 0;
        return n4 - (n5 + 1);
    }

    private boolean verifyHash(byte[] byArray, byte[] byArray2, MessageDigest messageDigest) {
        messageDigest.update(byArray);
        byte[] byArray3 = messageDigest.digest();
        if (byArray3.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

