/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jgssp2td2.Td2Context;
import com.teradata.tdgss.jgssp2td2.Td2Credential;
import com.teradata.tdgss.jgssp2td2.Td2Name;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import com.teradata.tdgss.jgssspi.TDGSSa;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class Td2Mechanism
implements TDGSSa {
    private static Oid _mechOid;
    private static Oid GSS_C_NT_TDAT_MECHDATA;
    private static Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF16;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF32;
    protected static final int TDATMETHODMAXTOKEN = 80;
    private static final int AUTHTERADATA = 8;
    private static final String AUTHTERADATASTR;
    private static final String prog = "Td2Mechanism";
    protected static final Oid mechOid;
    protected static final short servicesAvailable = 98;
    protected static short servicesNeeded;

    public Td2Mechanism() {
        servicesNeeded = (short)98;
    }

    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        String string = "Td2Mechanism-acceptable:\t";
        if (object == null) {
            Td2Util.prtdbg(string + "Token is null");
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (byArray.length <= 0 || byArray.length > 80) {
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof Td2Credential)) {
            Td2Util.prtdbg("GSSException.DEFECTIVE_CREDENTIALmust be a credential created by this mech");
            return false;
        }
        return true;
    }

    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        Td2Util.prtdbg("getContextForAccept ");
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new GSSException(10);
        }
        return new Td2Context((Td2Credential)gSSCredential, objectArray);
    }

    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        Td2Util.prtdbg("getContextForInit ");
        s = (short)(s & 0x62);
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s)) {
            throw new GSSException(10);
        }
        return new Td2Context((Td2Credential)gSSCredential, (Td2Name)gSSName, n, objectArray, s);
    }

    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        String string = "Td2Mechanism-initable:\t";
        if (gSSCredential != null && !(gSSCredential instanceof Td2Credential)) {
            Td2Util.prtdbg(string + "GSSException.DEFECTIVE_CREDENTIAL: " + "must be a credential created by this mech");
            return false;
        }
        if (gSSName != null && !(gSSName instanceof Td2Name)) {
            Td2Util.prtdbg(string + "must be a name created by this mech");
            return false;
        }
        return true;
    }

    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        Td2Name td2Name;
        if (gSSName == null) {
            td2Name = null;
        } else if (gSSName instanceof Td2Name) {
            td2Name = (Td2Name)gSSName;
        } else {
            throw new GSSException(3);
        }
        return new Td2Credential(td2Name, n, n2);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        return new Td2Name(byArray, oid);
    }

    public Oid[] getNames() {
        Oid[] oidArray = new Oid[]{GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA, GSS_C_NT_TDAT_MECHDATA, GSS_C_NT_TDAT_MECHDATA_UTF8, GSS_C_NT_TDAT_MECHDATA_UTF16, GSS_C_NT_TDAT_MECHDATA_UTF32};
        return oidArray;
    }

    public Oid getMech() {
        return mechOid;
    }

    public short getServices() {
        return 98;
    }

    static {
        AUTHTERADATASTR = new String("TERADATA");
        try {
            _mechOid = new Oid("1.3.6.1.4.1.191.1.1012.1.1.9");
            GSS_C_NT_TDAT_MECHDATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.2");
            GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.1");
            GSS_C_NT_TDAT_MECHDATA_UTF8 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.3");
            GSS_C_NT_TDAT_MECHDATA_UTF16 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.4");
            GSS_C_NT_TDAT_MECHDATA_UTF32 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.5");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError("Oid string is incorrectly formatted");
        }
        mechOid = _mechOid;
        servicesNeeded = 0;
    }
}

