/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.TDGSSa;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class TdgssName
implements GSSName {
    private byte[] name;
    private Oid nameType;
    private Hashtable nameImplementations;
    public static Oid GSS_C_NT_TDAT_MECHDATA;
    public static Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF16;

    public TdgssName(byte[] byArray, Oid oid, TDGSSa[] tDGSSaArray) {
        this.name = byArray;
        this.nameType = oid;
        this.nameImplementations = new Hashtable(tDGSSaArray.length);
        for (int i = 0; i < tDGSSaArray.length; ++i) {
            TDGSSa tDGSSa = tDGSSaArray[i];
            try {
                GSSName gSSName = tDGSSa.createName(byArray, oid);
                if (gSSName == null) continue;
                this.nameImplementations.put(tDGSSa, gSSName);
                continue;
            }
            catch (GSSException gSSException) {
                gSSException.printStackTrace();
            }
        }
    }

    public boolean equals(GSSName gSSName) throws GSSException {
        try {
            TdgssName tdgssName = (TdgssName)gSSName;
            return ((Object)gSSName).toString().equals(this.toString());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            TdgssName tdgssName = (TdgssName)object;
            return this.equals(tdgssName);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (GSSException gSSException) {
            return false;
        }
    }

    public GSSName canonicalize(Oid oid) throws GSSException {
        Vector vector = new Vector(this.nameImplementations.size());
        Enumeration enumeration = this.nameImplementations.keys();
        while (enumeration.hasMoreElements()) {
            TDGSSa tDGSSa = (TDGSSa)enumeration.nextElement();
            if (!tDGSSa.getMech().equals(oid)) continue;
            TDGSSa[] tDGSSaArray = new TDGSSa[]{tDGSSa};
            return new TdgssName(this.name, this.nameType, tDGSSaArray);
        }
        throw new GSSException(2);
    }

    public byte[] export() throws GSSException {
        throw new GSSException(16, 0, "inter-process tokens not supported");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.nameImplementations.elements();
        while (enumeration.hasMoreElements()) {
            GSSName gSSName = (GSSName)enumeration.nextElement();
            stringBuffer.append(((Object)gSSName).toString());
        }
        return stringBuffer.toString();
    }

    public Oid getStringNameType() throws GSSException {
        throw new GSSException(16);
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isMN() {
        return false;
    }

    protected GSSName getNameImplementation(TDGSSa tDGSSa) {
        return (GSSName)this.nameImplementations.get(tDGSSa);
    }

    static {
        try {
            GSS_C_NT_TDAT_MECHDATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.2");
            GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.1");
            GSS_C_NT_TDAT_MECHDATA_UTF8 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.3");
            GSS_C_NT_TDAT_MECHDATA_UTF16 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.4");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError("Oid string is incorrectly formatted");
        }
    }
}

