/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.dag.records.TezVertexID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezTaskID
extends TezID {
    public static final String TASK = "task";
    private final int serializingHash;
    static final ThreadLocal<NumberFormat> tezTaskIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };
    private static LoadingCache<TezTaskID, TezTaskID> taskIDCache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<TezTaskID, TezTaskID>(){

        public TezTaskID load(TezTaskID key) throws Exception {
            return key;
        }
    });
    private TezVertexID vertexId;

    public static TezTaskID getInstance(TezVertexID vertexID, int id) {
        Preconditions.checkArgument((vertexID != null ? 1 : 0) != 0, (Object)"vertexID cannot be null");
        return (TezTaskID)taskIDCache.getUnchecked((Object)new TezTaskID(vertexID, id));
    }

    @InterfaceAudience.Private
    public static void clearCache() {
        taskIDCache.invalidateAll();
        taskIDCache.cleanUp();
    }

    private TezTaskID(TezVertexID vertexID, int id) {
        super(id);
        Preconditions.checkArgument((vertexID != null ? 1 : 0) != 0, (Object)"vertexID cannot be null");
        this.vertexId = vertexID;
        this.serializingHash = this.getHashCode(true);
    }

    public int getSerializingHash() {
        return this.serializingHash;
    }

    public TezVertexID getVertexID() {
        return this.vertexId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezTaskID that = (TezTaskID)o;
        return this.vertexId.equals(that.vertexId);
    }

    @Override
    public int compareTo(TezID o) {
        TezTaskID that = (TezTaskID)o;
        int vertexComp = this.vertexId.compareTo(that.vertexId);
        if (vertexComp == 0) {
            return this.id - that.id;
        }
        return vertexComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(TASK)).toString();
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.vertexId.appendTo(builder).append('_').append(tezTaskIdFormat.get().format(this.id));
    }

    @Override
    public int hashCode() {
        return this.getHashCode(false);
    }

    public int getHashCode(boolean makePositive) {
        int code = this.vertexId.hashCode() * 535013 + this.id;
        if (makePositive) {
            code = code < 0 ? -code : code;
        }
        return code;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.vertexId = TezVertexID.readTezVertexID(in);
        super.readFields(in);
    }

    public static TezTaskID readTezTaskID(DataInput in) throws IOException {
        TezVertexID vertexID = TezVertexID.readTezVertexID(in);
        int taskIdInt = TezID.readID(in);
        return TezTaskID.getInstance(vertexID, taskIdInt);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.vertexId.write(out);
        super.write(out);
    }

    public static TezTaskID fromString(String taskIdStr) {
        try {
            String[] split = taskIdStr.split("_");
            if (split.length != 6 || !split[0].equals(TASK)) {
                return null;
            }
            String rmId = split[1];
            int appId = TezDAGID.tezAppIdFormat.get().parse(split[2]).intValue();
            int dagId = TezDAGID.tezDagIdFormat.get().parse(split[3]).intValue();
            int vId = TezVertexID.tezVertexIdFormat.get().parse(split[4]).intValue();
            int id = tezTaskIdFormat.get().parse(split[5]).intValue();
            return TezTaskID.getInstance(TezVertexID.getInstance(TezDAGID.getInstance(rmId, appId, dagId), vId), id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

