/*
 * Decompiled with CFR 0.152.
 */
package io.shadow.netty.handler.codec.http;

import io.shadow.netty.buffer.ByteBuf;
import io.shadow.netty.buffer.ByteBufUtil;
import io.shadow.netty.handler.codec.http.HttpObjectEncoder;
import io.shadow.netty.handler.codec.http.HttpRequest;
import io.shadow.netty.handler.codec.http.HttpResponse;
import io.shadow.netty.util.CharsetUtil;

public class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && !(msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpRequest request) throws Exception {
        ByteBufUtil.copy(request.method().asciiName(), buf);
        buf.writeByte(32);
        String uri = request.uri();
        if (uri.isEmpty()) {
            uri = uri + '/';
        } else {
            int start = uri.indexOf("://");
            if (start != -1 && uri.charAt(0) != '/') {
                int startIndex = start + 3;
                int index = uri.indexOf(63, startIndex);
                if (index == -1) {
                    if (uri.lastIndexOf(47) <= startIndex) {
                        uri = uri + '/';
                    }
                } else if (uri.lastIndexOf(47, index) <= startIndex) {
                    uri = new StringBuilder(uri).insert(index, '/').toString();
                }
            }
        }
        buf.writeCharSequence(uri, CharsetUtil.UTF_8);
        buf.writeByte(32);
        request.protocolVersion().encode(buf);
        buf.writeBytes(CRLF);
    }
}

