/*
 * Decompiled with CFR 0.152.
 */
package io.shadow.netty.handler.ipfilter;

import io.shadow.netty.channel.ChannelHandler;
import io.shadow.netty.channel.ChannelHandlerContext;
import io.shadow.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import io.shadow.netty.handler.ipfilter.IpFilterRule;
import io.shadow.netty.handler.ipfilter.IpFilterRuleType;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        if (rules == null) {
            throw new NullPointerException("rules");
        }
        this.rules = rules;
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

