/*
 * Decompiled with CFR 0.152.
 */
package io.shadow.netty.handler.ssl;

import io.shadow.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.shadow.netty.handler.ssl.JdkSslEngine;
import io.shadow.netty.handler.ssl.SslUtils;
import io.shadow.netty.util.internal.ObjectUtil;
import io.shadow.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.conscrypt.Conscrypt;
import org.conscrypt.HandshakeListener;

abstract class ConscryptAlpnSslEngine
extends JdkSslEngine {
    private static final Class<?> ENGINES_CLASS = ConscryptAlpnSslEngine.getEnginesClass();

    static boolean isAvailable() {
        return ENGINES_CLASS != null && PlatformDependent.javaVersion() >= 8;
    }

    static boolean isEngineSupported(SSLEngine engine) {
        return ConscryptAlpnSslEngine.isAvailable() && ConscryptAlpnSslEngine.isConscryptEngine(engine, ENGINES_CLASS);
    }

    static ConscryptAlpnSslEngine newClientEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator) {
        return new ClientEngine(engine, applicationNegotiator);
    }

    static ConscryptAlpnSslEngine newServerEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator) {
        return new ServerEngine(engine, applicationNegotiator);
    }

    private ConscryptAlpnSslEngine(SSLEngine engine, List<String> protocols) {
        super(engine);
        Conscrypt.Engines.setAlpnProtocols((SSLEngine)engine, (String[])protocols.toArray(new String[protocols.size()]));
    }

    final int calculateOutNetBufSize(int plaintextBytes, int numBuffers) {
        long maxOverhead = (long)Conscrypt.Engines.maxSealOverhead((SSLEngine)this.getWrappedEngine()) * (long)numBuffers;
        return (int)Math.min(Integer.MAX_VALUE, (long)plaintextBytes + maxOverhead);
    }

    final SSLEngineResult unwrap(ByteBuffer[] srcs, ByteBuffer[] dests) throws SSLException {
        return Conscrypt.Engines.unwrap((SSLEngine)this.getWrappedEngine(), (ByteBuffer[])srcs, (ByteBuffer[])dests);
    }

    private static Class<?> getEnginesClass() {
        try {
            Class<?> engineClass = Class.forName("org.conscrypt.Conscrypt$Engines", true, ConscryptAlpnSslEngine.class.getClassLoader());
            ConscryptAlpnSslEngine.getIsConscryptMethod(engineClass);
            return engineClass;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    private static boolean isConscryptEngine(SSLEngine engine, Class<?> enginesClass) {
        try {
            Method method = ConscryptAlpnSslEngine.getIsConscryptMethod(enginesClass);
            return (Boolean)method.invoke(null, engine);
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static Method getIsConscryptMethod(Class<?> enginesClass) throws NoSuchMethodException {
        return enginesClass.getMethod("isConscrypt", SSLEngine.class);
    }

    private static final class ServerEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector;

        ServerEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator) {
            super(engine, applicationNegotiator.protocols());
            Conscrypt.Engines.setHandshakeListener((SSLEngine)engine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() throws SSLException {
                    ServerEngine.this.selectProtocol();
                }
            });
            this.protocolSelector = ObjectUtil.checkNotNull(applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(applicationNegotiator.protocols())), "protocolSelector");
        }

        private void selectProtocol() throws SSLException {
            try {
                String protocol = Conscrypt.Engines.getAlpnSelectedProtocol((SSLEngine)this.getWrappedEngine());
                this.protocolSelector.select(protocol != null ? Collections.singletonList(protocol) : Collections.emptyList());
            }
            catch (Throwable e) {
                throw SslUtils.toSSLHandshakeException(e);
            }
        }
    }

    private static final class ClientEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener;

        ClientEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator) {
            super(engine, applicationNegotiator.protocols());
            Conscrypt.Engines.setHandshakeListener((SSLEngine)engine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() throws SSLException {
                    ClientEngine.this.selectProtocol();
                }
            });
            this.protocolListener = ObjectUtil.checkNotNull(applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols()), "protocolListener");
        }

        private void selectProtocol() throws SSLException {
            String protocol = Conscrypt.Engines.getAlpnSelectedProtocol((SSLEngine)this.getWrappedEngine());
            try {
                this.protocolListener.selected(protocol);
            }
            catch (Throwable e) {
                throw SslUtils.toSSLHandshakeException(e);
            }
        }
    }
}

