/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.cors;

import io.shadow.netty.channel.ChannelDuplexHandler;
import io.shadow.netty.channel.ChannelFutureListener;
import io.shadow.netty.channel.ChannelHandlerContext;
import io.shadow.netty.handler.codec.http.DefaultFullHttpResponse;
import io.shadow.netty.handler.codec.http.HttpHeaderNames;
import io.shadow.netty.handler.codec.http.HttpHeaders;
import io.shadow.netty.handler.codec.http.HttpMethod;
import io.shadow.netty.handler.codec.http.HttpRequest;
import io.shadow.netty.handler.codec.http.HttpResponse;
import io.shadow.netty.handler.codec.http.HttpResponseStatus;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;

public class Netty4CorsHandler
extends ChannelDuplexHandler {
    public static final String ANY_ORIGIN = "*";
    private static Pattern SCHEME_PATTERN = Pattern.compile("^https?://");
    private final Netty4CorsConfig config;
    private HttpRequest request;

    public Netty4CorsHandler(Netty4CorsConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.config.isCorsSupportEnabled() && msg instanceof HttpRequest) {
            this.request = (HttpRequest)msg;
            if (Netty4CorsHandler.isPreflightRequest(this.request)) {
                this.handlePreflight(ctx, this.request);
                return;
            }
            if (this.config.isShortCircuit() && !this.validateOrigin()) {
                Netty4CorsHandler.forbidden(ctx, this.request);
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    public static void setCorsResponseHeaders(HttpRequest request, HttpResponse resp, Netty4CorsConfig config) {
        String originHeaderVal;
        if (!config.isCorsSupportEnabled()) {
            return;
        }
        String originHeader = request.headers().get(HttpHeaderNames.ORIGIN);
        if (!Strings.isNullOrEmpty((String)originHeader) && (originHeaderVal = config.isAnyOriginSupported() ? ANY_ORIGIN : (config.isOriginAllowed(originHeader) || Netty4CorsHandler.isSameOrigin(originHeader, request.headers().get(HttpHeaderNames.HOST)) ? originHeader : null)) != null) {
            resp.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)originHeaderVal);
        }
        if (config.isCredentialsAllowed()) {
            resp.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
    }

    private void handlePreflight(ChannelHandlerContext ctx, HttpRequest request) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK, true, true);
        if (this.setOrigin(response)) {
            this.setAllowMethods(response);
            this.setAllowHeaders(response);
            this.setAllowCredentials(response);
            this.setMaxAge(response);
            this.setPreflightHeaders(response);
            ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
        } else {
            Netty4CorsHandler.forbidden(ctx, request);
        }
    }

    private static void forbidden(ChannelHandlerContext ctx, HttpRequest request) {
        ctx.writeAndFlush(new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.FORBIDDEN)).addListener(ChannelFutureListener.CLOSE);
    }

    private static boolean isSameOrigin(String origin, String host) {
        String originDomain;
        return !Strings.isNullOrEmpty((String)host) && host.equals(originDomain = SCHEME_PATTERN.matcher(origin).replaceFirst(""));
    }

    private void setPreflightHeaders(HttpResponse response) {
        response.headers().add(this.config.preflightResponseHeaders());
    }

    private boolean setOrigin(HttpResponse response) {
        String origin = this.request.headers().get(HttpHeaderNames.ORIGIN);
        if (!Strings.isNullOrEmpty((String)origin)) {
            if ("null".equals(origin) && this.config.isNullOriginAllowed()) {
                Netty4CorsHandler.setAnyOrigin(response);
                return true;
            }
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(response);
                    Netty4CorsHandler.setVaryHeader(response);
                } else {
                    Netty4CorsHandler.setAnyOrigin(response);
                }
                return true;
            }
            if (this.config.isOriginAllowed(origin)) {
                Netty4CorsHandler.setOrigin(response, origin);
                Netty4CorsHandler.setVaryHeader(response);
                return true;
            }
        }
        return false;
    }

    private boolean validateOrigin() {
        if (this.config.isAnyOriginSupported()) {
            return true;
        }
        String origin = this.request.headers().get(HttpHeaderNames.ORIGIN);
        if (Strings.isNullOrEmpty((String)origin)) {
            return true;
        }
        if ("null".equals(origin) && this.config.isNullOriginAllowed()) {
            return true;
        }
        if (Netty4CorsHandler.isSameOrigin(origin, this.request.headers().get(HttpHeaderNames.HOST))) {
            return true;
        }
        return this.config.isOriginAllowed(origin);
    }

    private void echoRequestOrigin(HttpResponse response) {
        Netty4CorsHandler.setOrigin(response, this.request.headers().get(HttpHeaderNames.ORIGIN));
    }

    private static void setVaryHeader(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.VARY, (Object)HttpHeaderNames.ORIGIN);
    }

    private static void setAnyOrigin(HttpResponse response) {
        Netty4CorsHandler.setOrigin(response, ANY_ORIGIN);
    }

    private static void setOrigin(HttpResponse response, String origin) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
    }

    private void setAllowCredentials(HttpResponse response) {
        if (this.config.isCredentialsAllowed() && !response.headers().get(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN).equals(ANY_ORIGIN)) {
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
    }

    private static boolean isPreflightRequest(HttpRequest request) {
        HttpHeaders headers = request.headers();
        return request.method().equals(HttpMethod.OPTIONS) && headers.contains(HttpHeaderNames.ORIGIN) && headers.contains(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    }

    private void setAllowMethods(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Iterable)this.config.allowedRequestMethods().stream().map(m -> m.name().trim()).collect(Collectors.toList()));
    }

    private void setAllowHeaders(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, this.config.allowedRequestHeaders());
    }

    private void setMaxAge(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, (Object)this.config.maxAge());
    }
}

