/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.pipelining;

import io.shadow.netty.channel.ChannelDuplexHandler;
import io.shadow.netty.channel.ChannelHandlerContext;
import io.shadow.netty.channel.ChannelPromise;
import io.shadow.netty.handler.codec.http.LastHttpContent;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.PriorityQueue;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedRequest;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedResponse;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class HttpPipeliningHandler
extends ChannelDuplexHandler {
    private final PriorityQueue<HttpPipelinedResponse> holdingQueue;
    private final Logger logger;
    private final int maxEventsHeld;
    private int readSequence;
    private int writeSequence;

    public HttpPipeliningHandler(Logger logger, int maxEventsHeld) {
        this.logger = logger;
        this.maxEventsHeld = maxEventsHeld;
        this.holdingQueue = new PriorityQueue(1);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof LastHttpContent) {
            ctx.fireChannelRead(new HttpPipelinedRequest(((LastHttpContent)msg).retain(), this.readSequence++));
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpPipelinedResponse) {
            HttpPipelinedResponse current = (HttpPipelinedResponse)msg;
            assert (current.promise() == promise);
            boolean channelShouldClose = false;
            PriorityQueue<HttpPipelinedResponse> priorityQueue = this.holdingQueue;
            synchronized (priorityQueue) {
                if (this.holdingQueue.size() < this.maxEventsHeld) {
                    HttpPipelinedResponse top;
                    this.holdingQueue.add(current);
                    while (!this.holdingQueue.isEmpty() && (top = this.holdingQueue.peek()).sequence() == this.writeSequence) {
                        this.holdingQueue.remove();
                        ctx.write(top.response(), top.promise());
                        ++this.writeSequence;
                    }
                } else {
                    channelShouldClose = true;
                }
            }
            if (channelShouldClose) {
                try {
                    Netty4Utils.closeChannels(Collections.singletonList(ctx.channel()));
                }
                finally {
                    current.release();
                    promise.setSuccess();
                }
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (!this.holdingQueue.isEmpty()) {
            HttpPipelinedResponse pipelinedResponse;
            ClosedChannelException closedChannelException = new ClosedChannelException();
            while ((pipelinedResponse = this.holdingQueue.poll()) != null) {
                try {
                    pipelinedResponse.release();
                    pipelinedResponse.promise().setFailure(closedChannelException);
                }
                catch (Exception e) {
                    this.logger.error("unexpected error while releasing pipelined http responses", (Throwable)e);
                }
            }
        }
        ctx.close(promise);
    }
}

