/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.shadow.netty.channel.Channel;
import io.shadow.netty.channel.ChannelFuture;
import io.shadow.netty.channel.ChannelFutureListener;
import io.shadow.netty.channel.ChannelHandler;
import io.shadow.netty.channel.ChannelHandlerContext;
import io.shadow.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.transport.netty4.Netty4Utils;

@ChannelHandler.Sharable
public class Netty4OpenChannelsHandler
extends ChannelInboundHandlerAdapter
implements Releasable {
    final Set<Channel> openChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    final CounterMetric openChannelsMetric = new CounterMetric();
    final CounterMetric totalChannelsMetric = new CounterMetric();
    final Logger logger;
    final ChannelFutureListener remover = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean removed = Netty4OpenChannelsHandler.this.openChannels.remove(future.channel());
            if (removed) {
                Netty4OpenChannelsHandler.this.openChannelsMetric.dec();
            }
            if (Netty4OpenChannelsHandler.this.logger.isTraceEnabled()) {
                Netty4OpenChannelsHandler.this.logger.trace("channel closed: {}", (Object)future.channel());
            }
        }
    };

    public Netty4OpenChannelsHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        boolean added;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("channel opened: {}", (Object)ctx.channel());
        }
        if (added = this.openChannels.add(ctx.channel())) {
            this.openChannelsMetric.inc();
            this.totalChannelsMetric.inc();
            ctx.channel().closeFuture().addListener(this.remover);
        }
        super.channelActive(ctx);
    }

    public long numberOfOpenChannels() {
        return this.openChannelsMetric.count();
    }

    public long totalChannels() {
        return this.totalChannelsMetric.count();
    }

    public void close() {
        try {
            Netty4Utils.closeChannels(this.openChannels);
        }
        catch (IOException e) {
            this.logger.trace("exception while closing channels", (Throwable)e);
        }
        this.openChannels.clear();
    }
}

