/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.core.VStatement;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.interfaces.IRowCountResult;
import com.vertica.dsi.dataengine.utilities.CursorType;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.io.CloseRequestMessage;
import com.vertica.io.DataRowResponseMessage;
import com.vertica.io.ErrorResponseMessage;
import com.vertica.io.FlushRequestMessage;
import com.vertica.io.MessageType;
import com.vertica.io.ProtocolStream;
import com.vertica.io.ReadyForQueryResponseMessage;
import com.vertica.io.ResponseMessage;
import com.vertica.io.RowData;
import com.vertica.io.RowDescriptionResponseMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.parser.StatementType;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.util.ServerErrorData;
import com.vertica.util.TransactionStateException;
import com.vertica.util.TypeUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VResultSet
implements IResultSet,
IRowCountResult {
    public static final MessageType[] END_OF_RESULT_RESPONSES;
    private final Object m_lock;
    private final DSILogger m_log;
    private final VConnection m_connection;
    private final VStatement m_statement;
    private final ProtocolStream m_protocolStream;
    private final Queue<VResultSet> m_futureResults;
    private ArrayList<ColumnDescription> m_rowDescription;
    private int[] m_sqlTypeCache;
    private int[] m_oidTypeCache;
    private int[] m_typemodCache;
    private LinkedList<Integer> m_binaryColumns;
    private ArrayList<RowData> m_rows;
    private RowData m_lastRowInChunk;
    private int m_lastRowIdx;
    private int m_currentRowIdx;
    private boolean m_isClosed;
    private boolean m_isInitialized;
    private boolean m_hasMoreRows;
    private boolean m_finishedReadingRows;
    private final boolean m_isPrepared;
    private final boolean m_isRowCount;
    private final String m_commandTag;
    private long m_totalRowsRead;
    private long m_totalRowsIterated;
    private boolean m_enforceMaxRows;
    private int m_jdbcFetchSize;
    private int m_fetchSize;
    private long m_resultBufferSize;
    private boolean m_tryFinishCalled;
    private boolean m_isPseudoRowCount;
    private String m_portalName;
    private IWarningListener m_warningListener;
    public static final ArrayList<ColumnDescription> PSEUDO_ROWCOUNT_DESCRIPTION;

    public VResultSet(VQueryExecutor vQueryExecutor, Queue<VResultSet> queue, String string, ArrayList<ColumnDescription> arrayList) {
        this.m_statement = vQueryExecutor.getParentStatement();
        this.m_resultBufferSize = this.m_statement.getResultBufferSize();
        this.m_connection = this.m_statement.getConnection();
        this.m_protocolStream = this.m_connection.getProtocolStream();
        this.m_lock = new Object();
        this.m_hasMoreRows = true;
        this.m_enforceMaxRows = true;
        this.m_rows = new ArrayList();
        this.m_log = this.m_connection.getConnectionLog();
        this.m_futureResults = queue;
        this.m_isPrepared = arrayList != null;
        this.m_portalName = "";
        this.m_commandTag = string;
        this.m_isRowCount = !StatementType.returnsResultSet(string);
        this.m_fetchSize = vQueryExecutor.generatesOnlyResultSets() ? 1 : 0;
        this.m_resultBufferSize = this.m_isRowCount ? Long.MAX_VALUE : this.m_statement.getResultBufferSize();
        LogUtilities.logFunctionEntrance(this.m_log, vQueryExecutor, queue, string, arrayList, this);
        if (this.m_isPrepared) {
            this.setRowDescription(arrayList);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    void setPortalName(String string) {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        this.m_portalName = string;
    }

    private void setRowDescription(ArrayList<ColumnDescription> arrayList) {
        this.m_rowDescription = arrayList;
        int n = this.m_rowDescription.size();
        this.m_sqlTypeCache = new int[n];
        this.m_oidTypeCache = new int[n];
        this.m_typemodCache = new int[n];
        this.m_binaryColumns = new LinkedList();
        for (int i = 0; i < n; ++i) {
            ColumnDescription columnDescription = this.m_rowDescription.get(i);
            this.m_sqlTypeCache[i] = columnDescription.getSQLType();
            this.m_oidTypeCache[i] = columnDescription.getTypeOID();
            this.m_typemodCache[i] = columnDescription.getTypeMod();
            if (this.m_sqlTypeCache[i] != -2 && this.m_sqlTypeCache[i] != -3 && this.m_sqlTypeCache[i] != -4) continue;
            this.m_binaryColumns.add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryFinishReadingResult() throws ErrorException {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.m_finishedReadingRows && !this.m_tryFinishCalled) {
                try {
                    try {
                        this.m_fetchSize = 0;
                        for (VResultSet vResultSet : this.m_futureResults) {
                            vResultSet.setInternalFetchSize(0);
                        }
                        this.fetchChunk(false);
                    }
                    catch (ErrorException errorException) {
                        this.m_connection.handleError(false, errorException);
                        throw errorException;
                    }
                    Object var5_5 = null;
                    this.m_tryFinishCalled = true;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.m_tryFinishCalled = true;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_connection.lock();
        try {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_isClosed) {
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 15] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    Object var9_2 = null;
                    this.m_connection.unlock();
                    return;
                }
                ErrorException errorException = null;
                try {
                    try {
                        if (!this.m_finishedReadingRows) {
                            this.m_connection.endCurrentCopy();
                            while (this.m_isInitialized && this.moveToNextRow()) {
                            }
                        }
                        Object var5_6 = null;
                        this.m_hasMoreRows = false;
                        this.m_isClosed = true;
                    }
                    catch (ErrorException errorException2) {
                        this.m_connection.handleError(false, errorException2);
                        errorException = errorException2;
                        Object var5_7 = null;
                        this.m_hasMoreRows = false;
                        this.m_isClosed = true;
                        try {
                            if (!this.m_connection.isClosed() && this.m_futureResults.isEmpty() && !"".equals(this.m_portalName)) {
                                this.m_protocolStream.sendMessage(new CloseRequestMessage(this.m_portalName, true));
                                this.m_protocolStream.sendMessage(new FlushRequestMessage());
                                this.m_protocolStream.readExpectedMessage(MessageType.CloseComplete);
                            }
                        }
                        catch (ErrorException errorException3) {
                            this.m_connection.handleError(false, errorException3);
                            if (errorException == null) throw errorException3;
                            errorException3.initCause(errorException);
                            throw errorException3;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.m_hasMoreRows = false;
                    this.m_isClosed = true;
                    try {}
                    catch (ErrorException errorException4) {
                        this.m_connection.handleError(false, errorException4);
                        if (errorException == null) throw errorException4;
                        errorException4.initCause(errorException);
                        throw errorException4;
                    }
                    if (this.m_connection.isClosed()) throw throwable;
                    if (!this.m_futureResults.isEmpty()) throw throwable;
                    if ("".equals(this.m_portalName)) throw throwable;
                    this.m_protocolStream.sendMessage(new CloseRequestMessage(this.m_portalName, true));
                    this.m_protocolStream.sendMessage(new FlushRequestMessage());
                    this.m_protocolStream.readExpectedMessage(MessageType.CloseComplete);
                    throw throwable;
                }
                try {}
                catch (ErrorException errorException5) {
                    this.m_connection.handleError(false, errorException5);
                    if (errorException == null) throw errorException5;
                    errorException5.initCause(errorException);
                    throw errorException5;
                }
                if (!this.m_connection.isClosed() && this.m_futureResults.isEmpty() && !"".equals(this.m_portalName)) {
                    this.m_protocolStream.sendMessage(new CloseRequestMessage(this.m_portalName, true));
                    this.m_protocolStream.sendMessage(new FlushRequestMessage());
                    this.m_protocolStream.readExpectedMessage(MessageType.CloseComplete);
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            this.m_connection.unlock();
            throw throwable;
        }
        Object var9_3 = null;
        this.m_connection.unlock();
    }

    private void setupNextResult() throws ErrorException {
        VResultSet vResultSet = this.m_futureResults.peek();
        assert (this == vResultSet);
        assert (this.m_finishedReadingRows);
        this.m_futureResults.remove();
        VResultSet vResultSet2 = this.m_futureResults.peek();
        if (vResultSet2 != null) {
            LogUtilities.logInfo("Initializing next result: " + vResultSet2, (ILogger)this.m_log);
            vResultSet2.initialize();
        } else {
            this.m_connection.setInLRS(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchChunk(boolean bl) throws ErrorException {
        boolean bl2 = false;
        boolean bl3 = this.m_fetchSize <= 0;
        int n = 0;
        long l = 0L;
        assert (!this.m_finishedReadingRows);
        if (bl) {
            this.m_rows.clear();
            this.m_currentRowIdx = -1;
        }
        this.m_connection.lock();
        boolean bl4 = this.m_warningListener != null;
        try {
            try {
                ResponseMessage responseMessage;
                if (bl4) {
                    this.m_protocolStream.setWarningListener(this.m_warningListener);
                }
                if (!this.isRowCount() && bl3) {
                    LogUtilities.logInfo("LRS mode will be enabled after " + (bl3 ? this.m_resultBufferSize + " bytes " : this.m_fetchSize + " rows ") + "have been read", (ILogger)this.m_log);
                }
                while (!bl2) {
                    responseMessage = this.m_protocolStream.readMessage();
                    switch (responseMessage.getType()) {
                        case Error: {
                            this.m_lastRowIdx = this.m_rows.size() - 1;
                            this.m_hasMoreRows = this.m_rows.size() > 0;
                            ServerErrorData serverErrorData = ((ErrorResponseMessage)responseMessage).getErrorData();
                            throw serverErrorData.buildException();
                        }
                        case DataRow: {
                            DataRowResponseMessage dataRowResponseMessage = (DataRowResponseMessage)responseMessage;
                            RowData rowData = dataRowResponseMessage.getRow();
                            l += (long)dataRowResponseMessage.getRowLength();
                            ++n;
                            for (Integer n2 : this.m_binaryColumns) {
                                rowData.setColumnAt(n2, TypeUtils.stringBytesToBinary(rowData.getColumnAt(n2)));
                            }
                            this.m_rows.add(rowData);
                            break;
                        }
                        default: {
                            this.m_protocolStream.putBack(responseMessage);
                            this.m_finishedReadingRows = true;
                            this.m_hasMoreRows = this.m_rows.size() > 0;
                        }
                    }
                    bl2 = this.m_finishedReadingRows || bl3 && l >= this.m_resultBufferSize || !bl3 && n == this.m_fetchSize;
                }
                if (!this.m_finishedReadingRows) {
                    responseMessage = this.m_protocolStream.readMessage();
                    this.m_finishedReadingRows = responseMessage.getType() != MessageType.DataRow;
                    this.m_protocolStream.putBack(responseMessage);
                }
                this.m_totalRowsRead += (long)n;
                this.m_lastRowIdx = this.m_rows.size() - 1;
                char c = this.m_connection.getServerTxnState();
                if (this.m_finishedReadingRows) {
                    if (this.isRowCount()) {
                        LogUtilities.logInfo("Successfully read row count " + this.getRowCount(), (ILogger)this.m_log);
                    } else {
                        LogUtilities.logInfo("Successfully read " + n + " rows (" + l + " bytes total)", (ILogger)this.m_log);
                    }
                    this.m_protocolStream.readExpectedMessage(END_OF_RESULT_RESPONSES);
                    ResponseMessage responseMessage2 = this.m_protocolStream.readMessage();
                    if (!responseMessage2.getType().equals((Object)MessageType.ReadyForQuery)) {
                        this.m_protocolStream.putBack(responseMessage2);
                        this.m_connection.setInLRS(true);
                        this.setupNextResult();
                    } else {
                        this.setupNextResult();
                        this.m_connection.setCurrentResult(null);
                        assert (!this.m_connection.inLRS());
                        c = ((ReadyForQueryResponseMessage)responseMessage2).getTxnState();
                        this.checkForTransactionStateChanges(c);
                        this.m_connection.executeLRSWorkQueue();
                    }
                } else {
                    this.m_connection.setInLRS(true);
                }
                Object var15_15 = null;
                if (bl4) {
                    this.m_protocolStream.clearWarningListener();
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (bl4) {
                    this.m_protocolStream.clearWarningListener();
                }
                throw throwable;
            }
            Object var17_18 = null;
            this.m_connection.unlock();
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            this.m_connection.unlock();
            throw throwable;
        }
    }

    private void checkForTransactionStateChanges(char c) throws TransactionStateException {
        boolean bl = false;
        try {
            block13: {
                try {
                    if (this.m_connection.inTransactionAPICall()) {
                        bl = true;
                        break block13;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(this.m_commandTag, " ");
                    String string = stringTokenizer.nextToken();
                    if ("COMMIT".equals(string)) {
                        LogUtilities.logWarning("COMMIT command detected outside of the JDBC Transaction API. Please use Connection.commit() so that the driver may properly track transaction state.", (ILogger)this.m_log);
                        bl = true;
                        this.m_connection.getTransactionStateListener().notifyCommit();
                        break block13;
                    }
                    if ("ROLLBACK".equals(string)) {
                        LogUtilities.logWarning("ROLLBACK command detected outside of the JDBC Transaction API. Please use Connection.rollback() so that the driver may properly track transaction state.", (ILogger)this.m_log);
                        bl = true;
                        if (stringTokenizer.hasMoreTokens()) {
                            this.m_connection.getTransactionStateListener().notifyRollbackSavepoint(stringTokenizer.nextToken());
                        } else {
                            this.m_connection.getTransactionStateListener().notifyRollback();
                        }
                        break block13;
                    }
                    if ("SAVEPOINT".equals(string)) {
                        LogUtilities.logWarning("SAVEPOINT command detected outside of the JDBC Transaction API. Please use Connection.setSavepoint() so that the driver may properly track transaction state.", (ILogger)this.m_log);
                        bl = true;
                        assert (stringTokenizer.hasMoreTokens());
                        this.m_connection.getTransactionStateListener().notifyCreateSavepoint(stringTokenizer.nextToken());
                        break block13;
                    }
                    if (!"RELEASE".equals(string)) break block13;
                    LogUtilities.logWarning("RELEASE command detected outside of the JDBC Transaction API. Please use Connection.releaseSavepoint() so that the driver may properly track transaction state.", (ILogger)this.m_log);
                    bl = true;
                    assert (stringTokenizer.hasMoreTokens());
                    this.m_connection.getTransactionStateListener().notifyReleaseSavepoint(stringTokenizer.nextToken());
                }
                catch (ErrorException errorException) {
                    assert (bl);
                    throw new TransactionStateException(errorException);
                }
            }
            Object var6_6 = null;
            this.m_connection.setServerTxnState(c, !bl, false);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.m_connection.setServerTxnState(c, !bl, false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws ErrorException {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_isInitialized) {
                return;
            }
            LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
            this.m_connection.lock();
            boolean bl = this.m_warningListener != null;
            try {
                try {
                    block28: {
                        ResponseMessage responseMessage;
                        block27: {
                            if (bl) {
                                this.m_protocolStream.setWarningListener(this.m_warningListener);
                            }
                            VResultSet vResultSet = this.m_futureResults.peek();
                            assert (this == vResultSet);
                            this.m_connection.setCurrentResult(this);
                            responseMessage = this.m_protocolStream.readMessage();
                            if (!this.m_isPrepared) break block27;
                            assert (this.m_rowDescription != null);
                            if (!responseMessage.getType().equals((Object)MessageType.BindComplete)) {
                                this.m_protocolStream.putBack(responseMessage);
                            }
                            responseMessage = this.m_protocolStream.readMessage();
                            switch (responseMessage.getType()) {
                                case RowDescription: {
                                    break block28;
                                }
                                case Error: 
                                case DataRow: {
                                    this.m_protocolStream.putBack(responseMessage);
                                    break block28;
                                }
                                case PortalSuspended: 
                                case CommandComplete: {
                                    this.m_isPseudoRowCount = this.m_rowDescription == PSEUDO_ROWCOUNT_DESCRIPTION;
                                    this.m_protocolStream.putBack(responseMessage);
                                    break block28;
                                }
                                default: {
                                    assert (false) : responseMessage.getType();
                                    break block28;
                                }
                            }
                        }
                        assert (this.m_rowDescription == null);
                        switch (responseMessage.getType()) {
                            case Error: {
                                this.m_protocolStream.putBack(responseMessage);
                                break;
                            }
                            case RowDescription: {
                                RowDescriptionResponseMessage rowDescriptionResponseMessage = (RowDescriptionResponseMessage)responseMessage;
                                this.setRowDescription(rowDescriptionResponseMessage.getRowDescription());
                                break;
                            }
                            case CommandComplete: {
                                this.m_isPseudoRowCount = true;
                                this.setRowDescription(PSEUDO_ROWCOUNT_DESCRIPTION);
                                this.m_protocolStream.putBack(responseMessage);
                                break;
                            }
                            default: {
                                assert (false) : responseMessage.getType();
                                break;
                            }
                        }
                    }
                    this.m_isInitialized = true;
                    this.fetchChunk(true);
                    Object var7_6 = null;
                    if (bl) {
                        this.m_protocolStream.clearWarningListener();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (bl) {
                        this.m_protocolStream.clearWarningListener();
                    }
                    throw throwable;
                }
                Object var9_9 = null;
                this.m_connection.unlock();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.m_connection.unlock();
                throw throwable;
            }
        }
    }

    boolean isRowCount() {
        return this.m_isRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        RowData rowData = null;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_currentRowIdx >= this.m_rows.size()) {
                throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_END_OF_RESULT.toString());
            }
            rowData = this.m_currentRowIdx == -1 ? this.m_lastRowInChunk : this.m_rows.get(this.m_currentRowIdx);
        }
        return TypeUtils.deserialize(this.m_sqlTypeCache[n], this.m_oidTypeCache[n], this.m_typemodCache[n], l, l2, dataWrapper, rowData.getColumnAt(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws GeneralException {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_jdbcFetchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n) throws GeneralException {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_jdbcFetchSize = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInternalFetchSize(int n) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_fetchSize = n;
        }
    }

    public ArrayList<ColumnDescription> getSelectColumns() {
        return this.m_rowDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreRows() throws GeneralException {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_hasMoreRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_isRowCount || this.m_finishedReadingRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_isPseudoRowCount) {
                assert (this.m_rowDescription == PSEUDO_ROWCOUNT_DESCRIPTION);
                return 0L;
            }
            if (this.m_isRowCount) {
                this.m_currentRowIdx = 0;
                DataWrapper dataWrapper = new DataWrapper();
                this.getData(0, 0L, 0L, dataWrapper);
                try {
                    return Long.valueOf(dataWrapper.getVarChar());
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    LogUtilities.logError("Error reading row count. Defaulting to -1", (ILogger)this.m_log);
                    return -1L;
                }
            }
            assert (this.m_rowDescription != null);
            return this.m_totalRowsRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean moveToNextRow() throws ErrorException {
        this.m_connection.lock();
        var1_1 = this.m_lock;
        synchronized (var1_1) {
            if (this.m_hasMoreRows) ** break block17
            var2_2 = false;
        }
        var9_4 = null;
        this.m_connection.unlock();
        return var2_2;
        {
            block18: {
                if (this.m_currentRowIdx == -1) {
                    this.m_lastRowInChunk = null;
                }
                var2_3 = this.m_hasMoreRows;
                if (++this.m_currentRowIdx == this.m_lastRowIdx) {
                    if (!this.m_finishedReadingRows) {
                        var3_7 = 0;
                        try {
                            try {
                                this.m_lastRowInChunk = this.m_rows.get(this.m_lastRowIdx);
                                this.fetchChunk(true);
                            }
                            catch (ErrorException var4_10) {
                                var3_7 = 1;
                                this.m_hasMoreRows = false;
                                this.m_connection.handleError(false, var4_10);
                                throw var4_10;
                            }
                            var6_8 = null;
                            if (var3_7 != 0 && this.m_connection.isClosed()) {
                                this.close();
                            }
                            break block18;
                        }
                        catch (Throwable var5_13) {
                            var6_9 = null;
                            if (var3_7 == 0 || !this.m_connection.isClosed()) throw var5_13;
                            this.close();
                            throw var5_13;
                        }
                    }
                    this.m_hasMoreRows = false;
                }
            }
            ++this.m_totalRowsIterated;
            var3_7 = this.m_statement.getMaxRows();
            if (this.m_enforceMaxRows && var3_7 > 0 && this.m_totalRowsIterated >= (long)var3_7) {
                LogUtilities.logInfo("This result's maxRows limit (" + var3_7 + ") has been reached", (ILogger)this.m_log);
                var4_11 = this.m_currentRowIdx == -1 ? this.m_lastRowInChunk : this.m_rows.get(this.m_currentRowIdx);
                this.m_enforceMaxRows = false;
                this.closeCursor();
                this.m_rows.clear();
                this.m_currentRowIdx = -1;
                this.m_lastRowInChunk = var4_11;
            }
            var4_12 = var2_3;
            // MONITOREXIT @DISABLED, blocks:[2, 3, 7] lbl54 : MonitorExitStatement: MONITOREXIT : var1_1
            var9_5 = null;
            this.m_connection.unlock();
            return var4_12;
            {
                catch (Throwable var7_14) {
                    try {
                        throw var7_14;
                    }
                    catch (Throwable var8_15) {
                        var9_6 = null;
                        this.m_connection.unlock();
                    }
                }
            }
            throw var8_15;
        }
    }

    @Override
    public void setCursorType(CursorType cursorType) throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[]{cursorType});
    }

    public ArrayList<RowData> getRows() {
        return this.m_rows;
    }

    @Override
    public void appendRow() throws ErrorException {
        throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_FEATURE_NOT_SUPPORTED.toString());
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_FEATURE_NOT_SUPPORTED.toString());
    }

    @Override
    public void onFinishRowUpdate() {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_FEATURE_NOT_SUPPORTED.toString());
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    public long getResultBufferSize() {
        return this.m_resultBufferSize;
    }

    public VStatement getParentStatement() {
        return this.m_statement;
    }

    static {
        block2: {
            END_OF_RESULT_RESPONSES = new MessageType[]{MessageType.PortalSuspended, MessageType.CommandComplete};
            PSEUDO_ROWCOUNT_DESCRIPTION = new ArrayList(1);
            try {
                PSEUDO_ROWCOUNT_DESCRIPTION.add(new ColumnDescription("OUTPUT", "", "", "", 6, 0, 0, 0, TypeUtils.getTypeName(6, 0)));
            }
            catch (NumericOverflowException numericOverflowException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

