/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.support.SettingReader;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.ExceptionUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DSILogger
implements ILogger {
    public static final String LOG_PRINT_WRITER_KEY = "LogPrintWriter";
    private static final String LOG_FILE_EXTENSION = ".log";
    private LogLevel m_level = LogLevel.OFF;
    private String m_fileName;
    private Locale m_locale;
    private String m_package = "";
    private PrintWriter m_logWriter = null;
    private List<String> m_logCreationErrors = new ArrayList<String>();

    public DSILogger(String string) {
        this.prepareSettings(string);
        this.m_locale = ExceptionUtilities.createLocale(SettingReader.readSetting("DriverLocale"));
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public LogLevel getLogLevel() {
        return this.m_level;
    }

    public boolean isEnabled() {
        return this.m_level != LogLevel.OFF;
    }

    public void logDebug(String string, String string2, String string3, ErrorException errorException) {
        this.logDebug(string, string2, string3, this.getExceptionMessage(errorException));
    }

    public void logDebug(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.DEBUG, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    public void logError(String string, String string2, String string3, ErrorException errorException) {
        this.logError(string, string2, string3, this.getExceptionMessage(errorException));
    }

    public void logError(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.ERROR, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    public void logFatal(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.FATAL, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    public void logFunctionEntrance(String string, String string2, String string3) {
        String string4 = this.formatLogLine(LogLevel.TRACE, string, string2, string3, "+++++ enter +++++");
        if (null != string4) {
            this.writeLogLine(string4);
        }
    }

    public void logInfo(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.INFO, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    public void logTrace(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.TRACE, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
            Throwable throwable = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append("   at ");
                stringBuffer.append(stackTraceElementArray[i].toString());
                stringBuffer.append("\n");
            }
            this.writeLogLine(stringBuffer.toString());
        }
    }

    public void logWarning(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.WARNING, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    public void prepareSettings(String string) {
        String string2 = "";
        String string3 = SettingReader.readSetting("LogLevel");
        this.m_level = LogLevel.getLogLevel(string3);
        string2 = SettingReader.readSetting("LogPath");
        string2 = this.resolveDirectory(string2);
        if (!string.contains(".")) {
            string = string + LOG_FILE_EXTENSION;
        }
        this.m_fileName = string2 + string;
        this.m_package = SettingReader.readSetting("LogNamespace");
        if (this.m_package == null) {
            this.m_package = "";
        }
        this.prepareLogWriter();
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.m_level = logLevel;
        if (LogLevel.OFF != logLevel) {
            this.prepareLogWriter();
        }
    }

    public void setLogPackage(String string) {
        this.m_package = string;
    }

    private String formatLogLine(LogLevel logLevel, String string, String string2, String string3, String string4) {
        if (null == this.m_logWriter) {
            return null;
        }
        String string5 = null;
        if (this.isInLevel(logLevel) && this.isInPackage(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            SimpleDateFormat simpleDateFormat = null;
            simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss.SSS");
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(0));
            stringBuffer.append(" ");
            switch (logLevel) {
                case FATAL: {
                    stringBuffer.append("FATAL");
                    break;
                }
                case ERROR: {
                    stringBuffer.append("ERROR");
                    break;
                }
                case WARNING: {
                    stringBuffer.append("WARN ");
                    break;
                }
                case INFO: {
                    stringBuffer.append("INFO ");
                    break;
                }
                case DEBUG: {
                    stringBuffer.append("DEBUG");
                    break;
                }
                case TRACE: {
                    stringBuffer.append("TRACE");
                    break;
                }
                default: {
                    stringBuffer.append("LEVEL");
                }
            }
            stringBuffer.append(" ");
            stringBuffer.append(Thread.currentThread().getId()).append(" ");
            stringBuffer.append(string);
            stringBuffer.append(".");
            stringBuffer.append(string2);
            stringBuffer.append(".");
            stringBuffer.append(string3);
            stringBuffer.append(": ");
            stringBuffer.append(string4);
            string5 = stringBuffer.toString();
        }
        return string5;
    }

    private String getExceptionMessage(ErrorException errorException) {
        errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), this.m_locale);
        StringWriter stringWriter = new StringWriter();
        errorException.printStackTrace(new PrintWriter(stringWriter));
        return errorException.getMessage() + "\n" + stringWriter.toString();
    }

    private boolean isInLevel(LogLevel logLevel) {
        return logLevel.ordinal() <= this.m_level.ordinal();
    }

    private boolean isInPackage(String string) {
        if (null == string) {
            return false;
        }
        return string.startsWith(this.m_package);
    }

    private void prepareLogWriter() {
        this.m_logWriter = (PrintWriter)SettingReader.readAdditionalSetting(LOG_PRINT_WRITER_KEY);
        if (this.isEnabled() && null == this.m_logWriter) {
            if (null != this.m_fileName && 0 != this.m_fileName.length() && this.m_logCreationErrors.isEmpty()) {
                try {
                    Object object;
                    File file;
                    int n = this.m_fileName.lastIndexOf(File.separator);
                    if (-1 != n && !(file = new File((String)(object = this.m_fileName.substring(0, n)))).exists() && !file.mkdir()) {
                        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CANNOT_CREATE_LOGGING_PATH.name(), (String)object, ExceptionType.DEFAULT);
                    }
                    object = new FileOutputStream(this.m_fileName, true);
                    this.m_logWriter = new PrintWriter((OutputStream)object);
                    return;
                }
                catch (Exception exception) {
                    this.m_logCreationErrors.add(exception.getLocalizedMessage());
                }
            }
            this.m_logWriter = new PrintWriter(System.out);
            for (String string : this.m_logCreationErrors) {
                ErrorException errorException = DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DEFAULT_LOGGING.name(), string, ExceptionType.DEFAULT);
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                this.m_logWriter.println(errorException.getMessage());
            }
        }
    }

    private String resolveDirectory(String string) {
        String string2 = "";
        try {
            File file;
            if (null != string && !(string2 = (file = new File(string)).getCanonicalPath()).endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
        }
        catch (Exception exception) {
            this.m_logCreationErrors.add(exception.getLocalizedMessage());
        }
        return string2;
    }

    private synchronized void writeLogLine(String string) {
        this.m_logWriter.println(string);
        this.m_logWriter.flush();
    }
}

