/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.ext;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.utilities.AttributeDataMap;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.interfaces.IDataEngine;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IQueryExecutor;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.OrderType;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.exceptions.ParsingException;
import com.vertica.dsi.ext.DSIExtResultSet;
import com.vertica.dsi.ext.IMetadataHelper;
import com.vertica.dsi.ext.OperationHandlerFactory;
import com.vertica.dsi.ext.StoredProcedure;
import com.vertica.dsi.ext.TableOpenType;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlDataEngine
implements IDataEngine {
    private AttributeDataMap m_engineProperties = new AttributeDataMap();

    protected SqlDataEngine() throws ErrorException {
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
    }

    public IMetadataHelper createMetadataHelper() {
        return null;
    }

    public OperationHandlerFactory createOperationHandlerFactory() {
        return null;
    }

    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        if (null == this.m_engineProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (this.m_engineProperties.isProperty(n)) {
            return this.m_engineProperties.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    public AttributeDataMap getPropertyMap() {
        return this.m_engineProperties;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_ACTION_SQLENGINE.name());
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        return null;
    }

    public abstract IMetadataSource makeNewMetadataTable(MetadataSourceID var1, ArrayList<String> var2, String var3, String var4, boolean var5) throws ErrorException;

    public abstract StoredProcedure openProcedure(String var1, String var2, String var3) throws ErrorException;

    public abstract DSIExtResultSet openTable(String var1, String var2, String var3, TableOpenType var4) throws ErrorException;

    @Override
    public final IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_ACTION_SQLENGINE.name());
    }

    @Override
    public final IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_ACTION_SQLENGINE.name());
    }

    @Override
    public void setDirectExecute() {
    }

    @Override
    public void setMetadataNeeded(boolean bl) {
    }

    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        if (null == this.m_engineProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        this.m_engineProperties.setProperty(n, variant);
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_engineProperties.setProperty(0, 0, "N");
        this.m_engineProperties.setProperty(1, 0, "Y");
        this.m_engineProperties.setProperty(2, 0, "N");
        this.m_engineProperties.setProperty(3, 0, "Y");
        this.m_engineProperties.setProperty(4, 3, 0L);
        this.m_engineProperties.setProperty(5, 0, "Y");
        this.m_engineProperties.setProperty(6, 0, "N");
        this.m_engineProperties.setProperty(7, 0, "N");
        this.m_engineProperties.setProperty(8, 0, "N");
        this.m_engineProperties.setProperty(9, 0, "N");
        this.m_engineProperties.setProperty(10, 0, "N");
    }
}

