/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.sun.rowset.CachedRowSetImpl;
import com.vertica.core.VConnection;
import com.vertica.jdbc.kv.KVErrors;
import com.vertica.jdbc.kv.OutputColumn;
import com.vertica.jdbc.kv.ProjectionMetadata;
import com.vertica.jdbc.kv.RoutableConnection;
import com.vertica.jdbc.kv.RoutableConnectionPool;
import com.vertica.jdbc.kv.SQLWarningChainer;
import com.vertica.jdbc.kv.SortColumn;
import com.vertica.jdbc.kv.TableMetadata;
import com.vertica.jdbc.kv.VHash;
import com.vertica.jdbc.kv.VerticaJdbc4RoutableConnectionImpl;
import com.vertica.parser.Tokenizer;
import com.vertica.util.TypeUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RoutableQuery {
    VerticaJdbc4RoutableConnectionImpl parentConn;
    String schema;
    String table;
    RoutableConnectionPool pool;
    TableMetadata metadata;
    SQLWarningChainer warnings;
    ProjectionMetadata lastProjUsed;
    String lastNodeUsed;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String dateFormat = "yyyy-MM-dd";
    private static final String timeFormat = "HH:mm:ss.SSS";
    private static final String timeTzFormat = "HH:mm:ss.SSS";
    private static final String tsFormat = "yyyy-MM-dd HH:mm:ss.SSSZ";
    private static final String tsTzFormat = "yyyy-MM-dd HH:mm:ss.SSSZ";

    RoutableQuery(VerticaJdbc4RoutableConnectionImpl verticaJdbc4RoutableConnectionImpl, String string, String string2, SQLWarningChainer sQLWarningChainer) throws SQLException {
        this.parentConn = verticaJdbc4RoutableConnectionImpl;
        String string3 = this.schema = string == null ? "" : string.toLowerCase();
        if (string2 == null || "".equals(string2)) {
            throw KVErrors.InvalidTableName.makeException(string2);
        }
        this.table = string2.toLowerCase();
        this.pool = verticaJdbc4RoutableConnectionImpl.pool;
        this.warnings = sQLWarningChainer;
        this.metadata = this.parentConn.metaCache.getMetadata(this.schema, this.table, this.warnings);
    }

    ResultSet execute(Map<String, Object> map, Set<String> set, List<OutputColumn> list, List<SortColumn> list2, String string) throws SQLException {
        return this.execute(map, set, list, list2, string, true);
    }

    ResultSet executeSQLQuery(String string, Map<String, Object> map) throws SQLException {
        return this.execute(map, null, null, null, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet execute(Map<String, Object> map, Set<String> set, List<OutputColumn> arrayList, List<SortColumn> list, String string, boolean bl) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        List<ProjectionMetadata.ProjectionRanking> list2 = this.metadata.getProjectionsFor(map.keySet(), (List<OutputColumn>)(bl ? arrayList : new ArrayList<OutputColumn>()));
        if (list2.isEmpty()) {
            throw KVErrors.NotEnoughPredicates.makeException(new Object[0]);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap<Object, ProjectionMetadata> hashMap = new HashMap<Object, ProjectionMetadata>();
        for (ProjectionMetadata.ProjectionRanking object4 : list2) {
            ProjectionMetadata projectionMetadata = object4.proj;
            object3 = new VHash();
            for (ProjectionMetadata.ProjectionColumnMetadata projectionColumnMetadata : projectionMetadata.getSegmentationColumns()) {
                object2 = map.get(projectionColumnMetadata.nameInTable);
                int n = this.metadata.getColumnType(projectionColumnMetadata.nameInTable);
                int n2 = this.metadata.getColumnTypeMod(projectionColumnMetadata.nameInTable);
                ((VHash)object3).addByType(object2, n, n2);
            }
            object = projectionMetadata.getNodeFor(((VHash)object3).getHash());
            if (hashMap.containsKey(object)) continue;
            arrayList2.add(object);
            hashMap.put(object, projectionMetadata);
        }
        ArrayList<Object> arrayList3 = arrayList2;
        while (true) {
            ResultSet resultSet;
            block20: {
                Object var20_28;
                boolean bl2;
                RoutableConnection routableConnection;
                block18: {
                    ResultSet resultSet2;
                    block19: {
                        block16: {
                            ResultSet resultSet3;
                            block17: {
                                if (arrayList3.isEmpty()) {
                                    throw KVErrors.ClusterFailedNoConnections.makeException(new Object[0]);
                                }
                                routableConnection = this.pool.getConnection((List<String>)arrayList3, !bl);
                                bl2 = false;
                                object3 = (ProjectionMetadata)hashMap.get(routableConnection.node);
                                if (!bl) break block16;
                                object = this.rewriteQuery(string, map, set, arrayList, list, (ProjectionMetadata)object3, true);
                                resultSet3 = this.runQuery(routableConnection, (String)object, (ProjectionMetadata)object3);
                                var20_28 = null;
                                if (bl2 || routableConnection == null) break block17;
                                this.pool.returnConnection(routableConnection);
                            }
                            return resultSet3;
                        }
                        Object object4 = object = string.charAt(string.length() - 1) == ';' ? string.substring(0, string.length() - 1) : string;
                        if (((ProjectionMetadata)object3).offset < 0) break block18;
                        resultSet2 = this.runQuery(routableConnection, "SELECT /*+KV(O" + ((ProjectionMetadata)object3).offset + ")*/ * FROM ( " + (String)object + ") TMP", (ProjectionMetadata)object3);
                        var20_28 = null;
                        if (bl2 || routableConnection == null) break block19;
                        this.pool.returnConnection(routableConnection);
                    }
                    return resultSet2;
                }
                try {
                    resultSet = this.runQuery(routableConnection, "SELECT /*+KV*/ * FROM ( " + (String)object + ") TMP", (ProjectionMetadata)object3);
                    var20_28 = null;
                    if (bl2 || routableConnection == null) break block20;
                }
                catch (SQLException sQLException) {
                    block21: {
                        int n;
                        block22: {
                            block25: {
                                block23: {
                                    ResultSet resultSet4;
                                    block24: {
                                        try {
                                            this.parentConn.log.logError("Failed to execute get on " + ((ProjectionMetadata)object3).schema + "." + ((ProjectionMetadata)object3).name + " on node " + routableConnection.node, sQLException);
                                            if (sQLException instanceof SQLRecoverableException || sQLException instanceof SQLNonTransientConnectionException) {
                                                this.warnings.add(KVErrors.ConnectionFailedGetRetried.makeWarning(sQLException, routableConnection.node));
                                                arrayList3.remove(routableConnection.node);
                                                this.parentConn.log.logInfo("Retrying query as multi-node");
                                                this.pool.destroyConnection(routableConnection);
                                                bl2 = true;
                                                break block21;
                                            }
                                            n = sQLException.getErrorCode();
                                            if (n != 2242 || this.getFailOnMultiNodePlans()) break block22;
                                            this.warnings.add(KVErrors.GetRetriedAsMultinode.makeWarning(new Object[0]));
                                            if (!bl) break block23;
                                            object2 = this.rewriteQuery(string, map, set, arrayList, list, (ProjectionMetadata)object3, false);
                                            resultSet4 = this.runQuery(routableConnection, (String)object2, (ProjectionMetadata)object3);
                                            var20_28 = null;
                                            if (bl2 || routableConnection == null) break block24;
                                        }
                                        catch (Throwable throwable) {
                                            var20_28 = null;
                                            if (!bl2 && routableConnection != null) {
                                                this.pool.returnConnection(routableConnection);
                                            }
                                            throw throwable;
                                        }
                                        this.pool.returnConnection(routableConnection);
                                    }
                                    return resultSet4;
                                }
                                object2 = this.runQuery(routableConnection, string, (ProjectionMetadata)object3);
                                var20_28 = null;
                                if (bl2 || routableConnection == null) break block25;
                                this.pool.returnConnection(routableConnection);
                            }
                            return object2;
                        }
                        if (n == 2624) {
                            throw sQLException;
                        }
                        throw sQLException;
                    }
                    var20_28 = null;
                    if (bl2 || routableConnection == null) continue;
                    this.pool.returnConnection(routableConnection);
                    {
                        continue;
                    }
                }
                this.pool.returnConnection(routableConnection);
            }
            return resultSet;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet runQuery(RoutableConnection routableConnection, String string, ProjectionMetadata projectionMetadata) throws SQLException {
        CachedRowSetImpl cachedRowSetImpl;
        Statement statement;
        block7: {
            if (this.parentConn.log.isEnabled()) {
                this.parentConn.log.logDebug("Executing " + string + " on node " + routableConnection.node);
            }
            statement = null;
            ResultSet resultSet = null;
            try {
                statement = routableConnection.conn.createStatement();
                resultSet = statement.executeQuery(string);
                for (SQLWarning sQLWarning = statement.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                    this.warnings.add(sQLWarning);
                }
                CachedRowSetImpl cachedRowSetImpl2 = new CachedRowSetImpl();
                cachedRowSetImpl2.populate(resultSet);
                cachedRowSetImpl2.setReadOnly(true);
                cachedRowSetImpl = cachedRowSetImpl2;
                Object var10_9 = null;
                if (resultSet == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.lastProjUsed = projectionMetadata;
                this.lastNodeUsed = routableConnection.node;
                throw throwable;
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        this.lastProjUsed = projectionMetadata;
        this.lastNodeUsed = routableConnection.node;
        return cachedRowSetImpl;
    }

    private String rewriteQuery(String string, Map<String, Object> map, Set<String> set, List<OutputColumn> list, List<SortColumn> list2, ProjectionMetadata projectionMetadata, boolean bl) throws SQLException {
        Object object;
        HashSet<String> hashSet;
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        long l = this.parentConn.epoch.get();
        if (l > -1L) {
            stringBuilder.append("at epoch ");
            stringBuilder.append(l);
            stringBuilder.append(" ");
        }
        stringBuilder.append(string, 0, 7);
        if (bl) {
            stringBuilder.append("/*+KV*/ ");
        }
        int n = string.indexOf("?");
        stringBuilder.append(string, 7, n);
        stringBuilder.append("(select ");
        boolean bl2 = true;
        for (ProjectionMetadata.ProjectionColumnMetadata iterator : projectionMetadata.getColumns()) {
            if (!bl2) {
                stringBuilder.append(",");
            } else {
                bl2 = false;
            }
            stringBuilder.append(Tokenizer.quoteIdentifier(iterator.nameInProj));
            if (!iterator.nameInTable.equals(iterator.nameInProj)) {
                stringBuilder.append(" as ");
                stringBuilder.append(Tokenizer.quoteIdentifier(iterator.nameInTable));
            }
            stringBuilder.append(" ");
        }
        if (this.metadata.isFlexTable()) {
            hashSet = new HashSet();
            for (OutputColumn outputColumn : list) {
                if (outputColumn.isExpr || projectionMetadata.getProjColName(outputColumn.colOrExpr) != null) continue;
                if (!bl2) {
                    stringBuilder.append(",");
                } else {
                    bl2 = false;
                }
                stringBuilder.append(Tokenizer.quoteIdentifier(outputColumn.colOrExpr));
                stringBuilder.append(" ");
                hashSet.add(outputColumn.colOrExpr);
            }
            for (SortColumn sortColumn : list2) {
                if (projectionMetadata.getProjColName(sortColumn.col) != null || hashSet.contains(sortColumn.col)) continue;
                if (!bl2) {
                    stringBuilder.append(",");
                } else {
                    bl2 = false;
                }
                stringBuilder.append(Tokenizer.quoteIdentifier(sortColumn.col));
                stringBuilder.append(" ");
                hashSet.add(sortColumn.col);
            }
        }
        stringBuilder.append("from ");
        if (!projectionMetadata.schema.equals("")) {
            stringBuilder.append(Tokenizer.quoteIdentifier(projectionMetadata.schema));
            stringBuilder.append(".");
        }
        stringBuilder.append(Tokenizer.quoteIdentifier(projectionMetadata.name));
        stringBuilder.append(" where ");
        hashSet = new HashSet<String>();
        hashSet.addAll(map.keySet());
        bl2 = true;
        for (ProjectionMetadata.ProjectionColumnMetadata projectionColumnMetadata : projectionMetadata.getSegmentationColumns()) {
            hashSet.remove(projectionColumnMetadata.nameInTable);
            object = map.get(projectionColumnMetadata.nameInTable);
            RoutableQuery.addPredicate(stringBuilder, bl2, projectionColumnMetadata.nameInProj, object, this.metadata.getColumnType(projectionColumnMetadata.nameInTable));
            bl2 = false;
        }
        for (String string2 : hashSet) {
            object = map.get(string2);
            RoutableQuery.addPredicate(stringBuilder, bl2, projectionMetadata.getProjColName(string2), object, this.metadata.getColumnType(string2));
            bl2 = false;
        }
        for (String string3 : set) {
            stringBuilder.append(bl2 ? "" : " AND ");
            stringBuilder.append(string3);
            bl2 = false;
        }
        stringBuilder.append(")");
        stringBuilder.append(string, n + 1, string.length());
        return stringBuilder.toString();
    }

    private static void addPredicate(StringBuilder stringBuilder, boolean bl, String string, Object object, int n) {
        if (!bl) {
            stringBuilder.append("AND ");
        }
        stringBuilder.append(Tokenizer.quoteIdentifier(string));
        if (object == null) {
            stringBuilder.append("<=>");
            stringBuilder.append("NULL");
        } else {
            stringBuilder.append("=");
            if (object instanceof Number) {
                stringBuilder.append(object.toString());
            } else if (object instanceof byte[]) {
                stringBuilder.append("hex_to_binary('0x");
                RoutableQuery.appendBytesAsHex((byte[])object, stringBuilder);
                stringBuilder.append("')");
            } else if (object instanceof Date) {
                RoutableQuery.appendDateTimeType(stringBuilder, (Date)object, Calendar.getInstance(), n);
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                RoutableQuery.appendDateTimeType(stringBuilder, calendar.getTime(), calendar, n);
            } else {
                stringBuilder.append("'");
                stringBuilder.append(object.toString());
                stringBuilder.append("'");
            }
        }
        stringBuilder.append(" ");
    }

    void close() throws SQLException {
    }

    private static void appendBytesAsHex(byte[] byArray, StringBuilder stringBuilder) {
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(hex[(byArray[i] & 0xF0) >>> 4]);
            stringBuilder.append(hex[byArray[i] & 0xF]);
        }
    }

    private static void appendDateTimeType(StringBuilder stringBuilder, Date date, Calendar calendar, int n) {
        String string = n == 91 ? dateFormat : (n == 92 ? "HH:mm:ss.SSS" : "yyyy-MM-dd HH:mm:ss.SSSZ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        stringBuilder.append("'");
        simpleDateFormat.setCalendar(calendar);
        stringBuilder.append(simpleDateFormat.format(date));
        stringBuilder.append("'");
    }

    public void checkTypeSupported(String string, Object object) throws SQLException {
        if (!this.metadata.isValuesTypeCompatible(string, object)) {
            int n = this.metadata.getColumnType(string);
            String string2 = n == 1111 ? "<UDType>" : TypeUtils.getTypeName(TypeUtils.getOIDFromSQLType(n), -1);
            throw KVErrors.TypeNotSupported.makeException(object == null ? "<null>" : object.getClass().getName(), string2);
        }
    }

    boolean getFailOnMultiNodePlans() {
        return ((VConnection)this.parentConn.getConnection()).getFailOnMultiNodePlans();
    }
}

