/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.parser;

import com.vertica.localization.VMessageKey;
import com.vertica.parser.Quote;
import com.vertica.parser.Token;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;

public class Tokenizer {
    private int m_currentPos;
    private char[] m_statementChars;
    private boolean m_useStandardStrings;

    public Tokenizer(String string, boolean bl) {
        this.m_statementChars = string.toCharArray();
        this.m_useStandardStrings = bl;
    }

    public Token next() throws ErrorException {
        if (!this.hasNext()) {
            return null;
        }
        Quote quote = this.getCurrentQuote(null);
        boolean bl = quote.type != 1;
        int n = this.m_currentPos;
        int n2 = Integer.MAX_VALUE;
        String string = "";
        String string2 = "";
        while (this.hasNext()) {
            if (!bl) {
                if (n == this.m_currentPos && this.isSpecialChar(this.currentChar())) {
                    n2 = ++this.m_currentPos;
                    break;
                }
                int n3 = 2;
                if (this.atCommentStart()) {
                    if (n != this.m_currentPos) break;
                    this.m_currentPos += n3;
                    while (this.hasNext()) {
                        if ("*/".equals(this.substringFromCurrent(n3))) {
                            this.m_currentPos += n3;
                            break;
                        }
                        ++this.m_currentPos;
                    }
                    n2 = this.m_currentPos > this.m_statementChars.length ? this.m_statementChars.length : this.m_currentPos;
                    break;
                }
                boolean bl2 = Character.isWhitespace(this.currentChar()) || this.atCommentStart();
                char c = this.currentChar();
                if (bl2 || this.isSpecialChar(c) || this.atOpeningQuote()) {
                    n2 = this.m_currentPos;
                    break;
                }
            } else if (!this.atEscapeChar(quote)) {
                Quote quote2 = this.getCurrentQuote(quote);
                if (quote2.type != 1) {
                    n2 = this.m_currentPos - (quote2.type != 16 ? 1 : 2 + quote2.tag.length());
                    break;
                }
            }
            ++this.m_currentPos;
        }
        if (n2 == Integer.MAX_VALUE) {
            if (quote.type != 1) {
                throw new ErrorException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, 101, VMessageKey.ERROR_UNCLOSED_QUOTE.toString(), new String[]{new String(this.m_statementChars)});
            }
            n2 = this.m_currentPos;
        }
        string = new String(this.m_statementChars, n, n2 - n);
        if (this.skipNoise() && this.hasNext()) {
            string2 = " ";
        }
        return new Token(string, quote, string2);
    }

    public boolean atEscapeChar(Quote quote) {
        char c = this.currentChar();
        if (this.m_currentPos + 1 == this.m_statementChars.length) {
            return false;
        }
        switch (quote.type) {
            case 32: {
                if (c == '\"') {
                    ++this.m_currentPos;
                    char c2 = this.currentChar();
                    if (c2 == '\"') {
                        return true;
                    }
                    --this.m_currentPos;
                    break;
                }
                if (this.m_useStandardStrings || c != '\\') break;
                ++this.m_currentPos;
                char c3 = this.currentChar();
                if (c3 == '\\' || c3 == '\"') {
                    return true;
                }
                --this.m_currentPos;
                break;
            }
            case 2: {
                if (c == '\'') {
                    ++this.m_currentPos;
                    char c4 = this.currentChar();
                    if (c4 == '\'') {
                        return true;
                    }
                    --this.m_currentPos;
                    break;
                }
                if (this.m_useStandardStrings || c != '\\') break;
                ++this.m_currentPos;
                char c5 = this.currentChar();
                if (c5 == '\\' || c5 == '\'') {
                    return true;
                }
                --this.m_currentPos;
                break;
            }
            case 4: {
                if (c != '\\') break;
                ++this.m_currentPos;
                char c6 = this.currentChar();
                if (c6 == '\\' || c6 == '\'') {
                    return true;
                }
                --this.m_currentPos;
            }
        }
        return false;
    }

    private boolean isSpecialChar(char c) {
        return c == '?' || c == '.' || c == ',' || c == '(' || c == ')' || c == ';' || c == '\\' || c == '{' || c == '}';
    }

    public Token peek() {
        int n = this.m_currentPos;
        Token token = null;
        try {
            if (this.hasNext()) {
                token = this.next();
            }
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
        this.m_currentPos = n;
        return token;
    }

    public boolean hasNext() {
        return this.m_currentPos < this.m_statementChars.length;
    }

    private boolean atOpeningQuote() {
        int n = this.m_currentPos;
        Quote quote = this.getCurrentQuote(null);
        this.m_currentPos = n;
        return quote.type != 1;
    }

    private String substringFromCurrent(int n) {
        if (this.m_currentPos + n < this.m_statementChars.length) {
            return new String(this.m_statementChars, this.m_currentPos, n);
        }
        return new String(this.m_statementChars, this.m_currentPos, Math.min(n, this.m_statementChars.length - this.m_currentPos));
    }

    private char currentChar() {
        return this.m_statementChars[this.m_currentPos];
    }

    private Quote getCurrentQuote(Quote quote) {
        assert (this.hasNext());
        assert (quote == null || quote.type != 1);
        boolean bl = quote == null;
        char c = this.currentChar();
        if (c != '\'' && c != '\"' && c != 'E' && c != 'e' && c != 'u' && c != 'U' && c != '$') {
            return Quote.NO_QUOTES;
        }
        Quote quote2 = new Quote();
        quote2.type = 1;
        switch (c) {
            case '\'': {
                if (bl) {
                    quote2.type = 2;
                    ++this.m_currentPos;
                    break;
                }
                if (quote.type == 2 || quote.type == 4 || quote.type == 8) {
                    quote2 = quote;
                    ++this.m_currentPos;
                    break;
                }
                assert (quote.type == 32 || quote.type == 16);
                break;
            }
            case '\"': {
                if (bl) {
                    quote2.type = 32;
                    ++this.m_currentPos;
                    break;
                }
                if (quote.type == 32) {
                    quote2 = quote;
                    ++this.m_currentPos;
                    break;
                }
                assert (quote.type == 2 || quote.type == 16 || quote.type == 4 || quote.type == 8);
                break;
            }
            case 'E': 
            case 'e': {
                if (!bl || this.m_currentPos + 1 >= this.m_statementChars.length || this.m_statementChars[this.m_currentPos + 1] != '\'') break;
                quote2.type = 4;
                this.m_currentPos += 2;
                break;
            }
            case 'U': 
            case 'u': {
                if (!bl || this.m_currentPos + 2 >= this.m_statementChars.length || this.m_statementChars[this.m_currentPos + 1] != '&' || this.m_statementChars[this.m_currentPos + 2] != '\'') break;
                quote2.type = 8;
                this.m_currentPos += 3;
                break;
            }
            case '$': {
                int n = this.m_currentPos++;
                if (!this.hasNext()) {
                    quote2.type = 1;
                    break;
                }
                String string = "";
                char c2 = this.currentChar();
                while (this.hasNext() && c2 != '$') {
                    string = string + c2;
                    ++this.m_currentPos;
                    if (!this.hasNext()) continue;
                    c2 = this.currentChar();
                }
                if (bl) {
                    if (this.hasNext()) {
                        assert (c2 == '$');
                        quote2.tag = string;
                        quote2.type = 16;
                        ++this.m_currentPos;
                        break;
                    }
                    quote2.type = 1;
                    this.m_currentPos = n + 1;
                    break;
                }
                if (quote.type == 16) {
                    if (!this.hasNext() || !string.equals(quote.tag)) {
                        quote2.type = 1;
                        this.m_currentPos = n + 1;
                        break;
                    }
                    assert (c2 == '$');
                    quote2.type = 16;
                    quote2.tag = string;
                    ++this.m_currentPos;
                    break;
                }
                this.m_currentPos = n;
                break;
            }
        }
        assert (quote == null || quote.type == quote2.type || quote2.type == 1);
        return quote2;
    }

    private boolean skipNoise() {
        if (!this.hasNext()) {
            return false;
        }
        boolean bl = false;
        while (this.hasNext() && Character.isWhitespace(this.currentChar())) {
            ++this.m_currentPos;
            bl = true;
        }
        return bl;
    }

    private boolean atCommentStart() {
        String string = this.substringFromCurrent(2);
        return "/*".equals(string) || "--".equals(string);
    }

    public static String quoteIdentifier(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('\"');
        stringBuilder.append(string.replace("\"", "\"\""));
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

