/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sap.exception;

public class SAPException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int ERROR_CONFIGURATION = 0;
    public static final int ERROR_COMMUNICATION = 1;
    public static final int ERROR_NOT_AUTHORIZED = 2;
    public static final int ERROR_TRANSACTION = 3;
    public static final int ERROR_TABLE_NOT_AVAILABLE = 10;
    public static final int ERROR_TABLE_FIELD_INVALID = 11;
    public static final int ERROR_TABLE_CONDITION_INVALID = 12;
    public static final int ERROR_TABLE_DATA_BUFFER_EXCEEDED = 13;
    public static final int ERROR_BAPI_NOT_AVAILABLE = 20;
    public static final int ERROR_BAPI_FIELD_INVALID = 21;
    public static final int ERROR_BAPI_CALL = 22;
    public static final int ERROR_BAPI_INPUT_MALFORMED = 23;
    public static final int ERROR_IDOC_TYPE_NOT_AVAILABLE = 30;
    public static final int ERROR_IDOC_TYPE_RELATION_INVALID = 31;
    public static final int ERROR_BW_CALL = 40;
    public static final int ERROR_BW_FIELD_INVALID = 41;
    private int errorCode;
    private String bapiName;
    private String objectName;
    private String tableName;
    private int errorGroup;
    private String errorKey;
    private String errorMessage;
    private String errorMessageClass;
    private String errorMessageNumber;
    private String errorMessageText;
    private char errorMessageType;

    public static Builder newBuilder() {
        return new Builder();
    }

    SAPException() {
    }

    public String getBapiName() {
        return this.bapiName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorGroup() {
        return this.errorGroup;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageClass() {
        return this.errorMessageClass;
    }

    public String getErrorMessageNumber() {
        return this.errorMessageNumber;
    }

    public String getErrorMessageText() {
        return this.errorMessageText;
    }

    public char getErrorMessageType() {
        return this.errorMessageType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isBapiCallError() {
        return this.errorCode == 22;
    }

    public boolean isBapiFieldInvalid() {
        return this.errorCode == 21;
    }

    public boolean isBapiNotAvailable() {
        return this.errorCode == 20;
    }

    public boolean isCommunicationError() {
        return this.errorCode == 1;
    }

    public boolean isConfigurationError() {
        return this.errorCode == 0;
    }

    public boolean isTableConditionInvalid() {
        return this.errorCode == 12;
    }

    public boolean isTableFieldInvalid() {
        return this.errorCode == 11;
    }

    public boolean isTableNotAvailable() {
        return this.errorCode == 10;
    }

    public boolean isUserNotAuthorized() {
        return this.errorCode == 2;
    }

    void setBapiName(String bapiName) {
        this.bapiName = bapiName;
    }

    void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getClass().getSimpleName());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(" [\n");
        sb.append("   errorCode=");
        sb.append(this.errorCode);
        sb.append("\n");
        sb.append("  ,errorGroup=");
        sb.append(this.errorGroup);
        sb.append("\n");
        sb.append("  ,errorKey=");
        sb.append(this.errorKey);
        sb.append("\n");
        sb.append("  ,errorMessage=");
        sb.append(this.errorMessage);
        sb.append("\n");
        if (this.errorMessageClass != null) {
            sb.append("  ,errorMessageClass=");
            sb.append(this.errorMessageClass);
            sb.append("\n");
        }
        if (this.errorMessageNumber != null) {
            sb.append("  ,errorMessageNumber=");
            sb.append(this.errorMessageNumber);
            sb.append("\n");
        }
        if (this.errorMessageText != null) {
            sb.append("  ,errorMessageText=");
            sb.append(this.errorMessageText);
            sb.append("\n");
        }
        if (this.errorMessageType != ' ' && !Character.isISOControl(this.errorMessageType)) {
            sb.append("  ,errorMessageType=");
            sb.append(this.errorMessageType);
            sb.append("\n");
        }
        if (this.bapiName != null) {
            sb.append("  ,bapiName=");
            sb.append(this.bapiName);
            sb.append("\n");
        }
        if (this.objectName != null) {
            sb.append("  ,objectName=");
            sb.append(this.objectName);
            sb.append("\n");
        }
        if (this.tableName != null) {
            sb.append("  ,tableName=");
            sb.append(this.tableName);
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class Builder {
        private final SAPException e = new SAPException();

        private Builder() {
        }

        public SAPException build() {
            return this.e;
        }

        public Builder bapiName(String bapiName) {
            this.e.bapiName = bapiName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.e.objectName = objectName;
            return this;
        }

        public Builder errorCode(int errorCode) {
            this.e.errorCode = errorCode;
            return this;
        }

        public Builder errorGroup(int errorGroup) {
            this.e.errorGroup = errorGroup;
            return this;
        }

        public Builder errorKey(String errorKey) {
            this.e.errorKey = errorKey;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.e.errorMessage = errorMessage;
            return this;
        }

        public Builder errorMessageClass(String errorMessageClass) {
            this.e.errorMessageClass = errorMessageClass;
            return this;
        }

        public Builder errorMessageNumber(String errorMessageNumber) {
            this.e.errorMessageNumber = errorMessageNumber;
            return this;
        }

        public Builder errorMessageText(String errorMessageText) {
            this.e.errorMessageText = errorMessageText;
            return this;
        }

        public Builder errorMessageType(char errorMessageType) {
            this.e.errorMessageType = errorMessageType;
            return this;
        }

        public Builder tableName(String tableName) {
            this.e.tableName = tableName;
            return this;
        }
    }
}

