/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.exception;

public class ComponentException
extends RuntimeException {
    private final ErrorOrigin errorOrigin;
    private final String originalType;
    private final String originalMessage;

    public ComponentException(ErrorOrigin errorOrigin, String type, String message, StackTraceElement[] stackTrace, Throwable cause) {
        super((type != null ? "(" + type + ") " : "") + message);
        this.initCause(this.toGenericThrowable(cause));
        this.errorOrigin = errorOrigin;
        this.originalType = type;
        this.originalMessage = message;
        if (stackTrace != null) {
            this.setStackTrace(stackTrace);
        }
    }

    public ComponentException(String type, String message, StackTraceElement[] stackTrace, Throwable cause) {
        this(ErrorOrigin.UNKNOWN, type, message, stackTrace, cause);
    }

    public ComponentException(ErrorOrigin errorOrigin, String message) {
        this(errorOrigin, message, null);
    }

    public ComponentException(ErrorOrigin errorOrigin, String message, Throwable cause) {
        this(errorOrigin, cause != null ? cause.getClass().getName() : null, message, null, cause);
    }

    public ComponentException(String message) {
        this(ErrorOrigin.UNKNOWN, message);
    }

    public ComponentException(String message, Throwable cause) {
        this(ErrorOrigin.UNKNOWN, message, cause);
    }

    public ComponentException(Throwable cause) {
        this(ErrorOrigin.UNKNOWN, cause.getMessage(), cause);
    }

    protected Throwable toGenericThrowable(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ComponentException) {
            return t;
        }
        Throwable generic = new Throwable(String.format("(%s) : %s", t.getClass().getName(), t.getMessage()));
        generic.setStackTrace(t.getStackTrace());
        Throwable cause = t.getCause();
        Throwable genericCause = null;
        if (cause == null) {
            return generic;
        }
        genericCause = this.toGenericThrowable(cause);
        if (genericCause != null) {
            generic = new Throwable(generic.getMessage(), genericCause);
        }
        return generic;
    }

    public ErrorOrigin getErrorOrigin() {
        return this.errorOrigin;
    }

    public String getOriginalType() {
        return this.originalType;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    public static enum ErrorOrigin {
        USER,
        BACKEND,
        UNKNOWN;

    }
}

