/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.record;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.talend.sdk.component.api.record.Schema;

public class SchemaCompanionUtil {
    public static String sanitizeName(String name) {
        if (Schema.SKIP_SANITIZE || name == null || name.isEmpty()) {
            return name;
        }
        CharsetEncoder ascii = StandardCharsets.US_ASCII.newEncoder();
        StringBuilder sanitizedBuilder = new StringBuilder();
        char firstLetter = SchemaCompanionUtil.sanitizeFirstLetter(name, ascii);
        if (firstLetter != '\uffff') {
            sanitizedBuilder.append(firstLetter);
        }
        for (int i = 1; i < name.length(); ++i) {
            char current = name.charAt(i);
            if (ascii.canEncode(current)) {
                sanitizedBuilder.append(Character.isLetterOrDigit(current) ? current : (char)'_');
                continue;
            }
            if (Character.isLowerCase(current) || Character.isUpperCase(current)) {
                sanitizedBuilder.append('_');
                continue;
            }
            byte[] encoded = SchemaCompanionUtil.base64(name.substring(i, i + 1));
            String enc = new String(encoded, StandardCharsets.UTF_8);
            if (sanitizedBuilder.length() == 0 && Character.isDigit(enc.charAt(0))) {
                sanitizedBuilder.append('_');
            }
            for (int iter = 0; iter < enc.length(); ++iter) {
                char encodedCurrentChar = enc.charAt(iter);
                char sanitizedLetter = Character.isLetterOrDigit(encodedCurrentChar) ? encodedCurrentChar : (char)'_';
                sanitizedBuilder.append(sanitizedLetter);
            }
        }
        return sanitizedBuilder.toString();
    }

    private static byte[] base64(String value) {
        return Base64.getEncoder().encode(value.getBytes(StandardCharsets.UTF_8));
    }

    private static char sanitizeFirstLetter(String name, CharsetEncoder ascii) {
        boolean skipFirstChar;
        char current = name.charAt(0);
        boolean bl = skipFirstChar = (!ascii.canEncode(current) || !SchemaCompanionUtil.validFirstLetter(current)) && name.length() > 1 && !Character.isDigit(name.charAt(1));
        if (skipFirstChar) {
            return '\uffff';
        }
        if (SchemaCompanionUtil.validFirstLetter(current) && ascii.canEncode(current)) {
            return current;
        }
        return '_';
    }

    private static boolean validFirstLetter(char value) {
        return Character.isLetter(value) || value == '_';
    }

    public static Schema.Entry avoidCollision(Schema.Entry newEntry, Function<String, Schema.Entry> entryGetter, BiConsumer<String, Schema.Entry> replaceFunction) {
        boolean matchedToChange;
        if (Schema.SKIP_SANITIZE) {
            return newEntry;
        }
        Schema.Entry alreadyExistedEntry = SchemaCompanionUtil.findCollidedEntry(newEntry, entryGetter);
        if (alreadyExistedEntry == null) {
            return newEntry;
        }
        boolean bl = matchedToChange = !SchemaCompanionUtil.isEmpty(alreadyExistedEntry.getRawName());
        if (matchedToChange) {
            String newSanitizedName = SchemaCompanionUtil.newNotCollidedName(entryGetter, alreadyExistedEntry.getRawName());
            Schema.Entry updatedExistedEntry = alreadyExistedEntry.toBuilder().withName(newSanitizedName).build();
            replaceFunction.accept(alreadyExistedEntry.getName(), updatedExistedEntry);
            return newEntry;
        }
        if (SchemaCompanionUtil.isEmpty(newEntry.getRawName())) {
            return null;
        }
        String newSanitizedName = SchemaCompanionUtil.newNotCollidedName(entryGetter, newEntry.getRawName());
        return newEntry.toBuilder().withName(newSanitizedName).build();
    }

    private static Schema.Entry findCollidedEntry(Schema.Entry newEntry, Function<String, Schema.Entry> entryGetter) {
        return Optional.ofNullable(entryGetter.apply(newEntry.getName())).filter(retrievedEntry -> !Objects.equals(retrievedEntry, newEntry)).orElse(null);
    }

    private static String newNotCollidedName(Function<String, Schema.Entry> entryGetter, String rawName) {
        String baseName = SchemaCompanionUtil.sanitizeName(rawName);
        int indexForAnticollision = 1;
        String newName = baseName + "_" + indexForAnticollision;
        while (entryGetter.apply(newName) != null) {
            newName = baseName + "_" + ++indexForAnticollision;
        }
        return newName;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    @Generated
    private SchemaCompanionUtil() {
    }
}

