/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.record;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.bind.JsonbConfig;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordService;
import org.talend.sdk.component.api.service.record.RecordVisitor;
import org.talend.sdk.component.runtime.di.schema.StudioTypes;
import org.talend.sdk.component.runtime.manager.service.DefaultServiceProvider;
import org.talend.sdk.component.runtime.record.MappingUtils;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import routines.system.Dynamic;
import routines.system.DynamicMetadata;

public class DiRecordVisitor
implements RecordVisitor<Object> {
    private static final Logger log = LoggerFactory.getLogger(DiRecordVisitor.class);
    private final Class<?> clazz;
    private Object instance;
    private final Map<String, Field> fields;
    private final boolean hasDynamic;
    private final Dynamic dynamic;
    private final String dynamicColumn;
    private final int dynamicColumnLength;
    private final int dynamicColumnPrecision;
    private final String dynamicColumnPattern;
    private String recordPrefix = "";
    private String arrayOfRecordPrefix = "";
    private Set<String> recordFields;
    private static final RecordService RECORD_SERVICE = (RecordService)RecordService.class.cast(new DefaultServiceProvider(null, JsonProvider.provider(), Json.createGeneratorFactory(Collections.emptyMap()), Json.createReaderFactory(Collections.emptyMap()), Json.createBuilderFactory(Collections.emptyMap()), Json.createParserFactory(Collections.emptyMap()), Json.createWriterFactory(Collections.emptyMap()), new JsonbConfig(), JsonbProvider.provider(), null, null, Collections.emptyList(), t -> new RecordBuilderFactoryImpl("di"), null).lookup(null, Thread.currentThread().getContextClassLoader(), null, null, RecordService.class, null, null));

    DiRecordVisitor(Class<?> clzz, Map<String, String> metadata) {
        this.clazz = clzz;
        try {
            this.instance = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.fields = Arrays.stream(this.instance.getClass().getFields()).collect(Collectors.toMap(Field::getName, UnaryOperator.identity()));
            this.hasDynamic = this.fields.values().stream().anyMatch(field -> "routines.system.Dynamic".equals(field.getType().getName()));
            this.dynamicColumn = this.fields.values().stream().filter(field -> "routines.system.Dynamic".equals(field.getType().getName())).map(Field::getName).findAny().orElse(null);
            this.dynamic = this.hasDynamic ? new Dynamic() : null;
            log.debug("[DiRecordVisitor] {} dynamic? {} ({} {}).", new Object[]{this.clazz.getName(), this.hasDynamic, this.dynamicColumn, metadata});
            this.dynamicColumnLength = Integer.valueOf(metadata.getOrDefault("field.size", "-1"));
            this.dynamicColumnPrecision = Integer.valueOf(metadata.getOrDefault("field.scale", "-1"));
            this.dynamicColumnPattern = metadata.getOrDefault("field.pattern", "yyyy-MM-dd");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public Object visit(Record record) {
        this.arrayOfRecordPrefix = "";
        this.recordPrefix = "";
        try {
            this.instance = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        if (this.hasDynamic) {
            this.dynamic.metadatas.clear();
            this.dynamic.clearColumnValues();
        }
        this.recordFields = record.getSchema().getAllEntries().filter(t -> t.getType().equals((Object)Schema.Type.RECORD)).map(rcdEntry -> {
            String root = rcdEntry.getName() + ".";
            ArrayList names = new ArrayList();
            rcdEntry.getElementSchema().getAllEntries().filter(e -> e.getType().equals((Object)Schema.Type.RECORD)).map(sr -> {
                String sub = root + sr.getName() + ".";
                return sr.getElementSchema().getAllEntries().map(entry -> sub + entry.getName()).collect(Collectors.toList());
            }).forEach(l -> l.stream().forEach(m -> names.add(m)));
            rcdEntry.getElementSchema().getAllEntries().filter(e -> !e.getType().equals((Object)Schema.Type.RECORD)).map(entry -> root + entry.getName()).forEach(sre -> names.add(sre));
            return names;
        }).flatMap(liststream -> liststream.stream()).collect(Collectors.toSet());
        this.recordFields.addAll(record.getSchema().getAllEntries().filter(t -> !t.getType().equals((Object)Schema.Type.RECORD)).map(entry -> entry.getName()).collect(Collectors.toSet()));
        if (this.hasDynamic) {
            this.prefillDynamic(record.getSchema());
        }
        return RECORD_SERVICE.visit((RecordVisitor)this, record);
    }

    public Object get() {
        if (this.hasDynamic) {
            try {
                this.fields.get(this.dynamicColumn).set(this.instance, this.dynamic);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.instance;
    }

    private void prefillDynamic(Schema schema) {
        schema.getAllEntries().filter(entry -> !this.fields.containsKey(entry.getName()) || this.dynamicColumn.equals(entry.getName())).forEach(entry -> {
            this.dynamic.metadatas.add(this.generateMetadata((Schema.Entry)entry));
            this.dynamic.addColumnValue(null);
        });
    }

    private DynamicMetadata generateMetadata(Schema.Entry entry) {
        DynamicMetadata metadata = new DynamicMetadata();
        metadata.setName(this.recordFields.stream().filter(f -> f.endsWith("." + entry.getName())).findFirst().orElse(entry.getName()));
        metadata.setDbName(entry.getOriginalFieldName());
        metadata.setNullable(entry.isNullable());
        metadata.setDescription(entry.getComment());
        metadata.setSourceType(DynamicMetadata.sourceTypes.unknown);
        Boolean isKey = Optional.ofNullable(entry.getProp("field.key")).filter(l -> !l.isEmpty()).map(Boolean::valueOf).orElse(false);
        Integer length = Optional.ofNullable(entry.getProp("field.size")).filter(l -> !l.isEmpty()).map(Integer::valueOf).orElse(this.dynamicColumnLength);
        Integer precision = Optional.ofNullable(entry.getProp("field.scale")).filter(l -> !l.isEmpty()).map(Integer::valueOf).orElse(this.dynamicColumnPrecision);
        String pattern = Optional.ofNullable(entry.getProp("field.pattern")).filter(l -> !l.isEmpty()).orElse(this.dynamicColumnPattern);
        String studioType = entry.getProps().getOrDefault("talend.studio.type", StudioTypes.typeFromRecord(entry.getType()));
        metadata.setKey(isKey.booleanValue());
        metadata.setType(studioType);
        if (length != null) {
            metadata.setLength(length.intValue());
        }
        if (precision != null) {
            metadata.setPrecision(precision.intValue());
        }
        switch (studioType) {
            case "id_Date": {
                metadata.setLogicalType("timestamp-millis");
                metadata.setFormat(pattern);
                break;
            }
        }
        return metadata;
    }

    private void setField(Schema.Entry entry, Object value) {
        Field field = this.fields.get(entry.getName());
        if (this.hasDynamic && (field == null || this.dynamicColumn.equals(entry.getName()))) {
            DynamicMetadata metadata;
            String name = this.recordFields.stream().filter(f -> f.endsWith("." + entry.getName())).findFirst().orElse(entry.getName());
            int index = this.dynamic.getIndex(name);
            if (index < 0) {
                metadata = this.generateMetadata(entry);
                this.dynamic.metadatas.add(metadata);
                index = this.dynamic.getIndex(name);
            } else {
                metadata = this.dynamic.getColumnMetadata(index);
            }
            Class<?> clazz = StudioTypes.classFromType(metadata.getType());
            if (clazz != null) {
                this.dynamic.setColumnValue(index, MappingUtils.coerce(clazz, (Object)value, (String)name));
            } else {
                this.dynamic.setColumnValue(index, MappingUtils.coerce(value.getClass(), (Object)value, (String)name));
            }
            log.debug("[setField] Dynamic#{}\t{}\t({})\t ==> {}.", new Object[]{index, name, metadata.getType(), value});
            return;
        }
        if (field == null) {
            return;
        }
        try {
            field.set(this.instance, MappingUtils.coerce(field.getType(), (Object)value, (String)entry.getName()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public void onInt(Schema.Entry entry, OptionalInt optionalInt) {
        log.debug("[onInt] visiting {}.", (Object)entry.getName());
        optionalInt.ifPresent(value -> this.setField(entry, value));
    }

    public void onLong(Schema.Entry entry, OptionalLong optionalLong) {
        log.debug("[onLong] visiting {}.", (Object)entry.getName());
        optionalLong.ifPresent(value -> this.setField(entry, value));
    }

    public void onFloat(Schema.Entry entry, OptionalDouble optionalFloat) {
        log.debug("[onFloat] visiting {}.", (Object)entry.getName());
        optionalFloat.ifPresent(value -> this.setField(entry, Float.valueOf((float)value)));
    }

    public void onDouble(Schema.Entry entry, OptionalDouble optionalDouble) {
        log.debug("[onDouble] visiting {}.", (Object)entry.getName());
        optionalDouble.ifPresent(value -> this.setField(entry, value));
    }

    public void onBoolean(Schema.Entry entry, Optional<Boolean> optionalBoolean) {
        log.debug("[onBoolean] visiting {}.", (Object)entry.getName());
        optionalBoolean.ifPresent(value -> this.setField(entry, value));
    }

    public void onString(Schema.Entry entry, Optional<String> string) {
        log.debug("[onString] visiting {}.", (Object)entry.getName());
        string.ifPresent(value -> this.setField(entry, value));
    }

    public void onObject(Schema.Entry entry, Optional<Object> object) {
        log.debug("[onObject] visiting {}.", (Object)entry.getName());
        object.ifPresent(value -> this.setField(entry, value));
    }

    public void onDatetime(Schema.Entry entry, Optional<ZonedDateTime> dateTime) {
        log.debug("[onDatetime] visiting {}.", (Object)entry.getName());
        dateTime.ifPresent(value -> this.setField(entry, value.toInstant().toEpochMilli()));
    }

    public void onDecimal(Schema.Entry entry, Optional<BigDecimal> decimal) {
        log.debug("[onDecimal] visiting {}.", (Object)entry.getName());
        decimal.ifPresent(value -> this.setField(entry, value));
    }

    public void onBytes(Schema.Entry entry, Optional<byte[]> bytes) {
        log.debug("[onBytes] visiting {}.", (Object)entry.getName());
        bytes.ifPresent(value -> this.setField(entry, value));
    }

    public void onIntArray(Schema.Entry entry, Optional<Collection<Integer>> array) {
        log.debug("[onIntArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onLongArray(Schema.Entry entry, Optional<Collection<Long>> array) {
        log.debug("[onLongArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onFloatArray(Schema.Entry entry, Optional<Collection<Float>> array) {
        log.debug("[onFloatArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onDoubleArray(Schema.Entry entry, Optional<Collection<Double>> array) {
        log.debug("[onDoubleArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onBooleanArray(Schema.Entry entry, Optional<Collection<Boolean>> array) {
        log.debug("[onBooleanArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onStringArray(Schema.Entry entry, Optional<Collection<String>> array) {
        log.debug("[onStringArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onDatetimeArray(Schema.Entry entry, Optional<Collection<ZonedDateTime>> array) {
        log.debug("[onDatetimeArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onDecimalArray(Schema.Entry entry, Optional<Collection<BigDecimal>> array) {
        log.debug("[onDecimalArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onBytesArray(Schema.Entry entry, Optional<Collection<byte[]>> array) {
        log.debug("[onBytesArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public RecordVisitor<Object> onRecordArray(Schema.Entry entry, Optional<Collection<Record>> array) {
        log.debug("[onRecordArray] visiting {}.", (Object)entry.getName());
        this.arrayOfRecordPrefix = entry.getName() + ".";
        array.ifPresent(value -> this.setField(entry, value));
        return this;
    }

    public RecordVisitor<Object> onRecord(Schema.Entry entry, Optional<Record> record) {
        log.debug("[onRecord] visiting {}.", (Object)entry.getName());
        this.recordPrefix = entry.getName() + ".";
        record.ifPresent(value -> this.setField(entry, value));
        return this;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public boolean isHasDynamic() {
        return this.hasDynamic;
    }

    public Dynamic getDynamic() {
        return this.dynamic;
    }

    public String getDynamicColumn() {
        return this.dynamicColumn;
    }

    public int getDynamicColumnLength() {
        return this.dynamicColumnLength;
    }

    public int getDynamicColumnPrecision() {
        return this.dynamicColumnPrecision;
    }

    public String getDynamicColumnPattern() {
        return this.dynamicColumnPattern;
    }

    public String getRecordPrefix() {
        return this.recordPrefix;
    }

    public String getArrayOfRecordPrefix() {
        return this.arrayOfRecordPrefix;
    }

    public Set<String> getRecordFields() {
        return this.recordFields;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public void setRecordPrefix(String recordPrefix) {
        this.recordPrefix = recordPrefix;
    }

    public void setArrayOfRecordPrefix(String arrayOfRecordPrefix) {
        this.arrayOfRecordPrefix = arrayOfRecordPrefix;
    }

    public void setRecordFields(Set<String> recordFields) {
        this.recordFields = recordFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiRecordVisitor)) {
            return false;
        }
        DiRecordVisitor other = (DiRecordVisitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasDynamic() != other.isHasDynamic()) {
            return false;
        }
        if (this.getDynamicColumnLength() != other.getDynamicColumnLength()) {
            return false;
        }
        if (this.getDynamicColumnPrecision() != other.getDynamicColumnPrecision()) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        Object this$instance = this.getInstance();
        Object other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
            return false;
        }
        Map<String, Field> this$fields = this.getFields();
        Map<String, Field> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Dynamic this$dynamic = this.getDynamic();
        Dynamic other$dynamic = other.getDynamic();
        if (this$dynamic == null ? other$dynamic != null : !this$dynamic.equals(other$dynamic)) {
            return false;
        }
        String this$dynamicColumn = this.getDynamicColumn();
        String other$dynamicColumn = other.getDynamicColumn();
        if (this$dynamicColumn == null ? other$dynamicColumn != null : !this$dynamicColumn.equals(other$dynamicColumn)) {
            return false;
        }
        String this$dynamicColumnPattern = this.getDynamicColumnPattern();
        String other$dynamicColumnPattern = other.getDynamicColumnPattern();
        if (this$dynamicColumnPattern == null ? other$dynamicColumnPattern != null : !this$dynamicColumnPattern.equals(other$dynamicColumnPattern)) {
            return false;
        }
        String this$recordPrefix = this.getRecordPrefix();
        String other$recordPrefix = other.getRecordPrefix();
        if (this$recordPrefix == null ? other$recordPrefix != null : !this$recordPrefix.equals(other$recordPrefix)) {
            return false;
        }
        String this$arrayOfRecordPrefix = this.getArrayOfRecordPrefix();
        String other$arrayOfRecordPrefix = other.getArrayOfRecordPrefix();
        if (this$arrayOfRecordPrefix == null ? other$arrayOfRecordPrefix != null : !this$arrayOfRecordPrefix.equals(other$arrayOfRecordPrefix)) {
            return false;
        }
        Set<String> this$recordFields = this.getRecordFields();
        Set<String> other$recordFields = other.getRecordFields();
        return !(this$recordFields == null ? other$recordFields != null : !((Object)this$recordFields).equals(other$recordFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiRecordVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasDynamic() ? 79 : 97);
        result = result * 59 + this.getDynamicColumnLength();
        result = result * 59 + this.getDynamicColumnPrecision();
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        Object $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
        Map<String, Field> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Dynamic $dynamic = this.getDynamic();
        result = result * 59 + ($dynamic == null ? 43 : $dynamic.hashCode());
        String $dynamicColumn = this.getDynamicColumn();
        result = result * 59 + ($dynamicColumn == null ? 43 : $dynamicColumn.hashCode());
        String $dynamicColumnPattern = this.getDynamicColumnPattern();
        result = result * 59 + ($dynamicColumnPattern == null ? 43 : $dynamicColumnPattern.hashCode());
        String $recordPrefix = this.getRecordPrefix();
        result = result * 59 + ($recordPrefix == null ? 43 : $recordPrefix.hashCode());
        String $arrayOfRecordPrefix = this.getArrayOfRecordPrefix();
        result = result * 59 + ($arrayOfRecordPrefix == null ? 43 : $arrayOfRecordPrefix.hashCode());
        Set<String> $recordFields = this.getRecordFields();
        result = result * 59 + ($recordFields == null ? 43 : ((Object)$recordFields).hashCode());
        return result;
    }

    public String toString() {
        return "DiRecordVisitor(clazz=" + this.getClazz() + ", instance=" + this.getInstance() + ", fields=" + this.getFields() + ", hasDynamic=" + this.isHasDynamic() + ", dynamic=" + this.getDynamic() + ", dynamicColumn=" + this.getDynamicColumn() + ", dynamicColumnLength=" + this.getDynamicColumnLength() + ", dynamicColumnPrecision=" + this.getDynamicColumnPrecision() + ", dynamicColumnPattern=" + this.getDynamicColumnPattern() + ", recordPrefix=" + this.getRecordPrefix() + ", arrayOfRecordPrefix=" + this.getArrayOfRecordPrefix() + ", recordFields=" + this.getRecordFields() + ")";
    }
}

