/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di;

import java.util.Map;
import javax.json.JsonBuilderFactory;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.spi.JsonProvider;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.di.BaseIOHandler;
import org.talend.sdk.component.runtime.output.OutputFactory;
import org.talend.sdk.component.runtime.record.RecordConverters;

public class OutputsHandler
extends BaseIOHandler {
    private final JsonProvider jsonProvider;
    private final JsonBuilderFactory jsonBuilderFactory;
    private final RecordConverters.MappingMetaRegistry registry = new RecordConverters.MappingMetaRegistry();

    public OutputsHandler(Jsonb jsonb, Map<Class<?>, Object> servicesMapper) {
        super(jsonb, servicesMapper);
        this.jsonProvider = (JsonProvider)servicesMapper.get(JsonProvider.class);
        this.jsonBuilderFactory = (JsonBuilderFactory)servicesMapper.get(JsonBuilderFactory.class);
    }

    public OutputFactory asOutputFactory() {
        return name -> value -> {
            BaseIOHandler.IO ref = (BaseIOHandler.IO)this.connections.get(this.getActualName(name));
            if (ref != null && value != null) {
                if (value instanceof JsonValue) {
                    ref.add(this.jsonb.fromJson(value.toString(), ref.getType()));
                } else if (value instanceof Record) {
                    ref.add(this.registry.find(ref.getType()).newInstance((Record)Record.class.cast(value)));
                } else {
                    ref.add(this.jsonb.fromJson(this.jsonb.toJson(value), ref.getType()));
                }
            }
        };
    }

    public OutputFactory asOutputFactoryForGuessSchema() {
        return name -> value -> {
            BaseIOHandler.IO ref = (BaseIOHandler.IO)this.connections.get(this.getActualName(name));
            if (ref != null && value != null) {
                if (value instanceof JsonValue) {
                    ref.add(this.jsonb.fromJson(value.toString(), ref.getType()));
                } else if (value instanceof Record) {
                    ref.add(((Record)value).getSchema());
                } else if (value instanceof Schema) {
                    ref.add(value);
                } else {
                    ref.add(this.jsonb.fromJson(this.jsonb.toJson(value), ref.getType()));
                }
            }
        };
    }
}

