/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.beam;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.joda.time.Instant;
import org.talend.sdk.component.runtime.di.beam.SettableSourceListener;
import org.talend.sdk.component.runtime.di.beam.SourceListener;

public class DelegatingUnBoundedSource<A, B extends UnboundedSource.CheckpointMark>
extends UnboundedSource<A, B>
implements SettableSourceListener {
    private UnboundedSource<A, B> delegate;
    private SourceListener listener;

    public List<? extends UnboundedSource<A, B>> split(int desiredNumSplits, PipelineOptions options) throws Exception {
        List sources = this.delegate.split(desiredNumSplits, options);
        this.listener.onSplit(sources.size());
        return sources.stream().map(s -> new DelegatingUnBoundedSource<A, B>(s, this.listener)).collect(Collectors.toList());
    }

    public UnboundedSource.UnboundedReader<A> createReader(PipelineOptions options, B checkpointMark) throws IOException {
        return new DelegatingUnboundedReader(this.delegate.createReader(options, checkpointMark), this.listener);
    }

    public Coder<B> getCheckpointMarkCoder() {
        return this.delegate.getCheckpointMarkCoder();
    }

    public boolean requiresDeduping() {
        return this.delegate.requiresDeduping();
    }

    public void validate() {
        this.delegate.validate();
    }

    @Deprecated
    public Coder<A> getDefaultOutputCoder() {
        return this.delegate.getDefaultOutputCoder();
    }

    public Coder<A> getOutputCoder() {
        return this.delegate.getOutputCoder();
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        this.delegate.populateDisplayData(builder);
    }

    @Override
    public void setSourceListener(SourceListener listener) {
        this.listener = listener;
    }

    public DelegatingUnBoundedSource() {
    }

    public DelegatingUnBoundedSource(UnboundedSource<A, B> delegate, SourceListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    private static class DelegatingUnboundedReader<A>
    extends UnboundedSource.UnboundedReader<A> {
        private UnboundedSource.UnboundedReader<A> reader;
        private SourceListener listener;

        public boolean start() throws IOException {
            return this.reader.start();
        }

        public boolean advance() throws IOException {
            return this.reader.advance();
        }

        public byte[] getCurrentRecordId() throws NoSuchElementException {
            return this.reader.getCurrentRecordId();
        }

        public Instant getWatermark() {
            return this.reader.getWatermark();
        }

        public UnboundedSource.CheckpointMark getCheckpointMark() {
            return this.reader.getCheckpointMark();
        }

        public long getSplitBacklogBytes() {
            return this.reader.getSplitBacklogBytes();
        }

        public long getTotalBacklogBytes() {
            return this.reader.getTotalBacklogBytes();
        }

        public UnboundedSource<A, ?> getCurrentSource() {
            return this.reader.getCurrentSource();
        }

        public A getCurrent() throws NoSuchElementException {
            this.listener.onElement();
            return (A)this.reader.getCurrent();
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            this.listener.onElement();
            return this.reader.getCurrentTimestamp();
        }

        public void close() throws IOException {
            try {
                this.reader.close();
            }
            finally {
                this.listener.onReaderClose();
            }
        }

        public DelegatingUnboundedReader() {
        }

        public DelegatingUnboundedReader(UnboundedSource.UnboundedReader<A> reader, SourceListener listener) {
            this.reader = reader;
            this.listener = listener;
        }
    }
}

