/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.beam.components;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.di.JobStateAware;
import org.talend.sdk.component.runtime.di.beam.InMemoryQueueIO;
import org.talend.sdk.component.runtime.di.beam.LoopState;
import org.talend.sdk.component.runtime.di.beam.components.DIPipeline;
import org.talend.sdk.component.runtime.di.beam.components.PipelineInit;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.output.OutputFactory;
import org.talend.sdk.component.runtime.output.Processor;

public class QueueOutput
implements Processor,
JobStateAware,
Supplier<DIPipeline>,
Delegated {
    private static final Logger log = LoggerFactory.getLogger(QueueOutput.class);
    private final LoopState state;
    private final String plugin;
    private final String family;
    private final String name;
    private final PTransform<PCollection<?>, ?> transform;
    private JobStateAware.State jobState;

    public QueueOutput(String plugin, String family, String name, PTransform<PCollection<?>, ?> transform) {
        this.plugin = plugin;
        this.family = family;
        this.name = name;
        this.transform = transform;
        this.state = LoopState.newTracker(plugin);
        log.debug("Associating state {} to {}#{}", new Object[]{this.state.getId(), family, name});
    }

    public String getStateId() {
        return this.state.getId();
    }

    public void onNext(InputFactory input, OutputFactory output) {
        PipelineInit.lazyStart(this.jobState, this);
        this.state.push(input.read("__default__"));
    }

    public void beforeGroup() {
    }

    public void afterGroup(OutputFactory output) {
    }

    public String plugin() {
        return this.plugin;
    }

    public String rootName() {
        return this.family;
    }

    public String name() {
        return this.name;
    }

    public void start() {
        if (this.transform == null) {
            log.error("No transform for " + this.plugin + "#" + this.family + "#" + this.name);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding to beam pipeline:\n\n[{}] -> [{}]\n", (Object)(this.family + '#' + this.name), (Object)this.transform.getName());
        }
        this.get().apply(InMemoryQueueIO.from(this.state)).apply(this.transform);
    }

    public void stop() {
        PipelineInit.lazyStart(this.jobState, this);
        this.state.end();
        try {
            this.jobState.getPipelineDone().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setState(JobStateAware.State state) {
        this.jobState = state;
    }

    @Override
    public DIPipeline get() {
        return PipelineInit.ensurePipeline(Objects.requireNonNull(this.jobState, "jobState must be non null"));
    }

    public Object getDelegate() {
        return this.transform;
    }
}

