/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.javax.json.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonArrayBuilder;
import org.talend.__shade__.javax.json.JsonBuilderFactory;
import org.talend.__shade__.javax.json.JsonException;
import org.talend.__shade__.javax.json.JsonMergePatch;
import org.talend.__shade__.javax.json.JsonNumber;
import org.talend.__shade__.javax.json.JsonObject;
import org.talend.__shade__.javax.json.JsonObjectBuilder;
import org.talend.__shade__.javax.json.JsonPatch;
import org.talend.__shade__.javax.json.JsonPatchBuilder;
import org.talend.__shade__.javax.json.JsonPointer;
import org.talend.__shade__.javax.json.JsonReader;
import org.talend.__shade__.javax.json.JsonReaderFactory;
import org.talend.__shade__.javax.json.JsonString;
import org.talend.__shade__.javax.json.JsonStructure;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.javax.json.JsonWriter;
import org.talend.__shade__.javax.json.JsonWriterFactory;
import org.talend.__shade__.javax.json.stream.JsonGenerator;
import org.talend.__shade__.javax.json.stream.JsonGeneratorFactory;
import org.talend.__shade__.javax.json.stream.JsonParser;
import org.talend.__shade__.javax.json.stream.JsonParserFactory;

public abstract class JsonProvider {
    private static final String DEFAULT_PROVIDER = "org.talend.__shade__.org.apache.johnzon.core.JsonProviderImpl";

    protected JsonProvider() {
    }

    public static JsonProvider provider() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<JsonProvider>(){

                @Override
                public JsonProvider run() {
                    return JsonProvider.doLoadProvider();
                }
            });
        }
        return JsonProvider.doLoadProvider();
    }

    private static JsonProvider doLoadProvider() throws JsonException {
        String className;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl == null) {
            tccl = ClassLoader.getSystemClassLoader();
        }
        if ((className = System.getProperty(JsonProvider.class.getName())) != null) {
            try {
                return (JsonProvider)JsonProvider.class.cast(tccl.loadClass(className.trim()).newInstance());
            }
            catch (Exception e) {
                throw new JsonException("Specified provider as system property can't be loaded: " + className, e);
            }
        }
        Iterator<JsonProvider> providers = ServiceLoader.load(JsonProvider.class).iterator();
        if (providers.hasNext()) {
            return providers.next();
        }
        try {
            return (JsonProvider)JsonProvider.class.cast(tccl.loadClass(DEFAULT_PROVIDER).newInstance());
        }
        catch (Throwable cnfe) {
            throw new JsonException("org.talend.__shade__.org.apache.johnzon.core.JsonProviderImpl not found", cnfe);
        }
    }

    public abstract JsonParser createParser(Reader var1);

    public abstract JsonParser createParser(InputStream var1);

    public abstract JsonParserFactory createParserFactory(Map<String, ?> var1);

    public abstract JsonGenerator createGenerator(Writer var1);

    public abstract JsonGenerator createGenerator(OutputStream var1);

    public abstract JsonGeneratorFactory createGeneratorFactory(Map<String, ?> var1);

    public abstract JsonReader createReader(Reader var1);

    public abstract JsonReader createReader(InputStream var1);

    public abstract JsonWriter createWriter(Writer var1);

    public abstract JsonWriter createWriter(OutputStream var1);

    public abstract JsonWriterFactory createWriterFactory(Map<String, ?> var1);

    public abstract JsonReaderFactory createReaderFactory(Map<String, ?> var1);

    public abstract JsonObjectBuilder createObjectBuilder();

    public JsonObjectBuilder createObjectBuilder(JsonObject jsonObject) {
        throw new UnsupportedOperationException();
    }

    public JsonObjectBuilder createObjectBuilder(Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public abstract JsonArrayBuilder createArrayBuilder();

    public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
        throw new UnsupportedOperationException();
    }

    public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
        throw new UnsupportedOperationException();
    }

    public JsonPointer createPointer(String path) {
        throw new UnsupportedOperationException();
    }

    public abstract JsonBuilderFactory createBuilderFactory(Map<String, ?> var1);

    public JsonString createValue(String value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(int value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(long value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(double value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(BigDecimal value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(BigInteger value) {
        throw new UnsupportedOperationException();
    }

    public JsonPatch createPatch(JsonArray array) {
        throw new UnsupportedOperationException();
    }

    public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
        throw new UnsupportedOperationException();
    }

    public JsonPatchBuilder createPatchBuilder() {
        throw new UnsupportedOperationException();
    }

    public JsonPatchBuilder createPatchBuilder(JsonArray initialData) {
        throw new UnsupportedOperationException();
    }

    public JsonMergePatch createMergePatch(JsonValue patch) {
        throw new UnsupportedOperationException();
    }

    public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
        throw new UnsupportedOperationException();
    }
}

