/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.talend.__shade__.org.apache.johnzon.core.BufferStrategy;
import org.talend.__shade__.org.apache.johnzon.core.ThreadLocalBufferCache;
import org.talend.__shade__.org.apache.johnzon.core.util.ClassUtil;

public class BufferStrategyFactory {
    private static final Map<String, BufferStrategy> DEFAULT_STRATEGIES = new HashMap<String, BufferStrategy>();

    private BufferStrategyFactory() {
    }

    public static BufferStrategy valueOf(String strategyName) {
        BufferStrategy bufferStrategy = DEFAULT_STRATEGIES.get(strategyName.toUpperCase(Locale.ENGLISH));
        if (bufferStrategy == null) {
            Class<BufferStrategy> bsClass = ClassUtil.loadClassOptional(strategyName, false);
            if (bsClass == null || bsClass.isAssignableFrom(BufferStrategy.class)) {
                throw new IllegalArgumentException("Could not load Johnzon BufferStrategy " + strategyName + ". Valid BufferStrategies are " + DEFAULT_STRATEGIES.keySet().toString() + " or a fully qualified class name of an implementation of " + BufferStrategy.class.getName());
            }
            try {
                bufferStrategy = (BufferStrategy)bsClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return bufferStrategy;
    }

    static {
        DEFAULT_STRATEGIES.put("BY_INSTANCE", CharBufferByInstanceProvider::new);
        DEFAULT_STRATEGIES.put("THREAD_LOCAL", CharBufferThreadLocalProvider::new);
        DEFAULT_STRATEGIES.put("QUEUE", CharBufferQueueProvider::new);
        DEFAULT_STRATEGIES.put("SINGLETON", CharBufferSingletonProvider::new);
    }

    private static class CharBufferQueueProvider
    extends QueueProvider<char[]> {
        public CharBufferQueueProvider(int size) {
            super(size);
        }

        @Override
        protected char[] newInstance(int size) {
            return new char[size];
        }
    }

    private static abstract class QueueProvider<T>
    implements BufferStrategy.BufferProvider<T> {
        private final int size;
        private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();

        public QueueProvider(int size) {
            this.size = size;
        }

        protected abstract T newInstance(int var1);

        @Override
        public T newBuffer() {
            T buffer = this.queue.poll();
            if (buffer == null) {
                return this.newInstance(this.size);
            }
            return buffer;
        }

        @Override
        public void release(T value) {
            this.queue.offer(value);
        }
    }

    private static class CharBufferByInstanceProvider
    implements BufferStrategy.BufferProvider<char[]> {
        private final int size;

        public CharBufferByInstanceProvider(int size) {
            this.size = size;
        }

        @Override
        public char[] newBuffer() {
            return new char[this.size];
        }

        @Override
        public void release(char[] value) {
        }
    }

    private static class CharBufferThreadLocalProvider
    extends ThreadLocalProvider<char[]> {
        public CharBufferThreadLocalProvider(int size) {
            super(size);
        }

        @Override
        protected char[] newInstance(int size) {
            return new char[size];
        }
    }

    private static abstract class ThreadLocalProvider<T>
    implements BufferStrategy.BufferProvider<T> {
        private final ThreadLocalBufferCache<T> cache;

        public ThreadLocalProvider(final int size) {
            this.cache = new ThreadLocalBufferCache<T>(size){

                @Override
                protected T newValue(int defaultSize) {
                    return this.newInstance(size);
                }
            };
        }

        protected abstract T newInstance(int var1);

        @Override
        public T newBuffer() {
            return this.cache.getCache();
        }

        @Override
        public void release(T value) {
            this.cache.release(value);
        }
    }

    private static abstract class SingletonProvider<T>
    implements BufferStrategy.BufferProvider<T> {
        protected final T buffer;

        public SingletonProvider(int size) {
            this.buffer = this.newInstance(size);
        }

        protected abstract T newInstance(int var1);

        @Override
        public T newBuffer() {
            return this.buffer;
        }

        @Override
        public void release(T value) {
        }
    }

    private static class CharBufferSingletonProvider
    extends SingletonProvider<char[]> {
        public CharBufferSingletonProvider(int size) {
            super(size);
        }

        @Override
        protected char[] newInstance(int size) {
            return new char[size];
        }

        @Override
        public void release(char[] value) {
        }
    }
}

