/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.io.netty.channel;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.talend.__shade__.io.netty.channel.Channel;
import org.talend.__shade__.io.netty.channel.ChannelFuture;
import org.talend.__shade__.io.netty.channel.ChannelPromise;
import org.talend.__shade__.io.netty.channel.EventLoop;
import org.talend.__shade__.io.netty.channel.EventLoopGroup;
import org.talend.__shade__.io.netty.util.NettyRuntime;
import org.talend.__shade__.io.netty.util.concurrent.DefaultThreadFactory;
import org.talend.__shade__.io.netty.util.concurrent.EventExecutorChooserFactory;
import org.talend.__shade__.io.netty.util.concurrent.MultithreadEventExecutorGroup;
import org.talend.__shade__.io.netty.util.internal.SystemPropertyUtil;
import org.talend.__shade__.io.netty.util.internal.logging.InternalLogger;
import org.talend.__shade__.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("org.talend.__shade__.io.netty.eventLoopThreads", NettyRuntime.availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int nThreads, Executor executor, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, executor, args);
    }

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, threadFactory, args);
    }

    protected MultithreadEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, executor, chooserFactory, args);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    protected abstract EventLoop newChild(Executor var1, Object ... var2) throws Exception;

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        return this.next().register(promise);
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

