/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.talend.__shade__.org.apache.johnzon.core.BufferStrategy;
import org.talend.__shade__.org.apache.johnzon.core.BufferStrategyFactory;

public abstract class AbstractJsonFactory
implements Serializable {
    public static final String ENCODING = "org.talend.__shade__.org.apache.johnzon.encoding";
    public static final String BUFFER_STRATEGY = "org.talend.__shade__.org.apache.johnzon.buffer-strategy";
    public static final BufferStrategy DEFAULT_BUFFER_STRATEGY = BufferStrategyFactory.valueOf(System.getProperty("org.talend.__shade__.org.apache.johnzon.buffer-strategy", "QUEUE"));
    protected final Map<String, Object> internalConfig = new HashMap<String, Object>();

    protected AbstractJsonFactory(Map<String, ?> config, Collection<String> supportedConfigKeys, Collection<String> defaultSupportedConfigKeys) {
        if (config != null && !config.isEmpty()) {
            if (defaultSupportedConfigKeys != null) {
                supportedConfigKeys = new ArrayList<String>(supportedConfigKeys);
                supportedConfigKeys.addAll(defaultSupportedConfigKeys);
            }
            for (String configKey : config.keySet()) {
                if (supportedConfigKeys.contains(configKey)) {
                    this.internalConfig.put(configKey, config.get(configKey));
                    continue;
                }
                Logger.getLogger(this.getClass().getName()).warning(configKey + " is not supported by " + this.getClass().getName());
            }
        }
    }

    protected BufferStrategy getBufferProvider() {
        Object name = this.internalConfig.get(BUFFER_STRATEGY);
        if (name != null) {
            return BufferStrategyFactory.valueOf(name.toString());
        }
        return DEFAULT_BUFFER_STRATEGY;
    }

    protected int getInt(String key, int defaultValue) {
        Object intValue = this.internalConfig.get(key);
        if (intValue == null) {
            return defaultValue;
        }
        if (Number.class.isInstance(intValue)) {
            return ((Number)Number.class.cast(intValue)).intValue();
        }
        return Integer.parseInt(intValue.toString());
    }

    protected boolean getBool(String key, boolean defaultValue) {
        Object boolValue = this.internalConfig.get(key);
        if (boolValue == null) {
            return defaultValue;
        }
        if (Boolean.class.isInstance(boolValue)) {
            return (Boolean)Boolean.class.cast(boolValue);
        }
        return Boolean.parseBoolean(boolValue.toString());
    }

    protected String getString(String key, String defaultValue) {
        Object value = this.internalConfig.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (String.class.isInstance(value)) {
            return (String)String.class.cast(value);
        }
        return value.toString();
    }
}

