/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.talend.__shade__.javax.json.stream.JsonGenerator;
import org.talend.__shade__.javax.json.stream.JsonGeneratorFactory;
import org.talend.__shade__.org.apache.johnzon.core.AbstractJsonFactory;
import org.talend.__shade__.org.apache.johnzon.core.BufferStrategy;
import org.talend.__shade__.org.apache.johnzon.core.Buffered;
import org.talend.__shade__.org.apache.johnzon.core.JsonGeneratorImpl;
import org.talend.__shade__.org.apache.johnzon.core.io.BoundedOutputStreamWriter;

public class JsonGeneratorFactoryImpl
extends AbstractJsonFactory
implements JsonGeneratorFactory {
    public static final String GENERATOR_BUFFER_LENGTH = "org.talend.__shade__.org.apache.johnzon.default-char-buffer-generator";
    public static final String BOUNDED_OUTPUT_STREAM_WRITER_LEN = "org.talend.__shade__.org.apache.johnzon.boundedoutputstreamwriter";
    public static final int DEFAULT_GENERATOR_BUFFER_LENGTH = Integer.getInteger("org.talend.__shade__.org.apache.johnzon.default-char-buffer-generator", 65536);
    static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList("org.talend.__shade__.javax.json.stream.JsonGenerator.prettyPrinting", "org.talend.__shade__.org.apache.johnzon.default-char-buffer-generator", "org.talend.__shade__.org.apache.johnzon.buffer-strategy", "org.talend.__shade__.org.apache.johnzon.encoding", "org.talend.__shade__.org.apache.johnzon.boundedoutputstreamwriter");
    private final Charset defaultEncoding;
    private final boolean pretty = this.getBool("org.talend.__shade__.javax.json.stream.JsonGenerator.prettyPrinting", false);
    private final int boundedOutputStreamWriter = this.getInt("org.talend.__shade__.org.apache.johnzon.boundedoutputstreamwriter", -1);
    private final Buffer buffer;
    private volatile Buffer customBuffer;

    public JsonGeneratorFactoryImpl(Map<String, ?> config) {
        super(config, SUPPORTED_CONFIG_KEYS, null);
        this.defaultEncoding = Optional.ofNullable(config).map(c -> c.get("org.talend.__shade__.org.apache.johnzon.encoding")).map(it -> Charset.class.isInstance(it) ? (Charset)Charset.class.cast(it) : Charset.forName(it.toString())).orElse(StandardCharsets.UTF_8);
        int bufferSize = this.getInt(GENERATOR_BUFFER_LENGTH, DEFAULT_GENERATOR_BUFFER_LENGTH);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("buffer length must be greater than zero");
        }
        this.buffer = new Buffer(this.getBufferProvider().newCharProvider(bufferSize), bufferSize);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return new JsonGeneratorImpl(writer, this.getBufferProvider(writer), this.pretty);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return new JsonGeneratorImpl(this.boundedOutputStreamWriter <= 0 ? new OutputStreamWriter(out, this.defaultEncoding) : new BoundedOutputStreamWriter(out, this.defaultEncoding, this.boundedOutputStreamWriter), this.getBufferProvider(out), this.pretty);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out, Charset charset) {
        Charset cs = charset == null ? this.defaultEncoding : charset;
        return new JsonGeneratorImpl(this.boundedOutputStreamWriter <= 0 ? new OutputStreamWriter(out, cs) : new BoundedOutputStreamWriter(out, cs, this.boundedOutputStreamWriter), this.getBufferProvider(out), this.pretty);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }

    public Charset getDefaultEncoding() {
        return this.defaultEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferStrategy.BufferProvider<char[]> getBufferProvider(Flushable flushable) {
        if (!(flushable instanceof Buffered)) {
            return this.buffer.provider;
        }
        int bufferSize = ((Buffered)Buffered.class.cast(flushable)).bufferSize();
        if (this.customBuffer != null && this.customBuffer.size == bufferSize) {
            return this.customBuffer.provider;
        }
        JsonGeneratorFactoryImpl jsonGeneratorFactoryImpl = this;
        synchronized (jsonGeneratorFactoryImpl) {
            this.customBuffer = new Buffer(this.getBufferProvider().newCharProvider(bufferSize), bufferSize);
            return this.customBuffer.provider;
        }
    }

    private static final class Buffer {
        private final BufferStrategy.BufferProvider<char[]> provider;
        private final int size;

        private Buffer(BufferStrategy.BufferProvider<char[]> bufferProvider, int bufferSize) {
            this.provider = bufferProvider;
            this.size = bufferSize;
        }
    }
}

