/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.internal.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.__shade__.javax.json.bind.Jsonb;
import org.talend.__shade__.javax.json.bind.JsonbBuilder;
import org.talend.__shade__.javax.json.bind.JsonbConfig;
import org.talend.sdk.component.junit.http.api.Request;
import org.talend.sdk.component.junit.http.api.Response;
import org.talend.sdk.component.junit.http.api.ResponseLocator;
import org.talend.sdk.component.junit.http.internal.impl.ResponseImpl;

public class DefaultResponseLocator
implements ResponseLocator,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DefaultResponseLocator.class);
    public static final String PREFIX = "talend/testing/http/";
    private static final ParameterizedTypeImpl MODEL_TYPE = new ParameterizedTypeImpl((Type)((Object)Collection.class), new Type[]{Model.class});
    private final Jsonb jsonb;
    private String prefix;
    private String test;
    private final Collection<Model> capturingBuffer = new ArrayList<Model>();

    public DefaultResponseLocator(String prefix, String test) {
        this.prefix = prefix;
        this.test = test;
        this.jsonb = JsonbBuilder.create(new JsonbConfig().withPropertyOrderStrategy("LEXICOGRAPHICAL").withFormatting(true).setProperty("johnzon.cdi.activated", false));
    }

    @Override
    public Optional<Response> findMatching(Request request, Predicate<String> headerFilter) {
        ClassLoader loader;
        String pref = Optional.ofNullable(this.prefix).orElse(PREFIX);
        Optional<Response> response = this.doFind(request, pref, loader = Thread.currentThread().getContextClassLoader(), headerFilter, true);
        if (response.isPresent()) {
            return response;
        }
        return this.doFind(request, pref, loader, headerFilter, false);
    }

    protected Optional<Response> doFind(Request request, String pref, ClassLoader loader, Predicate<String> headerFilter, boolean exactMatching) {
        return Stream.of(pref + this.test + ".json", pref + this.stripQuery(request.uri()) + ".json").map(loader::getResource).filter(Objects::nonNull).flatMap(url -> {
            Collection models;
            try (InputStream stream = url.openStream();){
                models = (Collection)Collection.class.cast(this.jsonb.fromJson(stream, (Type)MODEL_TYPE));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return models.stream().filter(m -> ((Model)m).request != null && this.matches(request, ((Model)m).request, exactMatching, headerFilter));
        }).findFirst().map(model -> new ResponseImpl(((Model)model).response.headers, ((Model)model).response.status, this.getPayload((Model)model)));
    }

    protected byte[] getPayload(Model model) {
        if (model.response.payload == null) {
            return null;
        }
        return model.response.payload.getBytes(StandardCharsets.UTF_8);
    }

    private String stripQuery(String uri) {
        try {
            return new URL(uri).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            return uri;
        }
    }

    protected boolean matches(Request request, RequestModel model, boolean exact, Predicate<String> headerFilter) {
        String method = Optional.ofNullable(model.method).orElse("GET");
        String requestUri = request.uri();
        boolean headLineMatches = requestUri.equals(model.uri) && request.method().equalsIgnoreCase(method);
        String payload = request.payload();
        boolean headersMatch = this.doesHeadersMatch(request, model, headerFilter);
        if (headLineMatches && headersMatch && (model.payload == null || model.payload.equals(payload))) {
            return true;
        }
        if (exact) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Matching test: {} for {}", (Object)request, (Object)model);
        }
        if (!headLineMatches && requestUri.contains("?")) {
            headLineMatches = requestUri.substring(0, requestUri.indexOf(63)).equals(model.uri) && request.method().equalsIgnoreCase(method);
        }
        return headLineMatches && headersMatch && (model.payload == null || payload != null && (payload.matches(model.payload) || payload.equals(model.payload)));
    }

    protected boolean doesHeadersMatch(Request request, RequestModel model, Predicate<String> headerFilter) {
        Map<String, String> notcased = request.headers().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), Map.Entry::getValue));
        return model.headers == null || model.headers.entrySet().stream().filter(h -> !headerFilter.test((String)h.getKey())).allMatch(h -> ((String)h.getValue()).equals(notcased.get(((String)h.getKey()).toLowerCase())));
    }

    @Override
    public void close() {
        try {
            this.jsonb.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void flush(String baseCapture) {
        File output = new File(baseCapture, Optional.ofNullable(this.test).map(t -> this.prefix + t + ".json").orElseGet(() -> this.prefix + ".json"));
        output.getParentFile().mkdirs();
        try (FileOutputStream outputStream = new FileOutputStream(output);){
            this.jsonb.toJson(this.capturingBuffer, outputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.capturingBuffer.clear();
        }
    }

    public void addModel(Model model) {
        this.getCapturingBuffer().add(model);
    }

    public Jsonb getJsonb() {
        return this.jsonb;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTest() {
        return this.test;
    }

    public Collection<Model> getCapturingBuffer() {
        return this.capturingBuffer;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultResponseLocator)) {
            return false;
        }
        DefaultResponseLocator other = (DefaultResponseLocator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Jsonb this$jsonb = this.getJsonb();
        Jsonb other$jsonb = other.getJsonb();
        if (this$jsonb == null ? other$jsonb != null : !this$jsonb.equals(other$jsonb)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$test = this.getTest();
        String other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Collection<Model> this$capturingBuffer = this.getCapturingBuffer();
        Collection<Model> other$capturingBuffer = other.getCapturingBuffer();
        return !(this$capturingBuffer == null ? other$capturingBuffer != null : !((Object)this$capturingBuffer).equals(other$capturingBuffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultResponseLocator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Jsonb $jsonb = this.getJsonb();
        result = result * 59 + ($jsonb == null ? 43 : $jsonb.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Collection<Model> $capturingBuffer = this.getCapturingBuffer();
        result = result * 59 + ($capturingBuffer == null ? 43 : ((Object)$capturingBuffer).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultResponseLocator(jsonb=" + this.getJsonb() + ", prefix=" + this.getPrefix() + ", test=" + this.getTest() + ", capturingBuffer=" + this.getCapturingBuffer() + ")";
    }

    public static class Model {
        private RequestModel request;
        private ResponseModel response;

        public RequestModel getRequest() {
            return this.request;
        }

        public ResponseModel getResponse() {
            return this.response;
        }

        public void setRequest(RequestModel request) {
            this.request = request;
        }

        public void setResponse(ResponseModel response) {
            this.response = response;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Model)) {
                return false;
            }
            Model other = (Model)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RequestModel this$request = this.getRequest();
            RequestModel other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            ResponseModel this$response = this.getResponse();
            ResponseModel other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Model;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RequestModel $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            ResponseModel $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultResponseLocator.Model(request=" + this.getRequest() + ", response=" + this.getResponse() + ")";
        }
    }

    public static class ResponseModel {
        private int status;
        private Map<String, String> headers;
        private String payload;

        public int getStatus() {
            return this.status;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getPayload() {
            return this.payload;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseModel)) {
                return false;
            }
            ResponseModel other = (ResponseModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$payload = this.getPayload();
            String other$payload = other.getPayload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResponseModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultResponseLocator.ResponseModel(status=" + this.getStatus() + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ")";
        }
    }

    public static class RequestModel {
        private String uri;
        private String method;
        private String payload;
        private Map<String, String> headers;

        public String getUri() {
            return this.uri;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPayload() {
            return this.payload;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestModel)) {
                return false;
            }
            RequestModel other = (RequestModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$payload = this.getPayload();
            String other$payload = other.getPayload();
            if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultResponseLocator.RequestModel(uri=" + this.getUri() + ", method=" + this.getMethod() + ", payload=" + this.getPayload() + ", headers=" + this.getHeaders() + ")";
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] types;

        private ParameterizedTypeImpl(Type raw, Type ... types) {
            this.rawType = raw;
            this.types = types;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.types.clone();
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            return Arrays.hashCode(this.types) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ParameterizedType) {
                ParameterizedType that = (ParameterizedType)obj;
                Type thatRawType = that.getRawType();
                return that.getOwnerType() == null && (this.rawType == null ? thatRawType == null : this.rawType.equals(thatRawType)) && Arrays.equals(this.types, that.getActualTypeArguments());
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(((Class)this.rawType).getSimpleName());
            Type[] actualTypes = this.getActualTypeArguments();
            if (actualTypes.length > 0) {
                buffer.append("<");
                int length = actualTypes.length;
                for (int i = 0; i < length; ++i) {
                    buffer.append(actualTypes[i].toString());
                    if (i == actualTypes.length - 1) continue;
                    buffer.append(",");
                }
                buffer.append(">");
            }
            return buffer.toString();
        }
    }
}

