/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Optional;

public class Serializer {
    public static byte[] toBytes(Object delegate) {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(Optional.ofNullable(delegate.getClass().getClassLoader()).orElse(old));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(delegate);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            thread.setContextClassLoader(old);
        }
        return baos.toByteArray();
    }

    private Serializer() {
    }
}

