/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.spi.JsonProvider;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.jsonb.extension.JsonValueReader;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.record.MappingUtils;
import org.talend.sdk.component.runtime.record.json.OutputRecordHolder;
import org.talend.sdk.component.runtime.record.json.PojoJsonbProvider;

public class RecordConverters
implements Serializable {
    public <T> Record toRecord(MappingMetaRegistry registry, T data, Supplier<Jsonb> jsonbProvider, Supplier<RecordBuilderFactory> recordBuilderProvider) {
        if (data == null) {
            return null;
        }
        if (Record.class.isInstance(data)) {
            return (Record)Record.class.cast(data);
        }
        if (JsonObject.class.isInstance(data)) {
            return this.json2Record(recordBuilderProvider.get(), (JsonObject)JsonObject.class.cast(data));
        }
        MappingMeta meta = registry.find(data.getClass());
        if (meta.isLinearMapping()) {
            return meta.newRecord(data, recordBuilderProvider.get());
        }
        Jsonb jsonb = jsonbProvider.get();
        if (!String.class.isInstance(data) && !data.getClass().isPrimitive() && PojoJsonbProvider.class.isInstance(jsonb)) {
            OutputRecordHolder holder;
            Jsonb pojoMapper = (Jsonb)((PojoJsonbProvider)PojoJsonbProvider.class.cast(jsonb)).get();
            try (OutputRecordHolder stream = holder = new OutputRecordHolder(data);){
                pojoMapper.toJson(data, (Writer)stream);
            }
            return holder.getRecord();
        }
        return this.json2Record(recordBuilderProvider.get(), (JsonObject)jsonb.fromJson(jsonb.toJson(data), JsonObject.class));
    }

    private Record json2Record(RecordBuilderFactory factory, JsonObject object) {
        Record.Builder builder = factory.newRecordBuilder();
        object.forEach((key, value) -> {
            switch (value.getValueType()) {
                case ARRAY: {
                    List<Object> items = value.asJsonArray().stream().map(it -> this.mapJson(factory, (JsonValue)it)).collect(Collectors.toList());
                    builder.withArray(factory.newEntryBuilder().withName(key).withType(Schema.Type.ARRAY).withElementSchema(this.getArrayElementSchema(factory, items)).build(), items);
                    break;
                }
                case OBJECT: {
                    Record record = this.json2Record(factory, value.asJsonObject());
                    builder.withRecord(factory.newEntryBuilder().withName(key).withType(Schema.Type.RECORD).withElementSchema(record.getSchema()).build(), record);
                    break;
                }
                case TRUE: 
                case FALSE: {
                    builder.withBoolean(key, JsonValue.TRUE.equals(value));
                    break;
                }
                case STRING: {
                    builder.withString(key, ((JsonString)JsonString.class.cast(value)).getString());
                    break;
                }
                case NUMBER: {
                    JsonNumber number = (JsonNumber)JsonNumber.class.cast(value);
                    builder.withDouble(key, number.doubleValue());
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported value type: " + value);
                }
            }
        });
        return builder.build();
    }

    private Schema getArrayElementSchema(RecordBuilderFactory factory, List<Object> items) {
        if (items.isEmpty()) {
            return factory.newSchemaBuilder(Schema.Type.STRING).build();
        }
        Schema firstSchema = RecordConverters.toSchema(factory, items.iterator().next());
        switch (firstSchema.getType()) {
            case RECORD: {
                return items.stream().map(it -> RecordConverters.toSchema(factory, it)).reduce(null, (s1, s2) -> {
                    Set names2;
                    if (s1 == null) {
                        return s2;
                    }
                    if (s2 == null) {
                        return s1;
                    }
                    Set names1 = s1.getAllEntries().map(Schema.Entry::getName).collect(Collectors.toSet());
                    if (!names1.equals(names2 = s2.getAllEntries().map(Schema.Entry::getName).collect(Collectors.toSet()))) {
                        Schema.Builder builder = factory.newSchemaBuilder(Schema.Type.RECORD);
                        s1.getAllEntries().forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
                        s2.getAllEntries().filter(it -> !names1.contains(it.getName())).forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
                        return builder.build();
                    }
                    return s1;
                });
            }
        }
        return firstSchema;
    }

    private Object mapJson(RecordBuilderFactory factory, JsonValue it) {
        if (JsonObject.class.isInstance(it)) {
            return this.json2Record(factory, (JsonObject)JsonObject.class.cast(it));
        }
        if (JsonArray.class.isInstance(it)) {
            return ((JsonArray)JsonArray.class.cast(it)).stream().map(i -> this.mapJson(factory, (JsonValue)i)).collect(Collectors.toList());
        }
        if (JsonString.class.isInstance(it)) {
            return ((JsonString)JsonString.class.cast(it)).getString();
        }
        if (JsonNumber.class.isInstance(it)) {
            return ((JsonNumber)JsonNumber.class.cast(it)).numberValue();
        }
        if (JsonValue.FALSE.equals(it)) {
            return false;
        }
        if (JsonValue.TRUE.equals(it)) {
            return true;
        }
        if (JsonValue.NULL.equals(it)) {
            return null;
        }
        return it;
    }

    public static Schema toSchema(RecordBuilderFactory factory, Object next) {
        if (String.class.isInstance(next) || JsonString.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.STRING).build();
        }
        if (Integer.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.INT).build();
        }
        if (Long.class.isInstance(next) || JsonLongImpl.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.LONG).build();
        }
        if (Float.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.FLOAT).build();
        }
        if (JsonNumber.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.DOUBLE).build();
        }
        if (Double.class.isInstance(next) || JsonNumber.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.DOUBLE).build();
        }
        if (Boolean.class.isInstance(next) || JsonValue.TRUE.equals(next) || JsonValue.FALSE.equals(next)) {
            return factory.newSchemaBuilder(Schema.Type.BOOLEAN).build();
        }
        if (Date.class.isInstance(next) || ZonedDateTime.class.isInstance(next) || Instant.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.DATETIME).build();
        }
        if (BigDecimal.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.DECIMAL).build();
        }
        if (byte[].class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.BYTES).build();
        }
        if (Collection.class.isInstance(next) || JsonArray.class.isInstance(next)) {
            Collection collection = (Collection)Collection.class.cast(next);
            if (collection.isEmpty()) {
                return factory.newSchemaBuilder(Schema.Type.STRING).build();
            }
            return factory.newSchemaBuilder(Schema.Type.ARRAY).withElementSchema(RecordConverters.toSchema(factory, collection.iterator().next())).build();
        }
        if (Record.class.isInstance(next)) {
            return ((Record)Record.class.cast(next)).getSchema();
        }
        throw new IllegalArgumentException("unsupported type for " + next);
    }

    public Object toType(MappingMetaRegistry registry, Object data, Class<?> parameterType, Supplier<JsonBuilderFactory> factorySupplier, Supplier<JsonProvider> providerSupplier, Supplier<Jsonb> jsonbProvider, Supplier<RecordBuilderFactory> recordBuilderProvider) {
        return this.toType(registry, data, parameterType, factorySupplier, providerSupplier, jsonbProvider, recordBuilderProvider, Collections.emptyMap());
    }

    public Object toType(MappingMetaRegistry registry, Object data, Class<?> parameterType, Supplier<JsonBuilderFactory> factorySupplier, Supplier<JsonProvider> providerSupplier, Supplier<Jsonb> jsonbProvider, Supplier<RecordBuilderFactory> recordBuilderProvider, Map<String, String> metadata) {
        JsonObject inputAsJson;
        if (parameterType.isInstance(data)) {
            return data;
        }
        if (JsonObject.class.isInstance(data)) {
            if (JsonObject.class == parameterType) {
                return data;
            }
            inputAsJson = (JsonObject)JsonObject.class.cast(data);
        } else if (Record.class.isInstance(data)) {
            MappingMeta mappingMeta;
            Record record = (Record)Record.class.cast(data);
            if (!JsonObject.class.isAssignableFrom(parameterType) && (mappingMeta = registry.find(parameterType)).isLinearMapping()) {
                return mappingMeta.newInstance(record, metadata);
            }
            JsonObject asJson = this.toJson(factorySupplier, providerSupplier, record);
            if (JsonObject.class == parameterType) {
                return asJson;
            }
            inputAsJson = asJson;
        } else {
            if (parameterType == Record.class) {
                return this.toRecord(registry, data, jsonbProvider, recordBuilderProvider);
            }
            Jsonb jsonb = jsonbProvider.get();
            inputAsJson = (JsonObject)jsonb.fromJson(jsonb.toJson(data), JsonObject.class);
        }
        return jsonbProvider.get().fromJson((Reader)new JsonValueReader((JsonStructure)inputAsJson), parameterType);
    }

    private JsonObject toJson(Supplier<JsonBuilderFactory> factorySupplier, Supplier<JsonProvider> providerSupplier, Record record) {
        return this.buildRecord(factorySupplier.get(), providerSupplier, record).build();
    }

    private JsonObjectBuilder buildRecord(JsonBuilderFactory factory, Supplier<JsonProvider> providerSupplier, Record record) {
        Schema schema = record.getSchema();
        JsonObjectBuilder builder = factory.createObjectBuilder();
        schema.getEntries().forEach(entry -> {
            String name = entry.getName();
            switch (entry.getType()) {
                case STRING: {
                    String value = (String)record.get(String.class, name);
                    if (value == null) break;
                    builder.add(name, value);
                    break;
                }
                case INT: {
                    Integer value = (Integer)record.get(Integer.class, name);
                    if (value == null) break;
                    builder.add(name, value.intValue());
                    break;
                }
                case LONG: {
                    Long value = (Long)record.get(Long.class, name);
                    if (value == null) break;
                    builder.add(name, value.longValue());
                    break;
                }
                case FLOAT: {
                    Float value = (Float)record.get(Float.class, name);
                    if (value == null) break;
                    builder.add(name, (double)value.floatValue());
                    break;
                }
                case DOUBLE: {
                    Double value = (Double)record.get(Double.class, name);
                    if (value == null) break;
                    builder.add(name, value.doubleValue());
                    break;
                }
                case BOOLEAN: {
                    Boolean value = (Boolean)record.get(Boolean.class, name);
                    if (value == null) break;
                    builder.add(name, value.booleanValue());
                    break;
                }
                case BYTES: {
                    byte[] value = (byte[])record.get(byte[].class, name);
                    if (value == null) break;
                    builder.add(name, Base64.getEncoder().encodeToString(value));
                    break;
                }
                case DATETIME: {
                    ZonedDateTime value = (ZonedDateTime)record.get(ZonedDateTime.class, name);
                    if (value == null) break;
                    builder.add(name, value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
                    break;
                }
                case DECIMAL: {
                    BigDecimal value = (BigDecimal)record.get(BigDecimal.class, name);
                    if (value == null) break;
                    builder.add(name, value.toString());
                    break;
                }
                case RECORD: {
                    Record value = (Record)record.get(Record.class, name);
                    if (value == null) break;
                    builder.add(name, this.buildRecord(factory, providerSupplier, value));
                    break;
                }
                case ARRAY: {
                    Collection collection = (Collection)record.get(Collection.class, name);
                    if (collection == null) break;
                    if (collection.isEmpty()) {
                        builder.add(name, (JsonValue)factory.createArrayBuilder().build());
                        break;
                    }
                    Object item = collection.iterator().next();
                    if (String.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue((String)String.class.cast(v)), collection));
                        break;
                    }
                    if (Double.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Double)Double.class.cast(v)).doubleValue()), collection));
                        break;
                    }
                    if (Float.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue((double)((Float)Float.class.cast(v)).floatValue()), collection));
                        break;
                    }
                    if (Integer.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Integer)Integer.class.cast(v)).intValue()), collection));
                        break;
                    }
                    if (Long.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Long)Long.class.cast(v)).longValue()), collection));
                        break;
                    }
                    if (Boolean.class.isInstance(item)) {
                        builder.add(name, (JsonValue)this.toArray(factory, v -> (Boolean)Boolean.class.cast(v) != false ? JsonValue.TRUE : JsonValue.FALSE, collection));
                        break;
                    }
                    if (ZonedDateTime.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((ZonedDateTime)ZonedDateTime.class.cast(v)).toInstant().toEpochMilli()), collection));
                        break;
                    }
                    if (Date.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Date)Date.class.cast(v)).getTime()), collection));
                        break;
                    }
                    if (Record.class.isInstance(item)) {
                        builder.add(name, (JsonValue)this.toArray(factory, arg_0 -> this.lambda$buildRecord$14(factory, (Supplier)providerSupplier, arg_0), collection));
                        break;
                    }
                    if (!JsonValue.class.isInstance(item)) break;
                    builder.add(name, (JsonValue)this.toArray(factory, JsonValue.class::cast, collection));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + entry.getType() + " for '" + name + "'");
                }
            }
        });
        return builder;
    }

    private JsonArray toArray(JsonBuilderFactory factory, Function<Object, JsonValue> valueFactory, Collection<?> collection) {
        Collector<JsonValue, JsonArrayBuilder, JsonArray> collector = Collector.of(() -> ((JsonBuilderFactory)factory).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::addAll, JsonArrayBuilder::build, new Collector.Characteristics[0]);
        return collection.stream().map(valueFactory).collect(collector);
    }

    public <T> T coerce(Class<T> expectedType, Object value, String name) {
        if (value == null) {
            return null;
        }
        if (!expectedType.isInstance(value)) {
            return expectedType.cast(MappingUtils.coerce(expectedType, value, name));
        }
        return expectedType.cast(value);
    }

    private /* synthetic */ JsonValue lambda$buildRecord$14(JsonBuilderFactory factory, Supplier providerSupplier, Object v) {
        return this.buildRecord(factory, providerSupplier, (Record)Record.class.cast(v)).build();
    }

    public static class MappingMetaRegistry
    implements Serializable {
        protected final Map<Class<?>, MappingMeta> registry = new ConcurrentHashMap();

        private Object writeReplace() throws ObjectStreamException {
            return new Factory();
        }

        public MappingMeta find(Class<?> parameterType) {
            MappingMeta meta = this.registry.get(parameterType);
            if (meta != null) {
                return meta;
            }
            MappingMeta mappingMeta = new MappingMeta(parameterType, this);
            MappingMeta existing = this.registry.putIfAbsent(parameterType, mappingMeta);
            if (existing != null) {
                return existing;
            }
            return mappingMeta;
        }

        public Map<Class<?>, MappingMeta> getRegistry() {
            return this.registry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MappingMetaRegistry)) {
                return false;
            }
            MappingMetaRegistry other = (MappingMetaRegistry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Class<?>, MappingMeta> this$registry = this.getRegistry();
            Map<Class<?>, MappingMeta> other$registry = other.getRegistry();
            return !(this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MappingMetaRegistry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Class<?>, MappingMeta> $registry = this.getRegistry();
            result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
            return result;
        }

        public String toString() {
            return "RecordConverters.MappingMetaRegistry(registry=" + this.getRegistry() + ")";
        }

        public static class Factory
        implements Serializable {
            private Object readResolve() throws ObjectStreamException {
                return new MappingMetaRegistry();
            }
        }
    }

    public static class MappingMeta {
        private final boolean linearMapping;
        private final Class<?> rowStruct;
        private Object recordVisitor;
        private Method visitRecord;
        private Object rowStructVisitor;
        private Method visitRowStruct;

        public MappingMeta(Class<?> type, MappingMetaRegistry registry) {
            this.linearMapping = Stream.of(type.getInterfaces()).anyMatch(it -> it.getName().startsWith("routines.system."));
            this.rowStruct = type;
        }

        public Object newInstance(Record record) {
            return this.newInstance(record, Collections.emptyMap());
        }

        public Object newInstance(Record record, Map<String, String> metadata) {
            if (this.recordVisitor == null) {
                try {
                    String className = "org.talend.sdk.component.runtime.di.record.DiRecordVisitor";
                    Class<?> visitorClass = this.getClass().getClassLoader().loadClass("org.talend.sdk.component.runtime.di.record.DiRecordVisitor");
                    Constructor<?> constructor = visitorClass.getDeclaredConstructors()[0];
                    constructor.setAccessible(true);
                    this.recordVisitor = constructor.newInstance(this.rowStruct, metadata);
                    this.visitRecord = visitorClass.getDeclaredMethod("visit", Record.class);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                    if (e.getMessage().matches(".*routines.system.Dynamic.*")) {
                        throw new IllegalStateException("TOS does not support dynamic type", e);
                    }
                    throw new IllegalStateException(e);
                }
            }
            try {
                return this.visitRecord.invoke(this.recordVisitor, record);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public <T> Record newRecord(T data, RecordBuilderFactory factory) {
            if (this.rowStructVisitor == null) {
                try {
                    String className = "org.talend.sdk.component.runtime.di.record.DiRowStructVisitor";
                    Class<?> visitorClass = this.getClass().getClassLoader().loadClass("org.talend.sdk.component.runtime.di.record.DiRowStructVisitor");
                    Constructor<?> constructor = visitorClass.getConstructors()[0];
                    constructor.setAccessible(true);
                    this.rowStructVisitor = constructor.newInstance(new Object[0]);
                    this.visitRowStruct = visitorClass.getMethod("get", Object.class, RecordBuilderFactory.class);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                    if (e.getMessage().matches(".*routines.system.Dynamic.*")) {
                        throw new IllegalStateException("TOS does not support dynamic type", e);
                    }
                    throw new IllegalStateException(e);
                }
            }
            try {
                return (Record)Record.class.cast(this.visitRowStruct.invoke(this.rowStructVisitor, data, factory));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean isLinearMapping() {
            return this.linearMapping;
        }

        public Class<?> getRowStruct() {
            return this.rowStruct;
        }

        public Object getRecordVisitor() {
            return this.recordVisitor;
        }

        public Method getVisitRecord() {
            return this.visitRecord;
        }

        public Object getRowStructVisitor() {
            return this.rowStructVisitor;
        }

        public Method getVisitRowStruct() {
            return this.visitRowStruct;
        }

        public void setRecordVisitor(Object recordVisitor) {
            this.recordVisitor = recordVisitor;
        }

        public void setVisitRecord(Method visitRecord) {
            this.visitRecord = visitRecord;
        }

        public void setRowStructVisitor(Object rowStructVisitor) {
            this.rowStructVisitor = rowStructVisitor;
        }

        public void setVisitRowStruct(Method visitRowStruct) {
            this.visitRowStruct = visitRowStruct;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MappingMeta)) {
                return false;
            }
            MappingMeta other = (MappingMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isLinearMapping() != other.isLinearMapping()) {
                return false;
            }
            Class<?> this$rowStruct = this.getRowStruct();
            Class<?> other$rowStruct = other.getRowStruct();
            if (this$rowStruct == null ? other$rowStruct != null : !this$rowStruct.equals(other$rowStruct)) {
                return false;
            }
            Object this$recordVisitor = this.getRecordVisitor();
            Object other$recordVisitor = other.getRecordVisitor();
            if (this$recordVisitor == null ? other$recordVisitor != null : !this$recordVisitor.equals(other$recordVisitor)) {
                return false;
            }
            Method this$visitRecord = this.getVisitRecord();
            Method other$visitRecord = other.getVisitRecord();
            if (this$visitRecord == null ? other$visitRecord != null : !((Object)this$visitRecord).equals(other$visitRecord)) {
                return false;
            }
            Object this$rowStructVisitor = this.getRowStructVisitor();
            Object other$rowStructVisitor = other.getRowStructVisitor();
            if (this$rowStructVisitor == null ? other$rowStructVisitor != null : !this$rowStructVisitor.equals(other$rowStructVisitor)) {
                return false;
            }
            Method this$visitRowStruct = this.getVisitRowStruct();
            Method other$visitRowStruct = other.getVisitRowStruct();
            return !(this$visitRowStruct == null ? other$visitRowStruct != null : !((Object)this$visitRowStruct).equals(other$visitRowStruct));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MappingMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLinearMapping() ? 79 : 97);
            Class<?> $rowStruct = this.getRowStruct();
            result = result * 59 + ($rowStruct == null ? 43 : $rowStruct.hashCode());
            Object $recordVisitor = this.getRecordVisitor();
            result = result * 59 + ($recordVisitor == null ? 43 : $recordVisitor.hashCode());
            Method $visitRecord = this.getVisitRecord();
            result = result * 59 + ($visitRecord == null ? 43 : ((Object)$visitRecord).hashCode());
            Object $rowStructVisitor = this.getRowStructVisitor();
            result = result * 59 + ($rowStructVisitor == null ? 43 : $rowStructVisitor.hashCode());
            Method $visitRowStruct = this.getVisitRowStruct();
            result = result * 59 + ($visitRowStruct == null ? 43 : ((Object)$visitRowStruct).hashCode());
            return result;
        }

        public String toString() {
            return "RecordConverters.MappingMeta(linearMapping=" + this.isLinearMapping() + ", rowStruct=" + this.getRowStruct() + ", recordVisitor=" + this.getRecordVisitor() + ", visitRecord=" + this.getVisitRecord() + ", rowStructVisitor=" + this.getRowStructVisitor() + ", visitRowStruct=" + this.getVisitRowStruct() + ")";
        }
    }
}

