/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.input;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.runtime.input.InputImpl;
import org.talend.sdk.component.runtime.input.Streaming;

public class StreamingInputImpl
extends InputImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingInputImpl.class);
    private Streaming.RetryConfiguration retryConfiguration;
    private transient Thread shutdownHook;
    private final AtomicBoolean running = new AtomicBoolean();
    private transient Semaphore semaphore;
    private Streaming.StopStrategy stopStrategy;
    private transient long readRecords = 0L;

    public StreamingInputImpl(String rootName, String name, String plugin, Serializable instance, Streaming.RetryConfiguration retryConfiguration, Streaming.StopStrategy stopStrategy) {
        super(rootName, name, plugin, instance);
        this.shutdownHook = new Thread(() -> this.running.compareAndSet(true, false), this.getClass().getName() + "_" + this.rootName() + "-" + this.name() + "_" + this.hashCode());
        this.retryConfiguration = retryConfiguration;
        this.stopStrategy = stopStrategy;
        log.debug("[StreamingInputImpl] Created with retryStrategy: {}, stopStrategy: {}.", (Object)this.retryConfiguration, (Object)this.stopStrategy);
    }

    protected StreamingInputImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected Object readNext() {
        if (!this.running.get()) {
            return null;
        }
        if (this.stopStrategy.isActive() && this.stopStrategy.shouldStop(this.readRecords)) {
            StreamingInputImpl.log.debug("[readNext] stopStrategy condition validated.");
            return null;
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            strategy = this.retryConfiguration.getStrategy();
            retries = this.retryConfiguration.getMaxRetries();
            while (this.running.get() && retries > 0) {
                block24: {
                    block25: {
                        next = null;
                        if (!this.stopStrategy.isActive() || this.stopStrategy.getMaxActiveTime() <= -1L) break block25;
                        if (this.stopStrategy.shouldStop(this.readRecords)) {
                            StreamingInputImpl.log.debug("[readNext] shouldStop now! Duration {}ms", (Object)(System.currentTimeMillis() - this.stopStrategy.getStartedAtTime()));
                            var4_5 = null;
                            return var4_5;
                        }
                        executor = Executors.newSingleThreadExecutor();
                        reader = executor.submit((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$readNext$1(), ()Ljava/lang/Object;)((StreamingInputImpl)this));
                        maxActiveTimeWithGracePeriod = this.stopStrategy.getMaxActiveTime() + 3000L;
                        estimatedTimeout = maxActiveTimeWithGracePeriod - (System.currentTimeMillis() - this.stopStrategy.getStartedAtTime());
                        timeout = estimatedTimeout < -1L ? 10L : estimatedTimeout;
                        StreamingInputImpl.log.debug("[readNext] Applying duration strategy for reading record: will interrupt in {}ms (estimated:{} ms Duration:{}ms).", new Object[]{timeout, estimatedTimeout, maxActiveTimeWithGracePeriod});
                        try {
                            next = reader.get(timeout, TimeUnit.MILLISECONDS);
                            ** GOTO lbl-1000
                        }
                        catch (TimeoutException e) {
                            StreamingInputImpl.log.debug("[readNext] Read record: timeout received.");
                            reader.cancel(true);
                            var13_16 = next;
                            this.semaphore.release();
                            return var13_16;
                        }
                        catch (Exception var12_14) {
                            executor.shutdownNow();
                            ** break block26
                        }
                        finally {
                            executor.shutdownNow();
                        }
                    }
                    next = super.readNext();
lbl-1000:
                    // 3 sources

                    {
                        if (next == null) break block24;
                        strategy.reset();
                        ++this.readRecords;
                        executor = next;
                    }
                    return executor;
                }
                --retries;
                try {
                    millis = strategy.nextPauseDuration();
                    if (millis < 0L) {
                        this.prepareStop();
                        continue;
                    }
                    if (millis <= 0L) continue;
                    if (millis < 1000L) {
                        Thread.sleep(millis);
                        continue;
                    }
                    for (remaining = millis; this.running.get() && remaining > 0L; remaining -= current) {
                        current = Math.min(remaining, 250L);
                        Thread.sleep(current);
                    }
                }
                catch (InterruptedException e) {
                    this.prepareStop();
                }
            }
            var3_4 = null;
            return var3_4;
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.semaphore = new Semaphore(1);
    }

    @Override
    protected Object[] evaluateParameters(Class<? extends Annotation> marker, Method method) {
        if (marker != PostConstruct.class) {
            return super.evaluateParameters(marker, method);
        }
        Object[] args = new Object[method.getParameters().length];
        for (int i = 0; i < method.getParameters().length; ++i) {
            Parameter parameter = method.getParameters()[i];
            Option annotation = parameter.getAnnotation(Option.class);
            if (annotation == null) {
                args[i] = null;
                continue;
            }
            if ("maxDurationMs".equals(annotation.value())) {
                if (parameter.getType() == Integer.class || parameter.getType() == Integer.TYPE) {
                    args[i] = (int)this.stopStrategy.getMaxActiveTime();
                    continue;
                }
                if (parameter.getType() == Long.class || parameter.getType() == Long.TYPE) {
                    args[i] = this.stopStrategy.getMaxActiveTime();
                    continue;
                }
                log.warn("The parameter {} is marked as timeout but type is not long.", (Object)parameter.getName());
                args[i] = null;
                continue;
            }
            if (!"maxRecords".equals(annotation.value())) continue;
            if (parameter.getType() == Integer.class || parameter.getType() == Integer.TYPE) {
                args[i] = (int)this.stopStrategy.getMaxReadRecords();
                continue;
            }
            if (parameter.getType() == Long.class || parameter.getType() == Long.TYPE) {
                args[i] = this.stopStrategy.getMaxReadRecords();
                continue;
            }
            log.warn("The parameter {} is marked as max records limitation but type is not long.", (Object)parameter.getName());
            args[i] = null;
        }
        return args;
    }

    @Override
    public void start() {
        super.start();
        this.running.compareAndSet(false, true);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Override
    public void stop() {
        this.prepareStop();
        super.stop();
    }

    private void prepareStop() {
        this.running.compareAndSet(true, false);
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return new StreamSerializationReplacer(this.plugin(), this.rootName(), this.name(), this.serializeDelegate(), this.retryConfiguration, this.stopStrategy);
    }

    private /* synthetic */ Object lambda$readNext$1() throws Exception {
        return super.readNext();
    }

    private static class StreamSerializationReplacer
    extends InputImpl.SerializationReplacer {
        private final Streaming.RetryConfiguration retryConfiguration;
        private final Streaming.StopStrategy stopStrategy;

        StreamSerializationReplacer(String plugin, String component, String name, byte[] value, Streaming.RetryConfiguration retryConfiguration, Streaming.StopStrategy stopStrategy) {
            super(plugin, component, name, value);
            this.retryConfiguration = retryConfiguration;
            this.stopStrategy = stopStrategy;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            try {
                return new StreamingInputImpl(this.component, this.name, this.plugin, this.loadDelegate(), this.retryConfiguration, this.stopStrategy);
            }
            catch (IOException | ClassNotFoundException e) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(e.getMessage());
                invalidObjectException.initCause(e);
                throw invalidObjectException;
            }
        }
    }
}

