/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect.parameterenricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.configuration.ui.layout.GridLayout;
import org.talend.sdk.component.api.configuration.ui.layout.GridLayouts;
import org.talend.sdk.component.api.configuration.ui.meta.Ui;
import org.talend.sdk.component.api.configuration.ui.widget.DateTime;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;

public class UiParameterEnricher
extends BaseParameterEnricher {
    public static final String META_PREFIX = "tcomp::ui::";

    public Map<Type, Collection<Annotation>> getImplicitAnnotationForTypes() {
        List<DateTimeAnnotation> annotations = Collections.singletonList(new DateTimeAnnotation());
        return Stream.of(ZonedDateTime.class, LocalDateTime.class, LocalDate.class, LocalTime.class).collect(Collectors.toMap(Function.identity(), it -> annotations));
    }

    public Map<String, String> onParameterAnnotation(String parameterName, Type parameterType, Annotation annotation) {
        Ui condition = annotation.annotationType().getAnnotation(Ui.class);
        if (condition != null) {
            String prefix = META_PREFIX + annotation.annotationType().getSimpleName().toLowerCase(Locale.ENGLISH) + "::";
            if (GridLayouts.class == annotation.annotationType()) {
                return Stream.of(((GridLayouts)GridLayouts.class.cast(annotation)).value()).flatMap(a -> this.toConfig((Annotation)a, prefix.substring(0, prefix.length() - 3) + "::").entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            if (DateTime.class == annotation.annotationType()) {
                String key = "tcomp::ui::datetime";
                DateTime dateTime = (DateTime)DateTime.class.cast(annotation);
                HashMap<String, String> dtmap = new HashMap<String, String>();
                if (parameterType == LocalTime.class) {
                    dtmap.put("tcomp::ui::datetime", "time");
                    dtmap.put("tcomp::ui::datetime::useSeconds", String.valueOf(dateTime.useSeconds()));
                    return dtmap;
                }
                if (parameterType == LocalDate.class) {
                    dtmap.put("tcomp::ui::datetime", "date");
                    dtmap.put("tcomp::ui::datetime::dateFormat", String.valueOf(dateTime.dateFormat()));
                    return dtmap;
                }
                if (parameterType == LocalDateTime.class) {
                    dtmap.put("tcomp::ui::datetime", "datetime");
                    dtmap.put("tcomp::ui::datetime::dateFormat", String.valueOf(dateTime.dateFormat()));
                    dtmap.put("tcomp::ui::datetime::useSeconds", String.valueOf(dateTime.useSeconds()));
                    dtmap.put("tcomp::ui::datetime::useUTC", String.valueOf(dateTime.useUTC()));
                    return dtmap;
                }
                if (parameterType == ZonedDateTime.class || parameterType == Object.class) {
                    dtmap.put("tcomp::ui::datetime", "zoneddatetime");
                    dtmap.put("tcomp::ui::datetime::dateFormat", String.valueOf(dateTime.dateFormat()));
                    dtmap.put("tcomp::ui::datetime::useSeconds", String.valueOf(dateTime.useSeconds()));
                    dtmap.put("tcomp::ui::datetime::useUTC", String.valueOf(dateTime.useUTC()));
                    return dtmap;
                }
                throw new IllegalArgumentException("Unsupported type for @DateTime option: " + parameterType + " on " + parameterName);
            }
            return this.toConfig(annotation, prefix);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> toConfig(Annotation annotation, String prefix) {
        if (GridLayout.class == annotation.annotationType()) {
            GridLayout layout = (GridLayout)GridLayout.class.cast(annotation);
            return Stream.of(layout.names()).flatMap(name -> Stream.of(annotation.annotationType().getMethods()).filter(m -> m.getDeclaringClass() == annotation.annotationType() && !"names".equals(m.getName())).collect(Collectors.toMap(m -> prefix + name + "::" + m.getName(), m -> this.toString(annotation, (Method)m, invoke -> {
                if (invoke.getClass().isArray()) {
                    Class<?> component = invoke.getClass().getComponentType();
                    if (!Annotation.class.isAssignableFrom(component)) {
                        return null;
                    }
                    int length = Array.getLength(invoke);
                    if (length == 0) {
                        return "";
                    }
                    Collection mtds = Stream.of(component.getMethods()).filter(mtd -> mtd.getDeclaringClass() == component && "value".equals(mtd.getName())).collect(Collectors.toList());
                    StringBuilder builder = new StringBuilder("");
                    for (int i = 0; i < length; ++i) {
                        Object annot = Array.get(invoke, i);
                        mtds.forEach(p -> builder.append(this.toString((Annotation)Annotation.class.cast(annot), (Method)p, o -> null)));
                        if (i + 1 >= length) continue;
                        builder.append('|');
                    }
                    return builder.toString();
                }
                return null;
            }))).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        Map<String, String> config = Stream.of(annotation.annotationType().getMethods()).filter(m -> m.getDeclaringClass() == annotation.annotationType()).collect(Collectors.toMap(m -> prefix + m.getName(), m -> this.toString(annotation, (Method)m, invoke -> null)));
        return config.isEmpty() ? Collections.singletonMap(prefix.substring(0, prefix.length() - "::".length()), "true") : config;
    }

    private String toString(Annotation annotation, Method m, Function<Object, String> customConversions) {
        try {
            Object invoke = m.invoke((Object)annotation, new Object[0]);
            String custom = customConversions.apply(invoke);
            if (custom != null) {
                return custom;
            }
            if (String.class.isInstance(invoke)) {
                String string = String.valueOf(invoke);
                if (string.startsWith("local_configuration:")) {
                    return this.getContext().map(context -> context.getConfiguration().get(string.substring("local_configuration:".length()))).orElse(string);
                }
                return string;
            }
            if (Class.class.isInstance(invoke)) {
                return ((Class)Class.class.cast(invoke)).getSimpleName().toLowerCase(Locale.ENGLISH);
            }
            if (String[].class.isInstance(invoke)) {
                return Stream.of((String[])String[].class.cast(invoke)).collect(Collectors.joining(","));
            }
            return String.valueOf(invoke);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class DateTimeAnnotation
    implements DateTime {
        public String dateFormat = "YYYY/MM/DD";
        boolean useSeconds = true;
        boolean useUTC = true;

        public Class<? extends Annotation> annotationType() {
            return DateTime.class;
        }

        public String dateFormat() {
            return this.dateFormat;
        }

        public boolean useSeconds() {
            return this.useSeconds;
        }

        public boolean useUTC() {
            return this.useUTC;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public boolean isUseSeconds() {
            return this.useSeconds;
        }

        public boolean isUseUTC() {
            return this.useUTC;
        }

        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setUseSeconds(boolean useSeconds) {
            this.useSeconds = useSeconds;
        }

        public void setUseUTC(boolean useUTC) {
            this.useUTC = useUTC;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DateTimeAnnotation)) {
                return false;
            }
            DateTimeAnnotation other = (DateTimeAnnotation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUseSeconds() != other.isUseSeconds()) {
                return false;
            }
            if (this.isUseUTC() != other.isUseUTC()) {
                return false;
            }
            String this$dateFormat = this.getDateFormat();
            String other$dateFormat = other.getDateFormat();
            return !(this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DateTimeAnnotation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseSeconds() ? 79 : 97);
            result = result * 59 + (this.isUseUTC() ? 79 : 97);
            String $dateFormat = this.getDateFormat();
            result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
            return result;
        }

        public String toString() {
            return "UiParameterEnricher.DateTimeAnnotation(dateFormat=" + this.getDateFormat() + ", useSeconds=" + this.isUseSeconds() + ", useUTC=" + this.isUseUTC() + ")";
        }
    }
}

